/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.fx.custom_components.file.ClosablePreviewContainerController;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.ImagePreview;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewAttachmentController;
import io.olvid.windows.messenger.fx.framework.lib.Disposable;
import io.olvid.windows.messenger.fx.framework.lib.Pool;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ImageLruCache;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.CancelDraftLoadingNotification;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class DraftPreviewAttachment
extends StackPane
implements DiffUtils.NodeController<OutboundAttachment>,
LiveDataListener<Map<Id<OutboundAttachment>, Float>>,
Disposable {
    protected final ClosablePreviewContainerController previewContainer;
    private final Pool<DraftPreviewAttachment> pool;
    public final PreviewAttachmentController.Draft<ImagePreview.Draft> imagePreview;
    public final PreviewAttachmentController.Draft<FilePreview.Draft> filePreview;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private OutboundAttachment attachment;

    public DraftPreviewAttachment(ImageLruCache cache, DoubleExpression maxWidthBinding, Pool<DraftPreviewAttachment> pool) {
        this.pool = pool;
        this.previewContainer = new ClosablePreviewContainerController();
        this.previewContainer.getCloseButton().managedProperty().bind((ObservableValue)this.previewContainer.getCloseButton().visibleProperty());
        this.previewContainer.getCloseButton().setVisible(false);
        this.imagePreview = new PreviewAttachmentController.Draft<ImagePreview.Draft>(new ImagePreview.Draft(cache));
        this.filePreview = new PreviewAttachmentController.Draft<FilePreview.Draft>(new FilePreview.Draft(maxWidthBinding));
        this.getChildren().addAll((Object[])new Node[]{this.previewContainer.getLayout()});
        this.previewContainer.getCloseButton().setOnAction(event -> this.cancelPreview(this.attachment));
        this.previewContainer.getCloseButton().visibleProperty().bind((ObservableValue)this.hoverProperty());
    }

    private void cancelPreview(OutboundAttachment outboundAttachment) {
        if (outboundAttachment != null) {
            if (outboundAttachment.getStatus() == OutboundAttachmentGenerated.Status.COPYING) {
                CancelDraftLoadingNotification.fireCancelDraftNotification(outboundAttachment);
            } else if (outboundAttachment.getStatus() == OutboundAttachmentGenerated.Status.DRAFT_READY) {
                AsyncTaskExecutor.submitTask(() -> new DeleteDraftAttachmentsDbTask(outboundAttachment).run());
            }
        }
    }

    @Override
    public OutboundAttachment getValue() {
        return this.attachment;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void update(OutboundAttachment value) {
        this.attachment = value;
        if (value == null) {
            return;
        }
        FileExtension fileExtension = PreviewUtils.toFileExtension(this.attachment);
        Optional<Node> innerNode = this.previewContainer.getInnerNode();
        if (fileExtension == FileExtension.IMAGE) {
            this.imagePreview.update(value);
            if (innerNode.isEmpty() || innerNode.get() != this.imagePreview.getPreview()) {
                this.filePreview.dispose();
                this.previewContainer.setInnerNode((Region)this.imagePreview.getPreview());
            }
        } else {
            this.filePreview.update(value);
            if (innerNode.isEmpty() || innerNode.get() != this.filePreview.getPreview()) {
                this.imagePreview.dispose();
                this.previewContainer.setInnerNode((Region)this.filePreview.getPreview());
            }
        }
    }

    @Override
    public void onChange(Map<Id<OutboundAttachment>, Float> newValue, Map<Id<OutboundAttachment>, Float> oldValue) {
        if (this.attachment == null) {
            return;
        }
        Float progress = newValue.get(this.attachment.getItemId());
        Optional<Float> optionalProgress = Optional.ofNullable(progress);
        ViewControllerHelper.smartUIUpdate(() -> {
            Optional<Node> innerNode = this.previewContainer.getInnerNode();
            if (innerNode.isEmpty()) {
                return;
            }
            if (innerNode.get() == this.filePreview.getPreview()) {
                this.filePreview.updateProgress(optionalProgress);
            } else {
                this.imagePreview.updateProgress(optionalProgress);
            }
        });
    }

    @Override
    public void dispose() {
        this.imagePreview.dispose();
        this.filePreview.dispose();
        this.pool.returnObject(this);
    }

    @Override
    public AtomicBoolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean disposedVal) {
        this.disposed.set(disposedVal);
    }
}

