/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.attachments;

import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.ItemId;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Choice;
import java.sql.SQLException;
import java.util.Objects;

public class AttachmentInfos
implements Diffable {
    private final InboundAttachment inboundAttachment;
    private final OutboundAttachment outboundAttachment;
    private final OwnedAttachment ownedAttachment;

    private AttachmentInfos(InboundAttachment inboundAttachment, OutboundAttachment outboundAttachment, OwnedAttachment ownedAttachment) {
        this.inboundAttachment = inboundAttachment;
        this.outboundAttachment = outboundAttachment;
        this.ownedAttachment = ownedAttachment;
    }

    public static AttachmentInfos of(InboundAttachment inboundAttachment) {
        return new AttachmentInfos(inboundAttachment, null, null);
    }

    public static AttachmentInfos of(OutboundAttachment outboundAttachment) {
        return new AttachmentInfos(null, outboundAttachment, null);
    }

    public static AttachmentInfos of(OwnedAttachment ownedAttachment) {
        return new AttachmentInfos(null, null, ownedAttachment);
    }

    public static AttachmentInfos of(AbstractAttachmentGenerated<?> attachment) {
        if (attachment instanceof InboundAttachment) {
            return AttachmentInfos.of((InboundAttachment)attachment);
        }
        if (attachment instanceof OutboundAttachment) {
            return AttachmentInfos.of((OutboundAttachment)attachment);
        }
        if (attachment instanceof OwnedAttachment) {
            return AttachmentInfos.of((OwnedAttachment)attachment);
        }
        throw new RuntimeException("OOOPS");
    }

    public static AttachmentInfos mapRow(DatabaseResults databaseResults, String prefix) {
        try {
            if (databaseResults.getObject(databaseResults.findColumn("is_attachment")) == null) {
                return null;
            }
            if (Objects.equals(databaseResults.getString(databaseResults.findColumn("is_attachment")), "1")) {
                return AttachmentInfos.of(InboundAttachment.mapRow(databaseResults, prefix));
            }
            if (Objects.equals(databaseResults.getString(databaseResults.findColumn("is_attachment")), "0")) {
                return AttachmentInfos.of(OutboundAttachment.mapRow(databaseResults, prefix));
            }
            if (Objects.equals(databaseResults.getString(databaseResults.findColumn("is_attachment")), "2")) {
                return AttachmentInfos.of(OwnedAttachment.mapRow(databaseResults, prefix));
            }
        }
        catch (SQLException e) {
            AppLogger.e("AttachmentInfos::mapRow  Failed", e);
        }
        return null;
    }

    public ItemId getMessageId() {
        return switch (this.getKind().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ItemId.ofInbound(this.inboundAttachment.getMessageId());
            case 1 -> ItemId.ofOutbound(this.outboundAttachment.getMessageId());
            case 2 -> ItemId.ofOwned(this.ownedAttachment.getMessageId());
        };
    }

    private Kind getKind() {
        if (this.inboundAttachment != null) {
            return Kind.INBOUND;
        }
        if (this.outboundAttachment != null) {
            return Kind.OUTBOUND;
        }
        if (this.ownedAttachment != null) {
            return Kind.OWNED;
        }
        throw new IllegalStateException();
    }

    private AbstractAttachmentGenerated<?> getWeakenedAttachment() {
        if (this.inboundAttachment != null) {
            return this.inboundAttachment;
        }
        if (this.outboundAttachment != null) {
            return this.outboundAttachment;
        }
        if (this.ownedAttachment != null) {
            return this.ownedAttachment;
        }
        throw new IllegalStateException();
    }

    public Id<Fyle> getFyleId() {
        return this.getWeakenedAttachment().getFyleId();
    }

    public Id<Discussion> getDiscussionId() {
        return this.getWeakenedAttachment().getDiscussionId();
    }

    public String getFilename() {
        return this.getWeakenedAttachment().getFilename();
    }

    public String getMimeType() {
        return this.getWeakenedAttachment().getMimeType();
    }

    public Choice<ReceivedAttachmentGenerated.Status, OutboundAttachmentGenerated.Status, ReceivedAttachmentGenerated.Status> getStatus() {
        if (this.inboundAttachment != null) {
            return Choice.left(this.inboundAttachment.getStatus());
        }
        if (this.outboundAttachment != null) {
            return Choice.middle(this.outboundAttachment.getStatus());
        }
        if (this.ownedAttachment != null) {
            return Choice.right(this.ownedAttachment.getStatus());
        }
        throw new IllegalStateException();
    }

    public int getIdx() {
        return this.getWeakenedAttachment().getIdx();
    }

    public boolean isReceived() {
        return this.inboundAttachment != null || this.ownedAttachment != null;
    }

    public boolean isInbound() {
        return this.inboundAttachment != null;
    }

    public boolean isOutbound() {
        return this.outboundAttachment != null;
    }

    public boolean isOwned() {
        return this.ownedAttachment != null;
    }

    @Override
    public boolean areContentTheSame(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentInfos that = (AttachmentInfos)o;
        if (this.getKind() != that.getKind()) {
            return false;
        }
        switch (this.getKind().ordinal()) {
            case 0: {
                return this.inboundAttachment.areContentTheSame(((AttachmentInfos)o).inboundAttachment);
            }
            case 1: {
                return this.outboundAttachment.areContentTheSame(((AttachmentInfos)o).outboundAttachment);
            }
            case 2: {
                return this.ownedAttachment.areContentTheSame(((AttachmentInfos)o).ownedAttachment);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.inboundAttachment, this.outboundAttachment, this.ownedAttachment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentInfos that = (AttachmentInfos)o;
        return Objects.equals(this.inboundAttachment, that.inboundAttachment) && Objects.equals(this.outboundAttachment, that.outboundAttachment) && Objects.equals(this.ownedAttachment, that.ownedAttachment);
    }

    @Override
    public Choice<Id<InboundAttachment>, Id<OutboundAttachment>, Id<OwnedAttachment>> getItemId() {
        if (this.inboundAttachment != null) {
            return Choice.left(this.inboundAttachment.getItemId());
        }
        if (this.outboundAttachment != null) {
            return Choice.middle(this.outboundAttachment.getItemId());
        }
        if (this.ownedAttachment != null) {
            return Choice.right(this.ownedAttachment.getItemId());
        }
        throw new IllegalStateException();
    }

    public ReceivedAttachmentGenerated<?> getReceivedAttachment() {
        if (this.isInbound()) {
            return this.inboundAttachment;
        }
        if (this.isOwned()) {
            return this.ownedAttachment;
        }
        throw new NullPointerException();
    }

    public InboundAttachment getInboundAttachment() {
        Objects.requireNonNull(this.inboundAttachment);
        return this.inboundAttachment;
    }

    public OutboundAttachment getOutboundAttachment() {
        Objects.requireNonNull(this.outboundAttachment);
        return this.outboundAttachment;
    }

    public OwnedAttachment getOwnedAttachment() {
        Objects.requireNonNull(this.ownedAttachment);
        return this.ownedAttachment;
    }

    public String toString() {
        return "AttachmentInfos: " + String.valueOf(this.getItemId());
    }

    public MessageItem getMessageItem() {
        return switch (this.getKind().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Id<InboundMessage> messageId = this.inboundAttachment.getMessageId();
                InboundMessage inboundMessage = DbManager.getInstance().getInboundMessageDao().get(messageId);
                yield MessageItem.of(inboundMessage);
            }
            case 1 -> {
                Id<OutboundMessage> messageId = this.outboundAttachment.getMessageId();
                OutboundMessage outboundMessage = DbManager.getInstance().getOutboundMessageDao().get(messageId);
                yield MessageItem.of(outboundMessage);
            }
            case 2 -> {
                Id<OwnedMessage> messageId = this.ownedAttachment.getMessageId();
                OwnedMessage ownedMessage = DbManager.getInstance().getOwnedMessageDao().get(messageId);
                yield MessageItem.of(ownedMessage);
            }
        };
    }

    static enum Kind {
        INBOUND,
        OUTBOUND,
        OWNED;

    }
}

