/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.InboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OwnedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.InboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OwnedMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.InboundMessageReactionGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.OutboundMessageReactionGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.OwnedMessageReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageEditionState;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.ImagePreview;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.DraftPreviewAttachment;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.MessageWithPollInfoMLD;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageAndPollItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageListCellModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.save.AttachmentSaveUtils;
import io.olvid.windows.messenger.fx.discussions.discussion_view.search.DiscussionSearchModel;
import io.olvid.windows.messenger.fx.framework.lib.Pool;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ImageLruCache;
import io.olvid.windows.messenger.fx.misc.OpenGraphLruCache;
import io.olvid.windows.messenger.fx.modal.attachmentsViewer.AttachmentsViewerModel;
import io.olvid.windows.messenger.fx.modal.reactions_details.ReactionsDetailsModalController;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.mediator.CurrentSearchedItemLivedata;
import io.olvid.windows.messenger.livedata.mediator.DiscussionSearchResultLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageItemLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageRefLiveData;
import io.olvid.windows.messenger.livedata.mediator.PaginatedLiveData;
import io.olvid.windows.messenger.misc.DebouncedConsumer;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.SimpleOptionalProperty;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class DiscussionViewModel
implements MessageListCellModel,
AttachmentsViewerModel,
DiscussionSearchModel {
    private final LiveData<Optional<DiscussionInfoWithState>> dbSelectedDiscussion;
    private final LiveData<List<MessageItem>> messageItemListLiveData;
    private final LiveData<List<MessageAndPollItem>> messageAndPollListLiveData;
    private final MapLiveData<Id<MessageRef>, Optional<MessageRefInfo>> messageRefInfoMapLiveData;
    public final MutableLiveData<Double> scrollPositionLiveData = LiveDataFactory.buildMutableLiveData(null);
    private final LiveData<Optional<MessageItemLiveData.SortIndexInfo>> sortIndexInfoLiveData;
    private final LiveData<List<AttachmentInfos>> attachmentsListLiveData;
    private final MapLiveData<Id<InboundMessage>, List<InboundAttachment>> inboundAttachmentsPerMessageId;
    private final MapLiveData<Id<OutboundMessage>, List<OutboundAttachment>> outboundAttachmentsPerMessageId;
    private final MapLiveData<Id<OwnedMessage>, List<OwnedAttachment>> ownedAttachmentsPerMessageId;
    public final ObjectProperty<Optional<MessageEditionState>> messageEditionState = new SimpleObjectProperty(Optional.empty());
    private final ImageLruCache smallImageCache = new ImageLruCache(100L);
    private final OpenGraphLruCache openGraphLruCache = new OpenGraphLruCache(50L);
    private final LiveData<List<AttachmentInfos>> attachmentsHandleByTheViewer;
    public final DoubleExpression maxWidthBinding;
    private final Pool<ImagePreview> imagePreviewPool;
    private final Pool<FilePreview.Inbound> inboundFilePreviewPool;
    private final Pool<FilePreview.Outbound> outboundFilePreviewPool;
    private final Pool<DraftPreviewAttachment> draftPreviewPool;
    private final MapLiveData<Id<InboundMessage>, List<InboundMessageReaction>> reactionsPerInboundMessageId;
    private final MapLiveData<Id<OutboundMessage>, List<OutboundMessageReaction>> reactionsPerOutboundMessageId;
    private final MapLiveData<Id<OwnedMessage>, List<OwnedMessageReaction>> reactionsPerOwnedMessageId;
    private final MapLiveData<Id<InboundMessageEphemeralInfo>, Optional<InboundMessageEphemeralInfo>> inboundMessageEphemeralInfoPerMessageId;
    private final MapLiveData<Id<OutboundMessageEphemeralInfo>, Optional<OutboundMessageEphemeralInfo>> outboundMessageEphemeralInfoPerMessageId;
    private final MapLiveData<Id<OwnedMessageEphemeralInfo>, Optional<OwnedMessageEphemeralInfo>> ownedMessageEphemeralInfoPerMessageId;
    private final LiveData<Long> tickerLiveData;
    private final Set<Id<InboundMessage>> readInboundMessagesToAnnihilate;
    private final Set<Id<OutboundMessage>> readOutboundMessagesToAnnihilate;
    private final Set<Id<OwnedMessage>> readOwnedMessagesToAnnihilate;
    private final MapLiveData<Id<InboundMessage>, List<InboundMessageMetadata>> inboundMessageMetadataByMessageId;
    private final MapLiveData<Id<OutboundMessage>, List<OutboundMessageMetadata>> outboundMessageMetadataByMessageId;
    private final MapLiveData<Id<OwnedMessage>, List<OwnedMessageMetadata>> ownedMessageMetadataByMessageId;
    private final BooleanProperty searchMode = new SimpleBooleanProperty(false);
    private final StringProperty searchText = new SimpleStringProperty();
    private final MutableLiveData<Optional<String>> searchTextLD = new MutableLiveData(Optional.empty());
    private final SimpleOptionalProperty<SearchedItem> currentSearchedItem = new SimpleOptionalProperty();
    private final LiveData<Optional<SearchedItem>> currentSearchedItemLiveData;
    public final DiscussionSearchResultLiveData discussionSearchResultLD;
    private final DebouncedConsumer<Double> scrollDebouncer;
    private final LiveDataListener<Optional<SearchedItem>> currentSearchItemLiveDataListener = this::currentSearchedItemListener;
    private final DebouncedConsumer<Optional<String>> searchDebouncer = new DebouncedConsumer<Optional>(this.searchTextLD::postValue, "DiscussionSearch", 100L);
    private final MapLiveData<Id<PollMessage>, Optional<PollMessage>> pollMessages;
    private final MapLiveData<Id<PollMessage>, List<PollMessageVote>> pollVoteMessages;
    private final ConcurrentHashMap<Id<PollMessage>, Double> pollHeights = new ConcurrentHashMap();

    public DiscussionViewModel(LiveData<Discussion> selectedDiscussion, Region container) {
        this.dbSelectedDiscussion = LiveDataFactory.switchMap(selectedDiscussion, discussion -> {
            if (discussion != null) {
                return DbCache.getInstance().discussionInfoWithStateMapLiveData.optionalOf((Id<Discussion>)discussion.getItemId());
            }
            return null;
        });
        this.maxWidthBinding = Bindings.createDoubleBinding(() -> Math.max(container.getWidth() * 0.7, Math.min(container.getWidth() - 100.0, 150.0)), (Observable[])new Observable[]{container.widthProperty()});
        this.draftPreviewPool = new Pool<DraftPreviewAttachment>(4, 50){

            @Override
            protected DraftPreviewAttachment createObject(Pool<DraftPreviewAttachment> pool) {
                return new DraftPreviewAttachment(DiscussionViewModel.this.smallImageCache, DiscussionViewModel.this.maxWidthBinding, this);
            }
        };
        this.imagePreviewPool = new Pool<ImagePreview>(10, 40){

            @Override
            protected ImagePreview createObject(Pool<ImagePreview> pool) {
                return new ImagePreview(DiscussionViewModel.this.smallImageCache, Optional.of(pool));
            }
        };
        this.inboundFilePreviewPool = new Pool<FilePreview.Inbound>(10, 40){

            @Override
            protected FilePreview.Inbound createObject(Pool<FilePreview.Inbound> pool) {
                return new FilePreview.Inbound(DiscussionViewModel.this.maxWidthBinding, Optional.of(pool));
            }
        };
        this.outboundFilePreviewPool = new Pool<FilePreview.Outbound>(10, 40){

            @Override
            protected FilePreview.Outbound createObject(Pool<FilePreview.Outbound> pool) {
                return new FilePreview.Outbound(DiscussionViewModel.this.maxWidthBinding, Optional.of(pool));
            }
        };
        this.discussionSearchResultLD = new DiscussionSearchResultLiveData((LiveData<Optional<String>>)this.searchTextLD);
        this.currentSearchedItemLiveData = new CurrentSearchedItemLivedata(this.discussionSearchResultLD);
        this.currentSearchedItemLiveData.addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.currentSearchedItem.setValue(newValue)));
        this.searchText.addListener((observable, oldValue, newValue) -> this.searchDebouncer.run(Optional.of(newValue)));
        this.searchMode.addListener((observableValue, oldVal, newVal) -> {
            if (newVal.booleanValue() && !oldVal.booleanValue()) {
                this.currentSearchedItemLiveData.addListener(this.currentSearchItemLiveDataListener);
            } else {
                ViewControllerHelper.smartUIUpdate(() -> this.currentSearchedItem.set(Optional.empty()));
                this.currentSearchedItemLiveData.removeListener(this.currentSearchItemLiveDataListener);
            }
        });
        this.messageItemListLiveData = LiveDataFactory.switchMap(selectedDiscussion, discussion -> {
            if (discussion == null) {
                return null;
            }
            return new MessageItemLiveData((Discussion)discussion, (LiveData<Double>)this.scrollPositionLiveData, this.currentSearchedItemLiveData);
        });
        this.messageRefInfoMapLiveData = MessageRefLiveData.getMapLiveData();
        this.sortIndexInfoLiveData = LiveDataFactory.map(this.messageItemListLiveData, Optional.empty(), MessageItemLiveData.SortIndexInfo::of);
        this.messageAndPollListLiveData = new MessageWithPollInfoMLD(this.messageItemListLiveData);
        this.attachmentsListLiveData = LiveDataFactory.switchMap(selectedDiscussion, discussion -> {
            if (discussion != null) {
                return LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getInboundAttachmentDao().getDiscussionAllAttachments((Id<Discussion>)discussion.getItemId()), List.of(InboundAttachment.class, OutboundAttachment.class, OwnedAttachment.class));
            }
            return null;
        });
        this.attachmentsHandleByTheViewer = ListLiveData.filter(this.attachmentsListLiveData, info -> ImageUtils.isImage(info.getMimeType()));
        PaginatedLiveData<InboundAttachment> inboundAttachmentsListLiveData = new PaginatedLiveData<InboundAttachment>(this, InboundAttachment.class, this.sortIndexInfoLiveData){

            @Override
            protected List<InboundAttachment> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getInboundAttachmentDao().getAttachmentsForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OutboundAttachment> outboundAttachmentsListLiveData = new PaginatedLiveData<OutboundAttachment>(this, OutboundAttachment.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OutboundAttachment> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOutboundAttachmentDao().getAttachmentsForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OwnedAttachment> ownedAttachmentsListLiveData = new PaginatedLiveData<OwnedAttachment>(this, OwnedAttachment.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OwnedAttachment> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOwnedAttachmentDao().getAttachmentsForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        this.inboundAttachmentsPerMessageId = ListLiveData.filterByKey(inboundAttachmentsListLiveData, InboundAttachmentGenerated::getMessageId);
        this.outboundAttachmentsPerMessageId = ListLiveData.filterByKey(outboundAttachmentsListLiveData, OutboundAttachmentGenerated::getMessageId);
        this.ownedAttachmentsPerMessageId = ListLiveData.filterByKey(ownedAttachmentsListLiveData, OwnedAttachmentGenerated::getMessageId);
        PaginatedLiveData<InboundMessageReaction> reactionOnInboundMessageListLiveData = new PaginatedLiveData<InboundMessageReaction>(this, InboundMessageReaction.class, this.sortIndexInfoLiveData){

            @Override
            protected List<InboundMessageReaction> fetch(Id<Discussion> id, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getInboundMessageReactionDao().getAllReactionsForDiscussion(id, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OutboundMessageReaction> reactionOnOutboundMessageListLiveData = new PaginatedLiveData<OutboundMessageReaction>(this, OutboundMessageReaction.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OutboundMessageReaction> fetch(Id<Discussion> id, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOutboundMessageReactionDao().getAllReactionsForDiscussion(id, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OwnedMessageReaction> reactionOnOwnedMessageListLiveData = new PaginatedLiveData<OwnedMessageReaction>(this, OwnedMessageReaction.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OwnedMessageReaction> fetch(Id<Discussion> id, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOwnedMessageReactionDao().getAllReactionsForDiscussion(id, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        this.reactionsPerInboundMessageId = ListLiveData.filterByKey(reactionOnInboundMessageListLiveData, InboundMessageReactionGenerated::getMessageId);
        this.reactionsPerOutboundMessageId = ListLiveData.filterByKey(reactionOnOutboundMessageListLiveData, OutboundMessageReactionGenerated::getMessageId);
        this.reactionsPerOwnedMessageId = ListLiveData.filterByKey(reactionOnOwnedMessageListLiveData, OwnedMessageReactionGenerated::getMessageId);
        this.inboundMessageEphemeralInfoPerMessageId = DbManager.getInstance().getInboundMessageEphemeralInfoDao().getContextLiveData();
        this.outboundMessageEphemeralInfoPerMessageId = DbManager.getInstance().getOutboundMessageEphemeralInfoDao().getContextLiveData();
        this.ownedMessageEphemeralInfoPerMessageId = DbManager.getInstance().getOwnedMessageEphemeralInfoDao().getContextLiveData();
        this.tickerLiveData = LiveDataFactory.buildTimerLiveData(1000L, System::currentTimeMillis);
        this.readInboundMessagesToAnnihilate = ConcurrentHashMap.newKeySet();
        this.readOutboundMessagesToAnnihilate = ConcurrentHashMap.newKeySet();
        this.readOwnedMessagesToAnnihilate = ConcurrentHashMap.newKeySet();
        PaginatedLiveData<InboundMessageMetadata> inboundMessageMetadataListLiveData = new PaginatedLiveData<InboundMessageMetadata>(this, InboundMessageMetadata.class, this.sortIndexInfoLiveData){

            @Override
            protected List<InboundMessageMetadata> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getInboundMessageMetadataDao().getAllRemoteDeletedMessageMetadataForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OutboundMessageMetadata> outboundMessageMetadataListLiveData = new PaginatedLiveData<OutboundMessageMetadata>(this, OutboundMessageMetadata.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OutboundMessageMetadata> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOutboundMessageMetadataDao().getAllRemoteDeletedMessageMetadataForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        PaginatedLiveData<OwnedMessageMetadata> ownedMessageMetadataListLiveData = new PaginatedLiveData<OwnedMessageMetadata>(this, OwnedMessageMetadata.class, this.sortIndexInfoLiveData){

            @Override
            protected List<OwnedMessageMetadata> fetch(Id<Discussion> discussionId, double minSortIndex, boolean excludeMin, double maxSortIndex, boolean excludeMax) throws SQLException {
                return DbManager.getInstance().getOwnedMessageMetadataDao().getAllRemoteDeletedMessageMetadataForDiscussion(discussionId, minSortIndex, excludeMin, maxSortIndex, excludeMax);
            }
        };
        this.inboundMessageMetadataByMessageId = ListLiveData.filterByKey(inboundMessageMetadataListLiveData, InboundMessageMetadataGenerated::getMessageId);
        this.outboundMessageMetadataByMessageId = ListLiveData.filterByKey(outboundMessageMetadataListLiveData, OutboundMessageMetadataGenerated::getMessageId);
        this.ownedMessageMetadataByMessageId = ListLiveData.filterByKey(ownedMessageMetadataListLiveData, OwnedMessageMetadataGenerated::getMessageId);
        this.scrollDebouncer = new DebouncedConsumer<Double>(aDouble -> this.scrollPositionLiveData.postValue((Double)aDouble), "scrollTo", 300L);
        this.pollMessages = DbManager.getInstance().getPollMessageDao().getContextLiveData();
        this.pollVoteMessages = PollMessageVote.getVotesByPollLiveData();
    }

    private void currentSearchedItemListener(Optional<SearchedItem> newVal, Optional<SearchedItem> oldVal) {
        ViewControllerHelper.smartUIUpdate(() -> this.currentSearchedItem.setValue(newVal));
    }

    @Override
    public LiveData<Optional<DiscussionInfoWithState>> getDbSelectedDiscussion() {
        return this.dbSelectedDiscussion;
    }

    public LiveData<List<MessageItem>> getMessageListLiveData() {
        return this.messageItemListLiveData;
    }

    public LiveData<List<MessageAndPollItem>> getMessageAndPollListLiveData() {
        return this.messageAndPollListLiveData;
    }

    @Override
    public ObjectProperty<Optional<MessageEditionState>> getMessageEditionState() {
        return this.messageEditionState;
    }

    @Override
    public void doEdition(MessageEditionState editionState) {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<String> modifiedBody = editionState.getModifiedBody();
            if (modifiedBody.isEmpty()) {
                return;
            }
            if (editionState.id.isLeft()) {
                Api.getMessageApi().updateMessageBodyDbTask(editionState.id.getLeft(), modifiedBody.get());
            } else {
                Api.getMessageApi().updateOwnedMessageBodyDbTask(editionState.id.getRight(), modifiedBody.get());
            }
        });
        this.messageEditionState.set(Optional.empty());
    }

    @Override
    public void addMessageRefListener(Id<MessageRef> messageRefId, LiveDataListener<Optional<MessageRefInfo>> listener) {
        this.messageRefInfoMapLiveData.addListener(messageRefId, listener);
    }

    @Override
    public void removeMessageRefListener(Id<MessageRef> messageRefId, LiveDataListener<Optional<MessageRefInfo>> listener) {
        this.messageRefInfoMapLiveData.removeListener(messageRefId, listener);
    }

    @Override
    public LiveData<List<AttachmentInfos>> getViewerAttachmentsListLiveData() {
        return this.attachmentsHandleByTheViewer;
    }

    @Override
    public MapLiveData<Id<InboundMessage>, List<InboundAttachment>> getInboundAttachmentLiveDataPerMessage() {
        return this.inboundAttachmentsPerMessageId;
    }

    @Override
    public MapLiveData<Id<OutboundMessage>, List<OutboundAttachment>> getOutboundAttachmentLiveDataPerMessage() {
        return this.outboundAttachmentsPerMessageId;
    }

    @Override
    public MapLiveData<Id<OwnedMessage>, List<OwnedAttachment>> getOwnedAttachmentLiveDataPerMessage() {
        return this.ownedAttachmentsPerMessageId;
    }

    @Override
    public ImagePreview getImagePreview() {
        return this.imagePreviewPool.borrowObject();
    }

    @Override
    public FilePreview.Inbound getInboundFilePreview() {
        return this.inboundFilePreviewPool.borrowObject();
    }

    @Override
    public FilePreview.Outbound getOutboundFilePreview() {
        return this.outboundFilePreviewPool.borrowObject();
    }

    @Override
    public DraftPreviewAttachment getDraftPreview(OutboundAttachment outboundAttachment) {
        DraftPreviewAttachment preview = this.draftPreviewPool.borrowObject();
        preview.update(outboundAttachment);
        return preview;
    }

    @Override
    public MapLiveData<Id<InboundMessage>, List<InboundMessageReaction>> getReactionsLiveDataPerInboundMessage() {
        return this.reactionsPerInboundMessageId;
    }

    @Override
    public MapLiveData<Id<OutboundMessage>, List<OutboundMessageReaction>> getReactionsLiveDataPerOutboundMessage() {
        return this.reactionsPerOutboundMessageId;
    }

    @Override
    public MapLiveData<Id<OwnedMessage>, List<OwnedMessageReaction>> getReactionsLiveDataPerOwnedMessage() {
        return this.reactionsPerOwnedMessageId;
    }

    @Override
    public Set<Id<InboundMessage>> getReadInboundMessagesToAnnihilate() {
        return this.readInboundMessagesToAnnihilate;
    }

    @Override
    public Set<Id<OutboundMessage>> getReadOutboundMessagesToAnnihilate() {
        return this.readOutboundMessagesToAnnihilate;
    }

    @Override
    public Set<Id<OwnedMessage>> getReadOwnedMessagesToAnnihilate() {
        return this.readOwnedMessagesToAnnihilate;
    }

    @Override
    public LiveData<Long> getTickerLiveData() {
        return this.tickerLiveData;
    }

    @Override
    public MapLiveData<Id<InboundMessageEphemeralInfo>, Optional<InboundMessageEphemeralInfo>> getInboundMessageEphemeralInfoPerMessageId() {
        return this.inboundMessageEphemeralInfoPerMessageId;
    }

    @Override
    public MapLiveData<Id<OutboundMessageEphemeralInfo>, Optional<OutboundMessageEphemeralInfo>> getOutboundMessageEphemeralInfoPerMessageId() {
        return this.outboundMessageEphemeralInfoPerMessageId;
    }

    @Override
    public MapLiveData<Id<OwnedMessageEphemeralInfo>, Optional<OwnedMessageEphemeralInfo>> getOwnedMessageEphemeralInfoPerMessageId() {
        return this.ownedMessageEphemeralInfoPerMessageId;
    }

    @Override
    public MapLiveData<Id<InboundMessage>, List<InboundMessageMetadata>> getInboundMessageMetadataLiveDataPerMessage() {
        return this.inboundMessageMetadataByMessageId;
    }

    @Override
    public MapLiveData<Id<OutboundMessage>, List<OutboundMessageMetadata>> getOutboundMessageMetadataLiveDataPerMessage() {
        return this.outboundMessageMetadataByMessageId;
    }

    @Override
    public MapLiveData<Id<OwnedMessage>, List<OwnedMessageMetadata>> getOwnedMessageMetadataLiveDataPerMessage() {
        return this.ownedMessageMetadataByMessageId;
    }

    @Override
    public DoubleExpression getMaxWidthBinding() {
        return this.maxWidthBinding;
    }

    @Override
    public BooleanProperty getSearchMode() {
        return this.searchMode;
    }

    @Override
    public OpenGraphLruCache getOpenGraphLruCache() {
        return this.openGraphLruCache;
    }

    @Override
    public SimpleOptionalProperty<SearchedItem> getCurrentSearchedItem() {
        return this.currentSearchedItem;
    }

    @Override
    public LiveData<Optional<SearchedItem>> getCurrentSearchedItemLiveData() {
        return this.currentSearchedItemLiveData;
    }

    @Override
    public DiscussionSearchResultLiveData getSearchedItemsLiveData() {
        return this.discussionSearchResultLD;
    }

    @Override
    public LiveData<Optional<String>> getSearchTextLiveData() {
        return this.searchTextLD;
    }

    @Override
    public StringProperty getSearchTextProperty() {
        return this.searchText;
    }

    @Override
    public void nextSearch() {
        UIActionNC.fireNextSearchResultRequest();
    }

    @Override
    public void previousSearch() {
        UIActionNC.firePreviousSearchResultRequest();
    }

    @Override
    public void runAction(MessageView.Action action, MessageAndPollItem messageItem, EventTarget eventTarget, FlowListViewController<MessageAndPollItem> messagesListViewController) {
        Node node;
        Node target = eventTarget instanceof Node ? (node = (Node)eventTarget) : null;
        switch (action) {
            case DELETE: {
                AsyncTaskExecutor.submitTask(new DiscussionViewController.DeleteAction(messageItem, target));
                break;
            }
            case REPLY_TO: {
                AsyncTaskExecutor.submitTask(new DiscussionViewController.ReplyAction(messageItem));
                break;
            }
            case EDIT: {
                new DiscussionViewController.EditAction(messageItem, this.messageEditionState, messagesListViewController::show).run();
                break;
            }
            case FORWARD: {
                AsyncTaskExecutor.submitTask(new DiscussionViewController.ForwardAction(messageItem));
                break;
            }
            case OPEN_INFO: {
                AsyncTaskExecutor.submitTask(new DiscussionViewController.OpenInfoAction(messageItem));
                break;
            }
            case COPY: {
                new DiscussionViewController.CopyAction(messageItem).run();
                break;
            }
            case REACT_TO: {
                AsyncTaskExecutor.submitTask(new DiscussionViewController.ReactToAction(messageItem, target, this));
                break;
            }
            case REACTIONS_DETAILS: {
                new DiscussionViewController.ShowReactionDetailsAction(messageItem, this).run();
                break;
            }
            case SAVE_MEDIA: {
                this.findAttachmentFromEventTarget(eventTarget).ifPresent(attachment -> {
                    try {
                        AttachmentInfos infos = AttachmentInfos.of(attachment);
                        AttachmentSaveUtils.save(infos);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case SAVE_ALL_ATTACHMENT: {
                new DiscussionViewController.SaveAllAttachmentAction(messageItem, this).run();
            }
        }
    }

    @Override
    public void scrollChange(Double value) {
        this.scrollDebouncer.run(value);
    }

    @Override
    public DiscussionViewModel getDiscussionViewModel() {
        return this;
    }

    @Override
    public MapLiveData<Id<PollMessage>, Optional<PollMessage>> getPollMessagesLiveData() {
        return this.pollMessages;
    }

    @Override
    public MapLiveData<Id<PollMessage>, List<PollMessageVote>> getPollMessagesVoteLiveData() {
        return this.pollVoteMessages;
    }

    @Override
    public Double getPollHeight(Id<PollMessage> pollId) {
        return this.pollHeights.get(pollId);
    }

    @Override
    public void setPollHeight(Id<PollMessage> pollId, Double height) {
        this.pollHeights.put(pollId, height);
    }

    public static double estimatePollHeight(PollMessage poll) {
        int choices = poll.choices == null ? 0 : poll.choices.size();
        double base = 82.0;
        if (poll.isMultipleChoice()) {
            base += 28.0;
        }
        if (poll.getExpiration().isPresent()) {
            base += 28.0;
        }
        double perChoice = 43.0;
        return base + perChoice * (double)choices;
    }

    @Override
    public void doVote(MessageItem messageItem, PollMessage pollMessage, PollMessageChoice choice) {
        AsyncTaskExecutor.submitTask(() -> Api.getMessageApi().voteToPollMessageDbTask((AbstractUserMessageGenerated)messageItem.getWeakenedMessage(), pollMessage, choice));
    }

    public void showReactionsDetails(MessageItem messageItem) {
        ReactionsDetailsModalController controller = new ReactionsDetailsModalController(messageItem, this);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(controller, false));
    }

    private Optional<AbstractAttachmentGenerated<?>> findAttachmentFromEventTarget(EventTarget target) {
        if (target instanceof Node) {
            Node node;
            for (Node p = node = (Node)target; p != null; p = p.getParent()) {
                if (!(p instanceof ImagePreview)) continue;
                ImagePreview ip = (ImagePreview)p;
                return Optional.ofNullable(ip.getAttachment());
            }
        }
        return Optional.empty();
    }

    public record SearchedItem(SortableItemId id, int searchIdx, int idx, boolean isFirst, boolean isLast) {
    }
}

