/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.search.DiscussionSearchModel;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonBuilder;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.mediator.DiscussionSearchResultLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.RequestCardDisplayNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class DiscussionHeaderController
extends BaseViewController {
    public static final int HEADER_HEIGHT = 70;
    public final BubbleAndDescription bubbleAndDescription = new BubbleAndDescription();
    private final LiveDataListener<Optional<DiscussionInfoWithState>> onCurrentDiscussionChanged = this::onCurrentDiscussionChanged;
    private Optional<DiscussionInfoWithState> currentDiscussion = Optional.empty();
    private final SearchBarController searchBarController = new SearchBarController();
    private final Label resultLabel = new Label();
    private final DiscussionSearchModel model;

    public DiscussionHeaderController(DiscussionSearchModel searchModel) {
        this.model = searchModel;
        this.model.getDbSelectedDiscussion().addListener(this.onCurrentDiscussionChanged);
        this.bubbleAndDescription.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        AppLogger.d("CenterPanelHeaderController::initialize()");
        SvgSizeable parametersIcon = new SvgSizeable();
        parametersIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium"});
        SvgSizeable searchIcon = new SvgSizeable();
        searchIcon.getStyleClass().addAll((Object[])new String[]{"svg-search"});
        Button searchButton = new ButtonBuilder().withAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            NCRegistry.getUIActionNC().postNotification(new RequestCardDisplayNotification<Object>(UIActionNC.UserInteractionNotificationEnumType.CONTACT_SELECTED, null, true));
            this.model.getSearchMode().set(true);
        })).withGraphic((Node)searchIcon).withCustomInstance(button -> button.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button"})).build().button();
        searchButton.managedProperty().bind((ObservableValue)searchButton.visibleProperty());
        searchButton.visibleProperty().bind((ObservableValue)this.model.getSearchMode().not());
        Button doneButton = new ButtonBuilder().withAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            this.model.getSearchMode().set(false);
            this.searchBarController.textField.replaceText(null);
        })).withText(ViewControllerHelper.getString("button_label_done")).withCustomInstance(button -> button.getStyleClass().addAll((Object[])new String[]{"search-bar-done-button"})).build().button();
        doneButton.managedProperty().bind((ObservableValue)doneButton.visibleProperty());
        doneButton.visibleProperty().bind((ObservableValue)this.model.getSearchMode());
        SvgSizeable prevIcon = new SvgSizeable();
        prevIcon.getStyleClass().addAll((Object[])new String[]{"svg-chevron-up"});
        Button prevButton = new ButtonBuilder().withAction((EventHandler<MouseEvent>)((EventHandler)event -> ViewControllerHelper.smartUIUpdate(this.model::previousSearch))).withGraphic((Node)prevIcon).withCustomInstance(button -> button.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button"})).build().button();
        prevButton.managedProperty().bind((ObservableValue)prevButton.visibleProperty());
        prevButton.visibleProperty().bind((ObservableValue)this.model.getSearchMode());
        prevButton.disableProperty().bind(this.model.getCurrentSearchedItem().map(opt -> opt.map(DiscussionViewModel.SearchedItem::isFirst).orElse(true)));
        SvgSizeable nextIcon = new SvgSizeable();
        nextIcon.getStyleClass().addAll((Object[])new String[]{"svg-chevron-down"});
        Button nextButton = new ButtonBuilder().withAction((EventHandler<MouseEvent>)((EventHandler)event -> ViewControllerHelper.smartUIUpdate(this.model::nextSearch))).withGraphic((Node)nextIcon).withCustomInstance(button -> button.getStyleClass().addAll((Object[])new String[]{"transparent-icon-button"})).build().button();
        nextButton.managedProperty().bind((ObservableValue)nextButton.visibleProperty());
        nextButton.visibleProperty().bind((ObservableValue)this.model.getSearchMode());
        nextButton.disableProperty().bind(this.model.getCurrentSearchedItem().map(opt -> opt.map(DiscussionViewModel.SearchedItem::isLast).orElse(true)));
        Region searchBar = this.searchBarController.getLayout();
        this.bubbleAndDescription.centerVBox.getChildren().add((Object)searchBar);
        VBox.setMargin((Node)searchBar, (Insets)new Insets(0.0, 0.0, 0.0, 24.0));
        searchBar.managedProperty().bind((ObservableValue)searchBar.visibleProperty());
        searchBar.visibleProperty().bind((ObservableValue)this.model.getSearchMode());
        this.model.getSearchTextProperty().bind((ObservableValue)this.searchBarController.textField.plainTextProperty());
        HBox rightButtonsHBox = new HBox(8.0);
        rightButtonsHBox.setAlignment(Pos.CENTER);
        rightButtonsHBox.getChildren().addAll((Object[])new Node[]{prevButton, nextButton, doneButton, searchButton});
        this.bubbleAndDescription.rightVBox.getChildren().add((Object)rightButtonsHBox);
        this.bubbleAndDescription.setMinHeight(70.0);
        this.bubbleAndDescription.setMaxHeight(70.0);
        this.bubbleAndDescription.bubble.setCursor(Cursor.HAND);
        this.bubbleAndDescription.bubble.managedProperty().bind((ObservableValue)this.bubbleAndDescription.bubble.visibleProperty());
        this.bubbleAndDescription.bubble.visibleProperty().bind((ObservableValue)this.model.getSearchMode().not());
        this.bubbleAndDescription.getLeft().setOnMouseClicked(this::onConversationBubbleClick);
        this.bubbleAndDescription.getCenter().setOnMouseClicked(this::onConversationBubbleClick);
        this.bubbleAndDescription.title.managedProperty().bind((ObservableValue)this.bubbleAndDescription.title.visibleProperty());
        this.bubbleAndDescription.title.visibleProperty().bind((ObservableValue)this.model.getSearchMode().not());
        this.bubbleAndDescription.subtitleManagedProperty().bind((ObservableValue)this.bubbleAndDescription.subtitleVisibleProperty());
        this.bubbleAndDescription.subtitleVisibleProperty().bind((ObservableValue)this.model.getSearchMode().not());
        this.bubbleAndDescription.getStyleClass().add((Object)"light-grey-bottom-bordered-container");
        BorderPane.setMargin((Node)this.bubbleAndDescription.getLeft(), (Insets)new Insets(0.0, 12.0, 0.0, 8.0));
        BorderPane.setMargin((Node)this.bubbleAndDescription.getRight(), (Insets)new Insets(0.0, 24.0, 0.0, 16.0));
        this.searchBarController.root.getChildren().add(1, (Object)this.resultLabel);
        this.resultLabel.setText("0/0");
        this.resultLabel.getStyleClass().setAll((Object[])new String[]{"body-1-size", "grey-text"});
        this.resultLabel.managedProperty().bind((ObservableValue)this.resultLabel.visibleProperty());
        this.resultLabel.visibleProperty().bind(this.searchBarController.textField.plainTextProperty().map(s -> !s.isEmpty()));
        LiveDataListener<DiscussionSearchResultLiveData.SearchResultInfo> changeListener = (newVal, oldVal) -> ViewControllerHelper.smartUIUpdate(() -> this.updateSearchResults(newVal.searchedItems(), (Optional)this.model.getCurrentSearchedItem().getValue()));
        this.model.getSearchedItemsLiveData().addListener(changeListener);
        this.model.getCurrentSearchedItemLiveData().addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.updateSearchResults((List<? extends DiscussionViewModel.SearchedItem>)this.model.getSearchedItemsLiveData().getSearchedItems(), (Optional<DiscussionViewModel.SearchedItem>)newValue)));
        this.model.getSearchMode().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.searchBarController.textField.requestFocus();
            } else {
                this.searchBarController.textField.replaceText(null);
            }
        });
    }

    private void updateSearchResults(List<? extends DiscussionViewModel.SearchedItem> searchResult, Optional<DiscussionViewModel.SearchedItem> currentSearchItem) {
        if (searchResult.isEmpty() || currentSearchItem.isEmpty()) {
            this.resultLabel.setText("0/0");
            return;
        }
        DiscussionViewModel.SearchedItem current = currentSearchItem.get();
        int idx = Math.max(searchResult.size() - current.searchIdx(), 0);
        this.resultLabel.setText(String.format("%d/%d", idx, searchResult.size()));
    }

    private void onConversationBubbleClick(MouseEvent mouseEvent) {
        if (this.model.getSearchMode().get()) {
            return;
        }
        if (this.currentDiscussion.isEmpty()) {
            return;
        }
        DiscussionInfoWithState discussionInfo = this.currentDiscussion.get();
        switch (discussionInfo.info().kind()) {
            case CONTACT: {
                AsyncTaskExecutor.submitTask(() -> {
                    Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionInfo.id());
                    UIActionNC.fireContactSelectedNotification(discussion.getContactId(), true);
                });
                break;
            }
            case PRE_CONTACT: {
                break;
            }
            case GROUP: {
                AsyncTaskExecutor.submitTask(() -> {
                    Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionInfo.id());
                    UIActionNC.fireGroupSelectedNotification(discussion.getGroupId(), true);
                });
                break;
            }
            case PRE_GROUP: {
                break;
            }
        }
    }

    private void onCurrentDiscussionChanged(Optional<DiscussionInfoWithState> newDiscussion, Optional<DiscussionInfoWithState> oldDiscussion) {
        this.currentDiscussion = Objects.requireNonNullElse(newDiscussion, Optional.empty());
        ViewControllerHelper.smartUIUpdate(() -> {
            if (this.currentDiscussion.isEmpty()) {
                ViewControllerHelper.hideNode((Node)this.bubbleAndDescription);
                return;
            }
            DiscussionInfoWithState discussionInfo = this.currentDiscussion.get();
            ViewControllerHelper.showNode((Node)this.bubbleAndDescription);
            this.bubbleAndDescription.title.setText((String)discussionInfo.info().title().orElse(null));
            this.bubbleAndDescription.setSubtitle(discussionInfo.info().subtitle());
            BubbleUtils.setBubbleData(discussionInfo.info(), this.bubbleAndDescription.bubble);
        });
    }

    @Override
    public Region getLayout() {
        return this.bubbleAndDescription;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

