/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view;

import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageAndPollItem;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;

public class CurrentSearchedItemLivedataListener
implements LiveDataListener<Optional<DiscussionViewModel.SearchedItem>> {
    private final FlowListViewController<MessageAndPollItem> messagesListViewController;
    private Optional<DiscussionViewModel.SearchedItem> lastUnknownSearchedItem = Optional.empty();

    public CurrentSearchedItemLivedataListener(FlowListViewController<MessageAndPollItem> messageItemFlowListViewController) {
        this.messagesListViewController = messageItemFlowListViewController;
    }

    @Override
    public void onChange(Optional<DiscussionViewModel.SearchedItem> newValue, Optional<DiscussionViewModel.SearchedItem> oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue.isEmpty()) {
                return;
            }
            DiscussionViewModel.SearchedItem searchedItem = this.lastUnknownSearchedItem.orElseGet(newValue::get);
            int idx = -1;
            for (int i = 0; i < this.messagesListViewController.model.getItems().size(); ++i) {
                if (!((MessageAndPollItem)((ObjectProperty)this.messagesListViewController.model.getItems().get(i)).get()).getItemId().equals(searchedItem.id())) continue;
                idx = i;
            }
            int idxFinal = idx;
            if (idxFinal == -1) {
                this.lastUnknownSearchedItem = newValue;
                UIActionNC.fireRequestPageNotification(this.lastUnknownSearchedItem.get());
                return;
            }
            if (this.messagesListViewController.getFirstVisibleIndex() == idxFinal) {
                this.messagesListViewController.showAsFirst(idxFinal);
                this.lastUnknownSearchedItem = Optional.empty();
                return;
            }
            if (this.messagesListViewController.getLastVisibleIndex() == idxFinal) {
                this.messagesListViewController.showAsLast(idxFinal);
                this.lastUnknownSearchedItem = Optional.empty();
                return;
            }
            if (this.messagesListViewController.isVisible(idxFinal)) {
                this.lastUnknownSearchedItem = Optional.empty();
                return;
            }
            if (oldValue.isEmpty()) {
                this.messagesListViewController.showAsLast(idxFinal);
            } else {
                DiscussionViewModel.SearchedItem previous = (DiscussionViewModel.SearchedItem)oldValue.get();
                if (previous.searchIdx() < idxFinal) {
                    this.messagesListViewController.showAsFirst(idxFinal);
                } else {
                    this.messagesListViewController.showAsLast(idxFinal);
                }
            }
            this.lastUnknownSearchedItem = Optional.empty();
        });
    }
}

