/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_modal_new;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactTab;
import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactToggledList;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakDirSearchViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.NewDiscussionModalView;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionTabController;
import io.olvid.windows.messenger.fx.framework.animation.AnimationConfiguration;
import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FlowConstructor;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class NewDiscussionModalController
extends BaseModalController {
    private final VBox root = new VBox();
    private final NewDiscussionModalView view = new NewDiscussionModalView();
    private final KeycloakDirSearchViewModel keycloakDirSearchViewModel = new KeycloakDirSearchViewModel();
    private final ModalFlowController<DiscussionFlowId> flowController;
    private Runnable close;
    private PauseTransition searchDelay = new PauseTransition(Duration.millis((double)300.0));
    ContactToggledList contactToggledList;

    public NewDiscussionModalController(Runnable close, ModalFlowController<DiscussionFlowId> flowController) {
        this.close = close;
        this.flowController = flowController;
        this.build();
    }

    private void build() {
        this.root.getChildren().add((Object)this.view);
        this.root.getStyleClass().add((Object)"modal-contextual-background");
        this.root.getStylesheets().add((Object)"fx/discussions/discussion_modal_new/new_discussion.css");
        this.view.new_contact_button.setOnAction(e -> this.new_contact());
        this.view.new_group_button.setOnAction(e -> this.new_group());
        this.contactToggledList = new ContactToggledList(Optional.empty(), true, true).withExpandedLists();
        this.contactToggledList.createContactListView(this::createNewDiscussionOnClick, false, SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity, false);
        this.contactToggledList.createKeyCloakListView(this.keycloakDirSearchViewModel, Optional.empty(), Optional.of(this.close));
        this.contactToggledList.setHoverable(true);
        this.contactToggledList.init();
        VBox.setVgrow((Node)this.contactToggledList.getLayout(), (Priority)Priority.NEVER);
        VBox.setMargin((Node)this.contactToggledList.getContactToggleFilterController().getLayout(), (Insets)new Insets(24.0, 0.0, 8.0, 0.0));
        VBox.setMargin((Node)this.contactToggledList.getMainSearchBarController().getLayout(), (Insets)new Insets(12.0, 0.0, 16.0, 0.0));
        this.contactToggledList.getViewControllerManager().prepareAllControllers();
        this.view.searchBarContainer.getChildren().clear();
        this.view.searchBarContainer.getChildren().add((Object)this.contactToggledList.getMainSearchBarController().getLayout());
        this.view.scrollableContent.getChildren().add(1, (Object)this.contactToggledList.getContactToggleFilterController().getLayout());
        this.contactToggledList.getMainSearchBarController().getTextProperty().addListener((obs, oldVal, newVal) -> {
            this.searchDelay.stop();
            this.searchDelay.setOnFinished(e -> {
                boolean isEmpty = newVal == null || newVal.isBlank();
                this.animateButtonGroup((Node)this.view.new_button_container, isEmpty);
                this.contactToggledList.applySearchToAllLists((String)newVal);
                this.autoSwitchTabIfEmpty();
                if (newVal.isBlank()) {
                    this.returnToDefaultTab();
                }
            });
            this.searchDelay.playFromStart();
        });
        this.view.list_container.getChildren().add((Object)this.contactToggledList.getLayout());
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void createNewDiscussionOnClick(ContactInfo contact, Node node) {
        if (contact != null) {
            Discussion associatedDiscussion = DbManager.getInstance().getDiscussionDao().getDiscussionByContactId(contact.genId());
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, associatedDiscussion.getItemId()));
            this.close.run();
        }
    }

    private void new_contact() {
        this.flowController.setState(DiscussionTabController.DiscussionFlow.NEW_CONTACT);
    }

    private void new_group() {
        this.flowController.setState(FlowConstructor.GroupFlowStateId.MEMBER_SELECTION);
    }

    private void autoSwitchTabIfEmpty() {
        ContactTab[] priority;
        ContactTab current = (ContactTab)((Object)this.contactToggledList.getContactToggleFilterController().getTabProperty().get());
        if (this.getCount(current) > 0) {
            return;
        }
        for (ContactTab tab : priority = new ContactTab[]{ContactTab.CONTACT, ContactTab.DIRECTORY, ContactTab.OTHER}) {
            if (this.getCount(tab) <= 0) continue;
            this.selectTab(tab);
            return;
        }
        this.selectTab(ContactTab.CONTACT);
    }

    private void returnToDefaultTab() {
        ContactTab[] priority;
        for (ContactTab tab : priority = new ContactTab[]{ContactTab.CONTACT, ContactTab.DIRECTORY, ContactTab.OTHER}) {
            if (this.getCount(tab) <= 0) continue;
            this.selectTab(tab);
            return;
        }
        this.selectTab(ContactTab.CONTACT);
    }

    private void selectTab(ContactTab tab) {
        switch (tab) {
            case CONTACT: {
                this.contactToggledList.getContactToggleFilterController().selectContact();
                break;
            }
            case OTHER: {
                this.contactToggledList.getContactToggleFilterController().selectOther();
                break;
            }
            case DIRECTORY: {
                this.contactToggledList.getContactToggleFilterController().selectDirectory();
            }
        }
    }

    private int getCount(ContactTab tab) {
        return switch (tab) {
            default -> throw new MatchException(null, null);
            case ContactTab.CONTACT -> this.contactToggledList.getFilteredCount(ContactTab.CONTACT);
            case ContactTab.OTHER -> this.contactToggledList.getFilteredCount(ContactTab.OTHER);
            case ContactTab.DIRECTORY -> this.contactToggledList.getFilteredCount(ContactTab.DIRECTORY);
        };
    }

    private void animateButtonGroup(Node containerNode, boolean show) {
        AnimationConfiguration.AnimationEnumType animType = show ? AnimationConfiguration.AnimationEnumType.EXPAND_IN : AnimationConfiguration.AnimationEnumType.COLLAPSE_OUT;
        AnimationConfiguration config = new AnimationConfiguration(animType, 0.0, containerNode, null);
        Animation animation = AnimationUtils.buildAnimation(config);
        if (animation != null) {
            animation.play();
        }
    }
}

