/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.toggle_switch;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class SizableRectangle
extends Rectangle {
    private static final String STYLE_CLASS = "stylable-rectangle";
    private static final StyleablePropertyFactory<SizableRectangle> FACTORY = new StyleablePropertyFactory(Rectangle.getClassCssMetaData());
    private static final CssMetaData<SizableRectangle, Number> HEIGHT = FACTORY.createSizeCssMetaData("-fx-height", s -> s.styleableHeight, (Number)24, false);
    private static final CssMetaData<SizableRectangle, Number> WIDTH = FACTORY.createSizeCssMetaData("-fx-width", s -> s.styleableWidth, (Number)46, false);
    private final StyleableProperty<Number> styleableHeight = new SimpleStyleableObjectProperty(HEIGHT, (Object)this, "height");
    private final StyleableProperty<Number> styleableWidth = new SimpleStyleableObjectProperty(WIDTH, (Object)this, "width");

    public SizableRectangle() {
        this.bind();
    }

    public SizableRectangle(double width, double height) {
        super(width, height);
        this.initStyleableSize();
        this.bind();
    }

    public SizableRectangle(double width, double height, Paint fill) {
        super(width, height, fill);
        this.initStyleableSize();
        this.bind();
    }

    public SizableRectangle(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.initStyleableSize();
        this.bind();
    }

    private void initStyleableSize() {
        this.styleableWidth.setValue((Object)this.getWidth());
        this.styleableHeight.setValue((Object)this.getHeight());
    }

    private void bind() {
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.styleableHeight.setValue((Object)((Number)HEIGHT.getInitialValue((Styleable)this)));
        this.styleableWidth.setValue((Object)((Number)WIDTH.getInitialValue((Styleable)this)));
        this.widthProperty().bind(this.styleableWidthDurationProperty());
        this.heightProperty().bind(this.styleableHeightDurationProperty());
    }

    public Number getStyleableHeight() {
        return (Number)this.styleableHeight.getValue();
    }

    public Number getStyleableWidth() {
        return (Number)this.styleableWidth.getValue();
    }

    public ObjectProperty<Number> styleableWidthDurationProperty() {
        return (ObjectProperty)this.styleableWidth;
    }

    public ObjectProperty<Number> styleableHeightDurationProperty() {
        return (ObjectProperty)this.styleableHeight;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

