/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.toggle_switch;

import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class PaneColorTransition
extends Transition {
    private final Pane pane;
    private final ObjectProperty<Color> colorTo = new SimpleObjectProperty();
    private final ObjectProperty<Color> colorFrom = new SimpleObjectProperty();

    public PaneColorTransition(Pane pane, Color colorFrom, Color colorTo, Duration duration) {
        this.pane = pane;
        this.setCycleDuration(duration);
        this.setInterpolator(Interpolator.EASE_BOTH);
        this.colorTo.set((Object)colorTo);
        this.colorFrom.set((Object)colorFrom);
    }

    public void setDuration(Duration duration) {
        this.setCycleDuration(duration);
    }

    protected void interpolate(double frac) {
        Color interpolateColor = new Color(((Color)this.colorTo.get()).getRed() * frac + ((Color)this.colorFrom.get()).getRed() * (1.0 - frac), ((Color)this.colorTo.get()).getGreen() * frac + ((Color)this.colorFrom.get()).getGreen() * (1.0 - frac), ((Color)this.colorTo.get()).getBlue() * frac + ((Color)this.colorFrom.get()).getBlue() * (1.0 - frac), 1.0);
        if (this.pane.getBackground() != null && this.pane.getBackground().getFills() != null) {
            BackgroundFill backgroundFill = (BackgroundFill)this.pane.getBackground().getFills().get(0);
            this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)interpolateColor, backgroundFill.getRadii(), backgroundFill.getInsets())}));
        } else {
            this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)interpolateColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    public void init(boolean start) {
        this.interpolate(start ? 0.0 : 1.0);
    }

    public Color getColorTo() {
        return (Color)this.colorTo.get();
    }

    public ObjectProperty<Color> colorToProperty() {
        return this.colorTo;
    }

    public void setColorTo(Color colorTo) {
        this.colorTo.set((Object)colorTo);
    }

    public Color getColorFrom() {
        return (Color)this.colorFrom.get();
    }

    public ObjectProperty<Color> colorFromProperty() {
        return this.colorFrom;
    }

    public void setColorFrom(Color colorFrom) {
        this.colorFrom.set((Object)colorFrom);
    }
}

