/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.loader;

import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import java.util.Collection;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Arc;
import javafx.util.Duration;

public class RingProgressIndicatorSkin
implements Skin<RingProgressIndicator> {
    private final RingProgressIndicator indicator;
    private final StackPane container = new StackPane();
    private final Arc fillerArc = new Arc();
    private final RotateTransition transition = new RotateTransition(Duration.millis((double)1500.0), (Node)this.fillerArc);

    public RingProgressIndicatorSkin(RingProgressIndicator indicator) {
        this.indicator = indicator;
        this.initContainer(indicator);
        this.initFillerArc();
        this.container.widthProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterX((double)(newVal.intValue() / 2)));
        this.container.heightProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterY((double)(newVal.intValue() / 2)));
        this.updateRadii();
        this.indicator.indeterminateProperty().addListener((o, oldVal, newVal) -> this.initIndeterminate((boolean)newVal));
        this.indicator.progressProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.intValue() >= 0) {
                this.fillerArc.setLength((double)newVal.intValue() * -3.6);
            }
        });
        this.indicator.ringWidthProperty().addListener((o, oldVal, newVal) -> this.updateRadii());
        this.initTransition();
        this.initIndeterminate(indicator.isIndeterminate());
        indicator.visibleProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue() && this.indicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.container.getChildren().addAll((Object[])new Node[]{this.fillerArc});
    }

    private void initTransition() {
        this.transition.setAutoReverse(false);
        this.transition.setCycleCount(-1);
        this.transition.setDelay(Duration.ZERO);
        this.transition.setInterpolator(Interpolator.LINEAR);
        this.transition.setByAngle(360.0);
    }

    private void initFillerArc() {
        this.fillerArc.setManaged(false);
        this.fillerArc.getStyleClass().add((Object)"ring-indicator-filler");
        this.fillerArc.setStartAngle(90.0);
        this.fillerArc.setLength((double)this.indicator.getProgress() * -3.6);
    }

    private void initContainer(RingProgressIndicator indicator) {
        this.container.getStylesheets().addAll((Collection)indicator.getStylesheets());
        this.container.getStyleClass().addAll((Object[])new String[]{"circleindicator-container"});
        this.container.setPrefWidth((indicator.getInnerCircleRadius() + indicator.getRingWidth()) * 2.0);
        this.container.setPrefWidth((indicator.getInnerCircleRadius() + indicator.getRingWidth()) * 2.0);
    }

    private void updateRadii() {
        double ringWidth = this.indicator.getRingWidth();
        double innerCircleRadius = this.indicator.getInnerCircleRadius();
        this.fillerArc.setRadiusY(innerCircleRadius - 1.0 + ringWidth / 2.0);
        this.fillerArc.setRadiusX(innerCircleRadius - 1.0 + ringWidth / 2.0);
        this.fillerArc.setStrokeWidth(ringWidth);
    }

    private void initIndeterminate(boolean newVal) {
        if (newVal) {
            this.fillerArc.setLength(360.0);
            this.fillerArc.getStyleClass().add((Object)"indeterminate");
            if (this.indicator.isVisible()) {
                this.transition.play();
            }
        } else {
            this.fillerArc.getStyleClass().remove((Object)"indeterminate");
            this.fillerArc.setRotate(0.0);
            this.transition.stop();
        }
    }

    public RingProgressIndicator getSkinnable() {
        return this.indicator;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.transition.stop();
    }
}

