/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.loader;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;

abstract class ProgressCircleIndicator
extends Control {
    private static final int INDETERMINATE_PROGRESS = -1;
    private ReadOnlyIntegerWrapper progress = new ReadOnlyIntegerWrapper(0);
    private ReadOnlyBooleanWrapper indeterminate = new ReadOnlyBooleanWrapper(false);
    private DoubleProperty innerCircleRadius = new StyleableDoubleProperty(8.0){

        public Object getBean() {
            return ProgressCircleIndicator.this;
        }

        public String getName() {
            return "innerCircleRadius";
        }

        public CssMetaData<ProgressCircleIndicator, Number> getCssMetaData() {
            return StyleableProperties.INNER_CIRCLE_RADIUS;
        }
    };

    public ProgressCircleIndicator() {
        this.getStylesheets().add((Object)ViewControllerHelper.class.getClassLoader().getResource("fx/custom_ui_components/circleprogress.css").toExternalForm());
    }

    public int getProgress() {
        return this.progress.get();
    }

    public void setProgress(int progressValue) {
        this.progress.set(this.defaultToHundred(progressValue));
        this.indeterminate.set(progressValue < 0);
    }

    public ReadOnlyIntegerProperty progressProperty() {
        return this.progress.getReadOnlyProperty();
    }

    public boolean isIndeterminate() {
        return this.indeterminate.get();
    }

    public void makeIndeterminate() {
        this.setProgress(-1);
    }

    public ReadOnlyBooleanProperty indeterminateProperty() {
        return this.indeterminate.getReadOnlyProperty();
    }

    private int defaultToHundred(int value) {
        if (value > 100) {
            return 100;
        }
        return value;
    }

    public final void setInnerCircleRadius(int value) {
        this.innerCircleRadiusProperty().set((double)value);
    }

    public final DoubleProperty innerCircleRadiusProperty() {
        return this.innerCircleRadius;
    }

    public final double getInnerCircleRadius() {
        return this.innerCircleRadiusProperty().get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ProgressCircleIndicator, Number> INNER_CIRCLE_RADIUS = new CssMetaData<ProgressCircleIndicator, Number>("-fx-inner-radius", StyleConverter.getSizeConverter(), (Number)7){

            public boolean isSettable(ProgressCircleIndicator n) {
                return n.innerCircleRadiusProperty() == null || !n.innerCircleRadiusProperty().isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ProgressCircleIndicator n) {
                return (StyleableProperty)n.innerCircleRadiusProperty();
            }
        };
        public static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<ProgressCircleIndicator, Number>> styleables = new ArrayList<CssMetaData<ProgressCircleIndicator, Number>>(Control.getClassCssMetaData());
            styleables.add(INNER_CIRCLE_RADIUS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

