/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.loader;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class LoadingScreenController
extends BaseViewController {
    StackPane loading_container = new StackPane();
    private long lastProgressUpdateMilli;
    private final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();

    public LoadingScreenController() {
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(14);
        this.ringProgressIndicator.setRingWidth(2);
        this.loading_container.getChildren().add((Object)this.ringProgressIndicator);
    }

    public StackPane getLayout() {
        return this.loading_container;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public void setProgressIndicator(Double progress) {
        if (System.currentTimeMillis() > this.lastProgressUpdateMilli + 150L) {
            this.ringProgressIndicator.setProgress((int)(progress * 100.0));
            this.lastProgressUpdateMilli = System.currentTimeMillis();
        }
    }

    public static void runAsyncTaskWithLoader(Runnable task, Pane parent) {
        ViewControllerHelper.smartUIUpdate(() -> {
            LoadingScreenController loadingScreenController = LoadingScreenController.addLoaderToParent(parent);
            AsyncTaskExecutor.submitTask(() -> {
                task.run();
                ViewControllerHelper.smartUIUpdate(() -> parent.getChildren().remove((Object)loadingScreenController.getLayout()));
            });
        });
    }

    public static void runAsyncTaskWithProgression(Consumer<DoubleProperty> task, Pane parent) {
        ViewControllerHelper.smartUIUpdate(() -> {
            LoadingScreenController loadingScreenController = LoadingScreenController.addLoaderToParent(parent);
            AsyncTaskExecutor.submitTask(() -> {
                SimpleDoubleProperty progress = new SimpleDoubleProperty();
                progress.addListener((observable, oldValue, newValue) -> ViewControllerHelper.smartUIUpdate(() -> loadingScreenController.setProgressIndicator(newValue.doubleValue())));
                task.accept((DoubleProperty)progress);
                ViewControllerHelper.smartUIUpdate(() -> parent.getChildren().remove((Object)loadingScreenController.getLayout()));
            });
        });
    }

    private static LoadingScreenController addLoaderToParent(Pane parent) {
        LoadingScreenController loadingScreenController = new LoadingScreenController();
        loadingScreenController.getLayout().prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        loadingScreenController.getLayout().prefWidthProperty().bind((ObservableValue)parent.widthProperty());
        parent.getChildren().add((Object)loadingScreenController.getLayout());
        return loadingScreenController;
    }
}

