/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.icon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineJoin;

public class SvgSizeable
extends Group {
    public static final String RABBIT_PATH = "";
    private final DoubleProperty ratioMin = new SimpleDoubleProperty();
    public SVGPath defaultSVG;
    private final StyleableDoubleProperty width = new SimpleStyleableDoubleProperty(WIDTH_META_DATA, (Object)this, "finalWidth");
    private final StyleableDoubleProperty height = new SimpleStyleableDoubleProperty(HEIGHT_META_DATA, (Object)this, "finalHeight");
    public final StyleableStringProperty shape = new SimpleStyleableStringProperty(SHAPE_META_DATA, (Object)this, "shape");
    private final StyleableBooleanProperty stroke = new SimpleStyleableBooleanProperty(STROKE_META_DATA, (Object)this, "stroke");
    private final StyleableBooleanProperty keepRatio = new SimpleStyleableBooleanProperty(RATIO_META_DATA, (Object)this, "ratio");
    public final StyleableObjectProperty<Paint> paint = new SimpleStyleableObjectProperty(COLOR_META_DATA, (Object)this, "paint");
    public final StyleableObjectProperty<FillRule> fillRule = new SimpleStyleableObjectProperty(FILL_RULE_META_DATA, (Object)this, "fillRule", (Object)FillRule.EVEN_ODD);
    public final StyleableObjectProperty<Number[]> viewBoxSize = new SimpleStyleableObjectProperty(VIEW_BOX_META_DATA, (Object)this, "viewBoxWidth");
    public final StyleableObjectProperty<Double> strokeWidth = new SimpleStyleableObjectProperty(STROKE_WIDTH, (Object)this, "strokeWidth");
    private Rectangle backgroundRectangle;
    private static final List<CssMetaData<? extends Styleable, ?>> CLASS_CSS_META_DATA;
    private static final CssMetaData<SvgSizeable, Number> WIDTH_META_DATA;
    private static final CssMetaData<SvgSizeable, Number> HEIGHT_META_DATA;
    private static final CssMetaData<SvgSizeable, String> SHAPE_META_DATA;
    private static final CssMetaData<SvgSizeable, Boolean> STROKE_META_DATA;
    private static final CssMetaData<SvgSizeable, Boolean> RATIO_META_DATA;
    private static final CssMetaData<SvgSizeable, Paint> COLOR_META_DATA;
    private static final CssMetaData<SvgSizeable, FillRule> FILL_RULE_META_DATA;
    private static final CssMetaData<SvgSizeable, Number[]> VIEW_BOX_META_DATA;
    private static final CssMetaData<SvgSizeable, Double> STROKE_WIDTH;

    public SvgSizeable() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"icon");
        this.defaultSVG = new SVGPath();
        this.defaultSVG.getStyleClass().add((Object)"svg");
        this.defaultSVG.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.backgroundRectangle = new Rectangle();
        this.backgroundRectangle.setFill((Paint)Color.TRANSPARENT);
        this.getChildren().add((Object)this.backgroundRectangle);
        this.getChildren().add((Object)this.defaultSVG);
        this.height.set(20.0);
        this.width.set(20.0);
        this.keepRatio.set(true);
        this.viewBoxSize.set((Object)new Integer[]{0, 0, 20, 20});
        this.shape.set(RABBIT_PATH);
        this.stroke.set(false);
        this.paint.set((Object)Color.BLACK);
        this.strokeWidth.set((Object)1.0);
        this.ratioMin.bind((ObservableValue)Bindings.min((ObservableNumberValue)this.width.divide((ObservableNumberValue)this.backgroundRectangle.widthProperty()), (ObservableNumberValue)this.height.divide((ObservableNumberValue)this.backgroundRectangle.heightProperty())));
        this.bind();
    }

    protected void bind(SVGPath svgPath, StyleableStringProperty shape) {
        svgPath.contentProperty().bind((ObservableValue)shape);
        svgPath.fillProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.stroke.not()).then(this.paint).otherwise((Object)Color.TRANSPARENT));
        svgPath.strokeProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.stroke).then(this.paint).otherwise((Object)Color.TRANSPARENT));
        svgPath.fillRuleProperty().bind(this.fillRule);
        svgPath.strokeWidthProperty().bind(this.strokeWidth);
        svgPath.scaleXProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.keepRatio).then((ObservableNumberValue)this.ratioMin).otherwise((ObservableNumberValue)this.width.divide((ObservableNumberValue)this.backgroundRectangle.widthProperty())));
        svgPath.scaleYProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.keepRatio).then((ObservableNumberValue)this.ratioMin).otherwise((ObservableNumberValue)this.height.divide((ObservableNumberValue)this.backgroundRectangle.heightProperty())));
    }

    private void bind() {
        this.bind(this.defaultSVG, this.shape);
        this.backgroundRectangle.scaleXProperty().bind((ObservableValue)this.width.divide((ObservableNumberValue)this.backgroundRectangle.widthProperty()));
        this.backgroundRectangle.scaleYProperty().bind((ObservableValue)this.height.divide((ObservableNumberValue)this.backgroundRectangle.heightProperty()));
        this.backgroundRectangle.heightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((Number[])this.viewBoxSize.get())[3].doubleValue(), (Observable[])new Observable[]{this.viewBoxSize, this.keepRatio}));
        this.backgroundRectangle.widthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((Number[])this.viewBoxSize.get())[2].doubleValue(), (Observable[])new Observable[]{this.viewBoxSize, this.keepRatio}));
        this.backgroundRectangle.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((Number[])this.viewBoxSize.get())[0].doubleValue(), (Observable[])new Observable[]{this.viewBoxSize, this.keepRatio}));
        this.backgroundRectangle.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ((Number[])this.viewBoxSize.get())[1].doubleValue(), (Observable[])new Observable[]{this.viewBoxSize, this.keepRatio}));
    }

    public Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public StyleableObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint.set((Object)paint);
    }

    public double getWidth() {
        return this.width.get();
    }

    public StyleableDoubleProperty widthProperty() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public double getHeight() {
        return this.height.get();
    }

    public StyleableDoubleProperty heightProperty() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height.set(height);
    }

    public boolean isKeepRatio() {
        return this.keepRatio.get();
    }

    public StyleableBooleanProperty keepRatioProperty() {
        return this.keepRatio;
    }

    public void setKeepRatio(boolean keepRatio) {
        this.keepRatio.set(keepRatio);
    }

    public FillRule getFillRule() {
        return (FillRule)this.fillRule.get();
    }

    public StyleableObjectProperty<FillRule> fillRuleProperty() {
        return this.fillRule;
    }

    public void setFillRule(FillRule fillRule) {
        this.fillRule.set((Object)fillRule);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CLASS_CSS_META_DATA;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CLASS_CSS_META_DATA;
    }

    static {
        WIDTH_META_DATA = new CssMetaData<SvgSizeable, Number>("-fx-width", StyleConverter.getSizeConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.width.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(SvgSizeable styleable) {
                return styleable.width;
            }
        };
        HEIGHT_META_DATA = new CssMetaData<SvgSizeable, Number>("-fx-height", StyleConverter.getSizeConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.height.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(SvgSizeable styleable) {
                return styleable.height;
            }
        };
        SHAPE_META_DATA = new CssMetaData<SvgSizeable, String>("-fx-shape", StyleConverter.getStringConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.shape.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(SvgSizeable styleable) {
                return styleable.shape;
            }
        };
        STROKE_META_DATA = new CssMetaData<SvgSizeable, Boolean>("-fx-is-stroke", StyleConverter.getBooleanConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.stroke.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(SvgSizeable styleable) {
                return styleable.stroke;
            }
        };
        RATIO_META_DATA = new CssMetaData<SvgSizeable, Boolean>("-fx-ratio", StyleConverter.getBooleanConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.keepRatio.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(SvgSizeable styleable) {
                return styleable.keepRatio;
            }
        };
        COLOR_META_DATA = new CssMetaData<SvgSizeable, Paint>("-fx-color", StyleConverter.getPaintConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.paint.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SvgSizeable styleable) {
                return styleable.paint;
            }
        };
        FILL_RULE_META_DATA = new CssMetaData<SvgSizeable, FillRule>("-fx-fill-rule", StyleConverter.getEnumConverter(FillRule.class)){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.fillRule.isBound();
            }

            public StyleableProperty<FillRule> getStyleableProperty(SvgSizeable styleable) {
                return styleable.fillRule;
            }
        };
        VIEW_BOX_META_DATA = new CssMetaData<SvgSizeable, Number[]>("-fx-view-box", new StyleConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.viewBoxSize.isBound();
            }

            public StyleableProperty<Number[]> getStyleableProperty(SvgSizeable styleable) {
                return styleable.viewBoxSize;
            }
        };
        STROKE_WIDTH = new CssMetaData<SvgSizeable, Double>("-fx-stroke-width", new StyleConverter()){

            public boolean isSettable(SvgSizeable styleable) {
                return !styleable.strokeWidth.isBound();
            }

            public StyleableProperty<Double> getStyleableProperty(SvgSizeable styleable) {
                return styleable.strokeWidth;
            }
        };
        List parent = Group.getClassCssMetaData();
        List<CssMetaData> additional = Arrays.asList(HEIGHT_META_DATA, WIDTH_META_DATA, VIEW_BOX_META_DATA, SHAPE_META_DATA, COLOR_META_DATA, STROKE_META_DATA, RATIO_META_DATA, FILL_RULE_META_DATA, STROKE_WIDTH);
        ArrayList<CssMetaData> own = new ArrayList<CssMetaData>(parent.size() + additional.size());
        own.addAll(parent);
        own.addAll(additional);
        CLASS_CSS_META_DATA = Collections.unmodifiableList(own);
    }
}

