/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.file;

import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewState;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.misc.ImageUtils;
import java.io.File;
import java.net.URLConnection;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Rectangle;

public class PreviewUtils {
    private PreviewUtils() {
    }

    public static FileExtension toFileExtension(AbstractAttachmentGenerated<?> attachment) {
        return PreviewUtils.toFileExtension(AttachmentUtils.getNonNullMimeType(attachment));
    }

    public static FileExtension toFileExtension(File file) {
        return PreviewUtils.toFileExtension(URLConnection.getFileNameMap().getContentTypeFor(file.getName()));
    }

    private static FileExtension toFileExtension(String mimeType) {
        if (mimeType == null) {
            return FileExtension.UNKNOWN;
        }
        if (ImageUtils.isImage(mimeType)) {
            return FileExtension.IMAGE;
        }
        if (ImageUtils.isLink(mimeType)) {
            return FileExtension.LINK;
        }
        if (ImageUtils.isVideo(mimeType)) {
            return FileExtension.VIDEO;
        }
        if (mimeType.startsWith("audio/")) {
            return FileExtension.AUDIO;
        }
        if (mimeType.equals("application/msword") || mimeType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return FileExtension.DOC;
        }
        if (mimeType.equals("application/vnd.ms-excel") || mimeType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") || mimeType.equals("text/csv")) {
            return FileExtension.TABULAR_DATA;
        }
        if (mimeType.startsWith("text/")) {
            return FileExtension.DOC;
        }
        if (mimeType.equals("application/vnd.ms-powerpoint") || mimeType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return FileExtension.PPT;
        }
        if (mimeType.equals("application/pdf")) {
            return FileExtension.PDF;
        }
        return FileExtension.UNKNOWN;
    }

    public static String convertFileSize(long bytes) {
        double fileSize;
        if (bytes < 0L) {
            throw new IllegalArgumentException("File size cannot be negative.");
        }
        String[] units = ViewControllerHelper.getString("unit_file_size").split(" ");
        int unitIndex = 0;
        for (fileSize = (double)bytes; fileSize >= 1000.0 && unitIndex < units.length - 1; fileSize /= 1000.0, ++unitIndex) {
        }
        String roundedFileSize = unitIndex > 0 ? String.format("%.2f", fileSize) : String.format("%s", (int)fileSize);
        return roundedFileSize + " " + units[unitIndex];
    }

    public static String getIconColorStyleClass(FileExtension fileExtension) {
        return switch (fileExtension) {
            case FileExtension.AUDIO -> "icon-color-audio";
            case FileExtension.DOC -> "icon-color-doc";
            case FileExtension.TABULAR_DATA -> "icon-color-data-tab";
            case FileExtension.PDF -> "icon-color-pdf";
            case FileExtension.PPT -> "icon-color-ppt";
            default -> "icon-color-unknown";
        };
    }

    public static String getIconCircleStyleClass(FileExtension fileExtension) {
        return switch (fileExtension) {
            case FileExtension.AUDIO -> "icon-circle-audio";
            case FileExtension.DOC -> "icon-circle-doc";
            case FileExtension.TABULAR_DATA -> "icon-circle-data-tab";
            case FileExtension.PDF -> "icon-circle-pdf";
            case FileExtension.PPT -> "icon-circle-ppt";
            default -> "icon-circle-unknown";
        };
    }

    public static String getIconStyleClass(FileExtension fileExtension) {
        return switch (fileExtension) {
            case FileExtension.AUDIO -> "svg-attachment-mp3";
            case FileExtension.DOC -> "svg-attachment-docx";
            case FileExtension.TABULAR_DATA -> "svg-attachment-xls";
            case FileExtension.PDF -> "svg-attachment-pdf";
            case FileExtension.PPT -> "svg-attachment-presentation";
            default -> "svg-attachment-other";
        };
    }

    public static String[] getActionStyle(boolean inbound, PreviewState state) {
        String[] toRet = new String[]{inbound ? "icon-grey" : "icon-white", state.getStyle(), "icon-medium"};
        return toRet;
    }

    public static Rectangle createImageSizeRectangle(ImageView imageView, int arcRadius) {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)imageView.fitWidthProperty());
        rectangle.heightProperty().bind((ObservableValue)imageView.fitHeightProperty());
        rectangle.setArcWidth((double)arcRadius);
        rectangle.setArcHeight((double)arcRadius);
        return rectangle;
    }

    public static void setStyleOnNode(Node nodeTarget, String ... classes) {
        if (classes == null) {
            return;
        }
        nodeTarget.getStyleClass().setAll((Object[])classes);
    }

    public static interface Preview {
        public Node getLayout();

        public void dispose();

        public AbstractAttachmentGenerated<?> getAttachment();

        public void update(AbstractAttachmentGenerated<?> var1, String var2, FileExtension var3, Optional<Long> var4, PreviewState var5);

        public void setProgress(Optional<Float> var1);

        public void setAction(Optional<Runnable> var1);
    }
}

