/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.file;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewState;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.fx.misc.OpenGraphHelper;
import io.olvid.windows.messenger.fx.misc.OpenGraphLruCache;
import io.olvid.windows.messenger.fx.misc.TitleAndSubtitle;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public abstract class LinkPreview
extends TitleAndSubtitle
implements PreviewUtils.Preview {
    private AbstractAttachmentGenerated<?> attachment;
    protected ImageView imageView = new ImageView();
    private final ObjectProperty<OpenGraph> openGraph = new SimpleObjectProperty();
    public final OpenGraphLruCache openGraphLruCache;
    private final BooleanProperty isLoading = new SimpleBooleanProperty(false);

    public LinkPreview(OpenGraphLruCache openGraphLruCache, DoubleExpression maxWidthBinding) {
        this.openGraphLruCache = openGraphLruCache;
        this.getCenter().getStyleClass().add((Object)"link-preview");
        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
        this.getSubtitleStyleClass().setAll((Object[])new String[]{"description"});
        this.bindMaxWidth(maxWidthBinding);
        this.imageView.setPreserveRatio(true);
        this.title.maxWidthProperty().bind((ObservableValue)this.maxWidthProperty());
        this.centerVBox.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.subtitleMaxWidthProperty().bind((ObservableValue)this.maxWidthProperty());
    }

    protected void bindMaxWidth(DoubleExpression maxWidthBinding) {
        this.maxWidthProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)maxWidthBinding, (int)400));
    }

    @Override
    public Node getLayout() {
        return this;
    }

    @Override
    public void setTitle(String title) {
        if (!StringUtils.isEmpty(title)) {
            this.title.setText(title);
            ViewControllerHelper.showNode((Node)this.title);
        } else {
            ViewControllerHelper.hideNode((Node)this.title);
        }
    }

    public void setDescription(String description) {
        if (!StringUtils.isEmpty(description)) {
            this.setSubtitle(description);
            this.getSubtitleVisible(true);
        } else {
            this.getSubtitleVisible(false);
        }
    }

    @Override
    public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
        this.attachment = attachment;
        AsyncTaskExecutor.submitTask(() -> {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
            if (fyle == null) {
                AppLogger.w("PreviewAttachment::update fyle null for attachement id : " + String.valueOf(attachment.getItemId()));
                return;
            }
            if (fyle.getSha256().isPresent()) {
                this.setImageData(ImageHelper.ImageData.of((Id<Fyle>)fyle.getItemId(), fyle.getFilePath(), fyle.getSha256().get(), attachment.getMimeType()));
            }
        });
    }

    @Override
    public AbstractAttachmentGenerated<?> getAttachment() {
        return this.attachment;
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
    }

    public void setImageData(ImageHelper.ImageData imageData) {
        if (imageData == null) {
            return;
        }
        this.openGraphLruCache.compute(imageData, result -> {
            if (result.isFailure()) {
                AppLogger.e("LinkPreview::setImageData.asyncGet Error while computing preview for attachment; error :" + String.valueOf(result.getFailure()));
                ViewControllerHelper.smartUIUpdate(() -> this.updateLinkPreview(Optional.empty()));
            } else {
                ViewControllerHelper.smartUIUpdate(() -> this.updateLinkPreview(Optional.of((OpenGraphLruCache.OpenGraphWrapper)result.getSuccess())));
            }
        }, data -> {
            Result<OpenGraph, Throwable> result = OpenGraphHelper.loadOpenGraph(data.path());
            return result.map(OpenGraphLruCache.OpenGraphWrapper::new);
        }, Optional.of(this.isLoading));
    }

    @Override
    public void dispose() {
        this.openGraph.set(null);
        this.imageView.setImage(null);
        this.title.setText("");
        this.clearSubtitle();
    }

    public void updateLinkPreview(Optional<OpenGraphLruCache.OpenGraphWrapper> openGraphOptional) {
        openGraphOptional.ifPresentOrElse(openGraph1 -> this.setTitle(openGraph1.getTitle()), () -> this.setTitle(null));
        openGraphOptional.ifPresentOrElse(graph -> this.setImage(graph.getImage()), () -> this.setImage(null));
    }

    @Override
    public void setAction(Optional<Runnable> action) {
    }

    @Override
    public void setProgress(Optional<Float> progress) {
    }
}

