/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.file;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewState;
import io.olvid.windows.messenger.fx.discussions.discussion_view.save.AttachmentSaveUtils;
import io.olvid.windows.messenger.fx.framework.lib.Disposable;
import io.olvid.windows.messenger.fx.framework.lib.Pool;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.ImageLruCache;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class ImagePreview
extends StackPane
implements PreviewUtils.Preview,
Disposable {
    private AbstractAttachmentGenerated<?> attachment;
    public final DoubleProperty width = new SimpleDoubleProperty(200.0);
    public final DoubleProperty height = new SimpleDoubleProperty(100.0);
    public final ImageView previewImageView = new ImageView();
    private final IntegerProperty rotation = new SimpleIntegerProperty();
    final ObservableBooleanValue isRotated90 = this.rotation.isEqualTo(90);
    final ObservableBooleanValue isRotated270 = this.rotation.isEqualTo(270);
    final ObservableBooleanValue isRotated = Bindings.or((ObservableBooleanValue)this.isRotated90, (ObservableBooleanValue)this.isRotated270);
    private final ObjectProperty<Image> image = new SimpleObjectProperty();
    private final HBox downloadButton;
    private final Label size;
    private final Optional<Pool<ImagePreview>> pool;
    private final AtomicReference<Id<Fyle>> currentFyleId = new AtomicReference<Object>(null);
    private final ImageLruCache imageLruCache;
    public StringProperty moreAttachmentsCount = new SimpleStringProperty("");
    private final ObjectProperty<PreviewState> stateProperty = new SimpleObjectProperty();
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    private final BooleanProperty isLoading = new SimpleBooleanProperty(false);

    public ImagePreview(ImageLruCache imageLruCache, Optional<Pool<ImagePreview>> pool) {
        this.pool = pool;
        this.previewImageView.fitWidthProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.isRotated).then((ObservableNumberValue)this.height).otherwise((ObservableNumberValue)this.width));
        this.previewImageView.fitHeightProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.isRotated).then((ObservableNumberValue)this.width).otherwise((ObservableNumberValue)this.height));
        this.previewImageView.setPreserveRatio(true);
        this.previewImageView.rotateProperty().bind((ObservableValue)this.rotation);
        this.previewImageView.imageProperty().bind(this.image);
        this.previewImageView.visibleProperty().bind((ObservableValue)this.stateProperty.isEqualTo((Object)PreviewState.READY).or((ObservableBooleanValue)this.stateProperty.isEqualTo((Object)PreviewState.UPLOADING)));
        this.imageLruCache = imageLruCache;
        VBox moreAttachmentsMask = new VBox();
        moreAttachmentsMask.setId("moreAttachmentsMask");
        moreAttachmentsMask.getStyleClass().add((Object)"attachment-more-container");
        Label label = new Label();
        label.textProperty().bind((ObservableValue)this.moreAttachmentsCount);
        label.getStyleClass().add((Object)"attachment-more-label");
        moreAttachmentsMask.getChildren().add((Object)label);
        moreAttachmentsMask.visibleProperty().bind((ObservableValue)this.moreAttachmentsCount.isEmpty().not());
        this.size = new Label();
        this.size.getStyleClass().add((Object)"body-2");
        SvgSizeable downloadIcon = new SvgSizeable();
        downloadIcon.getStyleClass().setAll((Object[])new String[]{"icon-medium", "icon-grey", "svg-download"});
        StackPane iconCon = new StackPane(new Node[]{downloadIcon});
        iconCon.setPadding(new Insets(0.0, 4.0, 8.0, 0.0));
        this.downloadButton = new HBox(new Node[]{iconCon, this.size});
        this.downloadButton.setAlignment(Pos.CENTER);
        this.downloadButton.managedProperty().bind((ObservableValue)this.downloadButton.visibleProperty());
        this.downloadButton.visibleProperty().bind((ObservableValue)this.stateProperty.isEqualTo((Object)PreviewState.DOWNLOADABLE).and((ObservableBooleanValue)moreAttachmentsMask.visibleProperty().not()));
        SvgSizeable saveIcon = new SvgSizeable();
        saveIcon.getStyleClass().setAll((Object[])new String[]{"icon-medium", "icon-grey", "svg-save"});
        StackPane savePill = new StackPane(new Node[]{saveIcon});
        savePill.setPadding(new Insets(4.0));
        savePill.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(8.0), Insets.EMPTY)}));
        savePill.setStyle("-fx-cursor: hand;");
        savePill.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        StackPane.setAlignment((Node)savePill, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)savePill, (Insets)new Insets(4.0));
        savePill.visibleProperty().bind((ObservableValue)moreAttachmentsMask.visibleProperty().not().and((ObservableBooleanValue)this.stateProperty.isEqualTo((Object)PreviewState.READY).or((ObservableBooleanValue)this.stateProperty.isEqualTo((Object)PreviewState.UPLOADING))));
        savePill.setOnMouseClicked(event -> {
            event.consume();
            try {
                AttachmentInfos infos = AttachmentInfos.of(this.attachment);
                AttachmentSaveUtils.save(infos);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Erreur lors de la cr\u00e9ation de AttachmentInfos : " + e.getMessage());
            }
        });
        this.ringProgressIndicator.managedProperty().bind((ObservableValue)this.ringProgressIndicator.visibleProperty());
        this.ringProgressIndicator.visibleProperty().bind((ObservableValue)this.stateProperty.isEqualTo((Object)PreviewState.PROCESSING).or((ObservableBooleanValue)this.stateProperty.isEqualTo((Object)PreviewState.UPLOADING)));
        this.getChildren().addAll((Object[])new Node[]{new Group(new Node[]{this.previewImageView}), moreAttachmentsMask, this.downloadButton, this.ringProgressIndicator});
        if (!(this instanceof Draft)) {
            this.getChildren().add((Object)savePill);
        }
        this.prefWidthProperty().bind((ObservableValue)this.width);
        this.prefHeightProperty().bind((ObservableValue)this.height);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, null, null)}));
        this.previewImageView.fitHeightProperty().addListener((observable, oldValue, newValue) -> this.updateViewPort());
        this.previewImageView.fitWidthProperty().addListener((observable, oldValue, newValue) -> this.updateViewPort());
    }

    @Override
    public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
        boolean imageReady;
        this.attachment = attachment;
        if (attachment instanceof OutboundAttachment) {
            imageReady = true;
        } else {
            boolean bl = imageReady = state == PreviewState.READY;
        }
        if (size.isEmpty()) {
            this.size.setText("");
        } else {
            this.size.setText(PreviewUtils.convertFileSize(size.get()));
        }
        this.stateProperty.set((Object)state);
        if (!imageReady) {
            return;
        }
        this.currentFyleId.set(attachment.getFyleId());
        AsyncTaskExecutor.submitTask(() -> {
            if (!attachment.getFyleId().equals(this.currentFyleId.get())) {
                return;
            }
            Fyle fyle = DbManager.getInstance().getFyleDao().get(attachment.getFyleId());
            if (fyle == null) {
                AppLogger.w("PreviewAttachment::update fyle null for attachement id : " + String.valueOf(attachment.getItemId()));
                return;
            }
            if (fyle.getSha256().isEmpty()) {
                return;
            }
            ImageHelper.ImageData imageData = new ImageHelper.ImageData((Id<Fyle>)fyle.getItemId(), fyle.getFilePath(), fyle.getSha256().get(), attachment.getMimeType());
            ViewControllerHelper.smartUIUpdate(() -> fyle.getSha256().ifPresent(bytes -> this.setImageData(imageData)));
        });
    }

    @Override
    public AbstractAttachmentGenerated<?> getAttachment() {
        return this.attachment;
    }

    private void setImageData(ImageHelper.ImageData imageData) {
        if (imageData == null) {
            return;
        }
        this.imageLruCache.compute(imageData, result -> {
            if (result.isSuccess()) {
                this.updateImage(imageData, (ImageHelper.ImageInfo)result.getSuccess());
            } else {
                this.image.set(null);
            }
        }, ImageHelper::computeImage, Optional.of(this.isLoading));
    }

    @Override
    public void dispose() {
        this.stateProperty.set((Object)PreviewState.PROCESSING);
        this.currentFyleId.set(null);
        this.moreAttachmentsCount.set((Object)"");
        this.image.set(null);
        this.rotation.set(0);
        this.pool.ifPresent(imagePreviewPool -> imagePreviewPool.returnObject(this));
    }

    private void updateImage(ImageHelper.ImageData key, ImageHelper.ImageInfo imageInfo) {
        if (!key.fyleId().equals(this.currentFyleId.get())) {
            return;
        }
        AppLogger.t("PreviewUtils::updateImage Setting preview for attachment");
        Image image = imageInfo.image();
        this.image.set((Object)image);
        Optional<ImageUtils.Orientation> orientationOpt = imageInfo.orientation();
        if (orientationOpt.isPresent()) {
            ImageUtils.Orientation orientation = orientationOpt.get();
            this.rotation.set(orientation.rotation());
        } else {
            this.rotation.set(0);
        }
        this.updateViewPort();
    }

    private void updateViewPort() {
        if (this.image.get() == null) {
            return;
        }
        Rectangle2D rectangle = ImageHelper.croppedImageViewPort((Image)this.image.get(), this.previewImageView.getFitWidth(), this.previewImageView.getFitHeight());
        this.previewImageView.setViewport(rectangle);
    }

    @Override
    public Node getLayout() {
        return this;
    }

    @Override
    public void setAction(Optional<Runnable> action) {
        this.downloadButton.setOnMouseClicked(e -> action.ifPresent(Runnable::run));
    }

    @Override
    public void setProgress(Optional<Float> progress) {
        progress.ifPresent(this.ringProgressIndicator::setProgress);
    }

    public boolean isPreviewSavable() {
        return PreviewState.READY.equals(this.stateProperty.get()) || PreviewState.UPLOADING.equals(this.stateProperty.get());
    }

    @Override
    public AtomicBoolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean disposedVal) {
        this.disposed.set(disposedVal);
    }

    public static final class Draft
    extends ImagePreview {
        public static final int ARC_RADIUS = 8;
        public static final int DRAFT_SIZE = 70;

        public Draft(ImageLruCache imageLruCache) {
            super(imageLruCache, Optional.empty());
            this.width.set(70.0);
            this.height.set(70.0);
            Rectangle clipRectangle = PreviewUtils.createImageSizeRectangle(this.previewImageView, 8);
            this.setClip((Node)clipRectangle);
        }
    }
}

