/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.file;

import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.fx.custom_components.file.FileExtension;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewState;
import io.olvid.windows.messenger.fx.framework.lib.Disposable;
import io.olvid.windows.messenger.fx.framework.lib.Pool;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.IconAndDescription;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class FilePreview
extends HBox {
    public static final int FILE_SIZE_FACTOR = 1000;
    public final IconAndDescription iconAndDescription;
    public final Button actionButton;
    public final SvgSizeable actionIcon;
    protected final RingProgressIndicator ring_progress_indicator;

    public FilePreview(DoubleExpression maxWidthBinding) {
        this.getStylesheets().add((Object)ViewControllerHelper.class.getClassLoader().getResource("fx/custom_ui_components/file/file_item.css").toExternalForm());
        this.setAlignment(Pos.CENTER);
        this.setPadding(new Insets(9.0, 13.0, 13.0, 13.0));
        this.iconAndDescription = new IconAndDescription();
        this.iconAndDescription.title.getStyleClass().add((Object)"title");
        this.iconAndDescription.getSubtitleStyleClass().setAll((Object[])new String[]{"subtitle"});
        this.iconAndDescription.title.setWrapText(false);
        this.iconAndDescription.title.maxHeightProperty().bind((ObservableValue)new SimpleLongProperty(25L));
        this.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
        this.managedProperty().bind((ObservableValue)this.visibleProperty());
        this.actionButton = new Button();
        this.actionButton.setMnemonicParsing(false);
        this.actionButton.getStyleClass().add((Object)"empty-button");
        StackPane rightStackPane = new StackPane();
        HBox.setMargin((Node)rightStackPane, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        this.getChildren().addAll((Object[])new Node[]{this.iconAndDescription, rightStackPane});
        this.actionIcon = new SvgSizeable();
        this.actionButton.setGraphic((Node)this.actionIcon);
        this.actionButton.setVisible(false);
        this.ring_progress_indicator = new RingProgressIndicator();
        rightStackPane.getChildren().addAll((Object[])new Node[]{this.actionButton, this.ring_progress_indicator});
        this.setWidth(-1.0);
        this.setHeight(-1.0);
    }

    public static final class Draft
    extends FileAttachmentPreview {
        public Draft(DoubleExpression maxWidthBinding) {
            super(maxWidthBinding);
            this.getStyleClass().add((Object)"file-preview-draft");
        }

        @Override
        public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
            super.update(attachment, filename, fileExtension, size, state);
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconSvg, PreviewUtils.getIconStyleClass(fileExtension), PreviewUtils.getIconColorStyleClass(fileExtension));
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconCircle, PreviewUtils.getIconCircleStyleClass(fileExtension), "icon-circle");
        }
    }

    public static final class Outbound
    extends FileAttachmentPreview
    implements Disposable {
        private final Optional<Pool<Outbound>> pool;
        private final AtomicBoolean disposed = new AtomicBoolean(false);

        public Outbound(DoubleExpression maxWidthBinding, Optional<Pool<Outbound>> pool) {
            super(maxWidthBinding);
            this.pool = pool;
            this.getStyleClass().add((Object)"file-preview-outbound");
        }

        @Override
        public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
            super.update(attachment, filename, fileExtension, size, state);
            this.actionIcon.getStyleClass().setAll((Object[])PreviewUtils.getActionStyle(false, state));
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconSvg, PreviewUtils.getIconStyleClass(fileExtension), PreviewUtils.getIconColorStyleClass(fileExtension));
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconCircle, PreviewUtils.getIconCircleStyleClass(fileExtension), "icon-circle");
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pool.ifPresent(outboundPool -> outboundPool.returnObject(this));
        }

        @Override
        public AtomicBoolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void setDisposed(boolean disposedVal) {
            this.disposed.set(disposedVal);
        }
    }

    public static final class Inbound
    extends FileAttachmentPreview
    implements Disposable {
        private final Optional<Pool<Inbound>> pool;
        private final AtomicBoolean disposed = new AtomicBoolean(false);

        public Inbound(DoubleExpression maxWidthBinding, Optional<Pool<Inbound>> pool) {
            super(maxWidthBinding);
            this.pool = pool;
            this.getStyleClass().add((Object)"file-preview-inbound");
        }

        @Override
        public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
            super.update(attachment, filename, fileExtension, size, state);
            this.actionIcon.getStyleClass().setAll((Object[])PreviewUtils.getActionStyle(true, state));
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconSvg, PreviewUtils.getIconStyleClass(fileExtension), PreviewUtils.getIconColorStyleClass(fileExtension));
            PreviewUtils.setStyleOnNode((Node)this.iconAndDescription.iconCircle, PreviewUtils.getIconCircleStyleClass(fileExtension), "icon-circle");
        }

        @Override
        public void dispose() {
            super.dispose();
            this.pool.ifPresent(inboundPool -> inboundPool.returnObject(this));
        }

        @Override
        public AtomicBoolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void setDisposed(boolean disposedVal) {
            this.disposed.set(disposedVal);
        }
    }

    public static abstract class FileAttachmentPreview
    extends FilePreview
    implements PreviewUtils.Preview {
        private AbstractAttachmentGenerated<?> attachment;

        protected FileAttachmentPreview(DoubleExpression maxWidthBinding) {
            super(maxWidthBinding);
        }

        @Override
        public Node getLayout() {
            return this;
        }

        @Override
        public void update(AbstractAttachmentGenerated<?> attachment, String filename, FileExtension fileExtension, Optional<Long> size, PreviewState state) {
            this.attachment = attachment;
            this.iconAndDescription.title.setText(filename);
            Tooltip tooltip = new Tooltip(filename);
            this.actionButton.setTooltip(tooltip);
            this.iconAndDescription.setSubtitle(size.map(PreviewUtils::convertFileSize));
            this.ring_progress_indicator.setVisible(state == PreviewState.PROCESSING);
        }

        @Override
        public AbstractAttachmentGenerated<?> getAttachment() {
            return this.attachment;
        }

        @Override
        public void setProgress(Optional<Float> progress) {
            progress.ifPresent(this.ring_progress_indicator::setProgress);
        }

        @Override
        public void setAction(Optional<Runnable> action) {
            if (action.isEmpty()) {
                this.actionButton.setVisible(false);
            } else {
                this.actionButton.setVisible(true);
                this.actionButton.setOnMouseClicked(event -> ((Runnable)action.get()).run());
            }
        }

        @Override
        public void dispose() {
            this.actionButton.setOnMouseClicked(null);
            this.iconAndDescription.title.setText("");
            this.iconAndDescription.setSubtitle(Optional.empty());
        }
    }
}

