/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.ephemerality;

import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BindingUtils;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.DateUtils;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public final class EphemeralInfoView
extends HBox {
    private final ObjectProperty<Icon> iconType = new SimpleObjectProperty((Object)Icon.NONE);
    private final ObjectProperty<Color> iconColor = new SimpleObjectProperty((Object)Color.NONE);
    private final LongProperty timerValue = new SimpleLongProperty(0L);
    private final LiveData<Long> tickerLiveData;
    private boolean showReadOnceStatus;
    private final LiveDataListener<Long> tickerListener = this::tickerListener;
    private final SvgSizeable icon = new SvgSizeable();
    private final ObservableList<String> iconStyles;
    private final Label timer = new Label();
    private final ObservableList<String> timerStyles;
    private boolean viewIsListeningToTickerListener = false;
    private Optional<? extends AbstractMessageEphemeralInfoGenerated<?>> currentMessageEphemeralInfoOpt;

    public EphemeralInfoView(LiveData<Long> tickerLiveData) {
        this.setAlignment(Pos.CENTER);
        this.showReadOnceStatus = true;
        this.tickerLiveData = tickerLiveData;
        this.getChildren().addAll((Object[])new Node[]{this.icon, this.timer});
        this.setSpacing(4.0);
        BindingUtils.ListBuilder<String> listBuilder = BindingUtils.listBuilder();
        listBuilder.add("icon-medium").add((ObservableValue<String>)this.iconType.map(Icon::getStyle)).add((ObservableValue<String>)this.iconColor.map(Color::getIconStyle));
        this.iconStyles = listBuilder.build();
        Bindings.bindContent((List)this.icon.getStyleClass(), this.iconStyles);
        listBuilder = BindingUtils.listBuilder();
        listBuilder.add("body-1-size").add((ObservableValue<String>)this.iconColor.map(Color::getTextStyle));
        this.timerStyles = listBuilder.build();
        Bindings.bindContent((List)this.timer.getStyleClass(), this.timerStyles);
        this.visibleProperty().bind((ObservableValue)this.iconType.isNotEqualTo((Object)Icon.NONE));
        this.managedProperty().bind((ObservableValue)this.visibleProperty());
        this.timer.visibleProperty().bind((ObservableValue)this.iconType.isNotEqualTo((Object)Icon.NONE).and((ObservableBooleanValue)this.timerValue.isNotEqualTo(0)));
        this.timer.managedProperty().bind((ObservableValue)this.timer.visibleProperty());
        this.timer.textProperty().bind(this.timerValue.map(t -> t.intValue() == 0 ? "" : DateUtils.formatDurationUnit(t.intValue())));
    }

    public void setShowReadOnceStatus(boolean showReadOnceStatus) {
        this.showReadOnceStatus = showReadOnceStatus;
    }

    private synchronized void plugTimer() {
        if (!this.viewIsListeningToTickerListener) {
            this.tickerLiveData.addListener(this.tickerListener);
            this.viewIsListeningToTickerListener = true;
        }
    }

    private synchronized void unplugTimer() {
        if (this.viewIsListeningToTickerListener) {
            this.tickerLiveData.removeListener(this.tickerListener);
            this.viewIsListeningToTickerListener = false;
        }
    }

    public void updateEphemeralInfo(long currentTimeMillis, Optional<? extends AbstractMessageEphemeralInfoGenerated<?>> messageEphemeralInfoOpt) {
        this.currentMessageEphemeralInfoOpt = messageEphemeralInfoOpt;
        if (messageEphemeralInfoOpt.isEmpty()) {
            this.setTimer(Optional.empty());
            this.iconType.set((Object)Icon.NONE);
            this.unplugTimer();
            return;
        }
        AbstractMessageEphemeralInfoGenerated<?> messageEphemeralInfo = messageEphemeralInfoOpt.get();
        boolean isReadOnce = messageEphemeralInfo.isReadOnce();
        Optional<Long> nextExpirationOpt = OptionalUtils.longMin(messageEphemeralInfo.getExistenceTimestamp(), messageEphemeralInfo.getVisibilityTimestamp());
        if (nextExpirationOpt.isPresent()) {
            boolean isVisibilityExpiration = nextExpirationOpt.equals(messageEphemeralInfo.getVisibilityTimestamp());
            this.plugTimer();
            if (isReadOnce & this.showReadOnceStatus) {
                this.iconType.set((Object)Icon.READ_ONCE);
            } else if (isVisibilityExpiration) {
                this.iconType.set((Object)Icon.VISIBILITY);
            } else {
                this.iconType.set((Object)Icon.EXISTENCE);
            }
            this.updateTimer(currentTimeMillis);
        } else {
            this.setTimer(Optional.empty());
            this.unplugTimer();
            if (isReadOnce && this.showReadOnceStatus) {
                this.iconType.set((Object)Icon.READ_ONCE);
                this.iconColor.set((Object)Color.HIGHLIGHT);
            } else {
                this.iconType.set((Object)Icon.NONE);
            }
        }
    }

    private void updateTimer(long currentTimeMillis) {
        if (this.currentMessageEphemeralInfoOpt.isEmpty()) {
            return;
        }
        AbstractMessageEphemeralInfoGenerated<?> messageEphemeralInfo = this.currentMessageEphemeralInfoOpt.get();
        boolean isReadOnce = messageEphemeralInfo.isReadOnce();
        Optional<Long> nextExpirationOpt = OptionalUtils.longMin(messageEphemeralInfo.getExistenceTimestamp(), messageEphemeralInfo.getVisibilityTimestamp());
        if (nextExpirationOpt.isPresent()) {
            long expirationTimestamp = nextExpirationOpt.get();
            long remainingSeconds = Math.max(expirationTimestamp - currentTimeMillis, 0L) / 1000L;
            if (isReadOnce && this.showReadOnceStatus) {
                this.iconColor.set((Object)Color.HIGHLIGHT);
            } else if (remainingSeconds < 60L) {
                this.iconColor.set((Object)Color.HIGHLIGHT);
            } else if (remainingSeconds < 3600L) {
                this.iconColor.set((Object)Color.ACCENTUATED);
            } else if (remainingSeconds < 86400L) {
                this.iconColor.set((Object)Color.NEUTRAL);
            } else {
                this.iconColor.set((Object)Color.NEUTRAL);
            }
            this.setTimer(Optional.of(remainingSeconds));
        } else if (isReadOnce && this.showReadOnceStatus) {
            this.iconType.set((Object)Icon.READ_ONCE);
            this.iconColor.set((Object)Color.HIGHLIGHT);
        } else {
            this.iconType.set((Object)Icon.NONE);
        }
    }

    public void setTimer(Optional<Long> remainingSeconds) {
        this.timerValue.set(remainingSeconds.orElse(0L).longValue());
    }

    private void tickerListener(Long currentTime, Long oldTime) {
        ViewControllerHelper.smartUIUpdate(() -> this.updateTimer(currentTime));
    }

    static enum Icon {
        READ_ONCE("svg-flame"),
        EXISTENCE("svg-clock"),
        VISIBILITY("svg-eye"),
        NONE("");

        private final String style;

        private Icon(String cssStyle) {
            this.style = cssStyle;
        }

        public String getStyle() {
            return this.style;
        }
    }

    static enum Color {
        NEUTRAL("icon-primary", "blue-text"),
        ACCENTUATED("icon-red", "error-text"),
        HIGHLIGHT("icon-red", "tag-red"),
        NONE("", "");

        private final String iconStyle;
        private final String textStyle;

        private Color(String iconStyle, String textStyle) {
            this.iconStyle = iconStyle;
            this.textStyle = textStyle;
        }

        public String getTextStyle() {
            return this.textStyle;
        }

        public String getIconStyle() {
            return this.iconStyle;
        }
    }
}

