/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.drag_and_drop;

import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ClipboardDelegate;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Pair;
import java.net.URL;
import java.util.Base64;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.effect.Effect;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

@FXMLView(path="fx/custom_ui_components/drag_and_drop/drop_area.fxml")
public class DropAreaController
extends BaseViewController {
    private static final Duration DURATION = Duration.millis((double)300.0);
    private static final int MAX_BLUR = 8;
    private final ClipboardDelegate clipboardDelegate;
    private final boolean onTheScene;
    private final Pane parent;
    @FXML
    private Pane root;
    @FXML
    private VBox drop_area;
    @FXML
    private Pane wrapper;
    private EventHandler<DragEvent> dragEventEventHandlerEntred;
    private EventHandler<DragEvent> dragEventEventHandlerDrag;
    private EventHandler<DragEvent> dragEventEventHandlerExited;
    private EventHandler<DragEvent> dropEventEventHandler;
    private AnimationUtils.BlurTransition blurTransition;
    private ObservableList<Node> blurPaneList;

    private DropAreaController(boolean onTheScene, ClipboardDelegate clipboardDelegate, Pane parent) {
        this.loadFxml();
        this.clipboardDelegate = clipboardDelegate;
        this.onTheScene = onTheScene;
        this.parent = parent;
        this.initDragAndDropHandler();
    }

    public static DropAreaController addDropArea(ClipboardDelegate clipboardDelegate, Pane parent, boolean onTheScene, Optional<Insets> margin) {
        DropAreaController dropArea = new DropAreaController(onTheScene, clipboardDelegate, parent);
        DropAreaController.managed(parent, dropArea);
        if (margin.isPresent()) {
            dropArea.wrapper.setPadding(margin.get());
        }
        return dropArea;
    }

    private static void managed(Pane parent, DropAreaController dropArea) {
        dropArea.wrapper.prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        dropArea.wrapper.prefWidthProperty().bind((ObservableValue)parent.widthProperty());
        parent.getChildren().add((Object)dropArea.getLayout());
        dropArea.getLayout().setManaged(false);
    }

    private boolean canDrag(DragEvent event) {
        if (event.getGestureSource() == this.parent) {
            return false;
        }
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasFiles() && (dragboard.getFiles().size() == 1 || this.clipboardDelegate.isMultipleFilesSupported())) {
            return true;
        }
        if (this.clipboardDelegate.isImageSupported()) {
            if (dragboard.hasImage()) {
                return true;
            }
            if (this.detectBase64ImageFromURL((Clipboard)dragboard)) {
                return true;
            }
        }
        return dragboard.hasImage() && this.clipboardDelegate.isImageSupported();
    }

    private void initDragAndDropHandler() {
        this.blurTransition = new AnimationUtils.BlurTransition(DURATION, 0.0, 8.0);
        this.dragEventEventHandlerEntred = event -> {
            if (this.canDrag((DragEvent)event)) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                this.root.setVisible(true);
                this.blurTransition.setRate(1.0);
                this.blurTransition.play();
            }
            event.consume();
        };
        this.dragEventEventHandlerDrag = event -> {
            if (this.canDrag((DragEvent)event)) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        };
        this.dragEventEventHandlerExited = event -> {
            this.root.setVisible(false);
            this.blurTransition.stop();
            this.blurTransition.getBlurEffect().setRadius(0.0);
            event.consume();
        };
        this.dropEventEventHandler = event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles()) {
                this.clipboardDelegate.importFiles(db.getFiles());
            }
            if (this.clipboardDelegate.isImageSupported()) {
                if (db.hasImage()) {
                    this.clipboardDelegate.importImage(db.getImage());
                }
                if (this.detectBase64ImageFromURL((Clipboard)db)) {
                    try {
                        Pair<ImageUtils.MimeType, byte[]> mimeTypeAndImage = this.parseBase64ImageFromURL(db.getUrl());
                        this.clipboardDelegate.importImage(mimeTypeAndImage.getFirst(), mimeTypeAndImage.getSecond());
                    }
                    catch (Exception e) {
                        this.logger.error("Cannot decode image", e);
                    }
                }
            }
            this.blurTransition.stop();
            this.blurTransition.getBlurEffect().setRadius(0.0);
            event.setDropCompleted(success);
            event.consume();
        };
    }

    private boolean detectBase64ImageFromURL(Clipboard clipboard) {
        if (!clipboard.hasUrl()) {
            return false;
        }
        String url = clipboard.getUrl();
        return url.startsWith("data:image/") && url.contains(";base64");
    }

    private Pair<ImageUtils.MimeType, byte[]> parseBase64ImageFromURL(String url) throws Exception {
        String url_ = url.replaceAll("%2(?i)b", "+").replaceAll("%2(?i)f", "/").replaceAll("%3(?i)d", "=");
        int mimeTypeStart = url_.indexOf(":");
        if (mimeTypeStart == -1) {
            throw new Exception("Cannot find first / before format");
        }
        int mimeTypeEnd = url_.indexOf(";", mimeTypeStart);
        if (mimeTypeEnd == -1) {
            throw new Exception("Cannot find first ; after format");
        }
        String rawMimeType = url_.substring(mimeTypeStart + 1, mimeTypeEnd);
        Optional<ImageUtils.MimeType> mimeType = ImageUtils.MimeType.of(rawMimeType);
        if (mimeType.isEmpty()) {
            throw new Exception("Unknown mimeType " + rawMimeType);
        }
        String base64Start = ";base64,";
        int dataStart = url_.indexOf(";base64,");
        String base64 = url_.substring(dataStart + ";base64,".length());
        byte[] bytes = Base64.getDecoder().decode(base64);
        return Pair.of(mimeType.get(), bytes);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.root.setVisible(false);
        this.root.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.blurPaneList = newValue.getChildrenUnmodifiable();
                this.blurPaneList.stream().filter(node -> !node.equals(this.root)).forEach(node -> node.setEffect((Effect)this.blurTransition.getBlurEffect()));
            }
        });
    }

    public Pane getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        if (this.onTheScene) {
            Scene newScene = ViewControllerHelper.MAIN_STAGE.getScene();
            if (newScene != null) {
                newScene.addEventHandler(DragEvent.DRAG_OVER, this.dragEventEventHandlerDrag);
                newScene.addEventHandler(DragEvent.DRAG_ENTERED, this.dragEventEventHandlerEntred);
                newScene.addEventHandler(DragEvent.DRAG_EXITED, this.dragEventEventHandlerExited);
                newScene.addEventHandler(DragEvent.DRAG_DROPPED, this.dropEventEventHandler);
            }
        } else {
            this.parent.addEventHandler(DragEvent.DRAG_OVER, this.dragEventEventHandlerDrag);
            this.parent.addEventHandler(DragEvent.DRAG_ENTERED, this.dragEventEventHandlerEntred);
            this.parent.addEventHandler(DragEvent.DRAG_EXITED, this.dragEventEventHandlerExited);
            this.parent.addEventHandler(DragEvent.DRAG_DROPPED, this.dropEventEventHandler);
        }
    }

    @Override
    public void onLayoutDetached() {
        if (this.onTheScene) {
            Scene oldScene = ViewControllerHelper.MAIN_STAGE.getScene();
            if (oldScene != null) {
                oldScene.removeEventHandler(DragEvent.DRAG_OVER, this.dragEventEventHandlerDrag);
                oldScene.removeEventHandler(DragEvent.DRAG_ENTERED, this.dragEventEventHandlerEntred);
                oldScene.removeEventHandler(DragEvent.DRAG_EXITED, this.dragEventEventHandlerExited);
                oldScene.removeEventHandler(DragEvent.DRAG_DROPPED, this.dropEventEventHandler);
            }
        } else {
            this.parent.removeEventHandler(DragEvent.DRAG_OVER, this.dragEventEventHandlerDrag);
            this.parent.removeEventHandler(DragEvent.DRAG_ENTERED, this.dragEventEventHandlerEntred);
            this.parent.removeEventHandler(DragEvent.DRAG_EXITED, this.dragEventEventHandlerExited);
            this.parent.removeEventHandler(DragEvent.DRAG_DROPPED, this.dropEventEventHandler);
        }
        this.blurPaneList.stream().filter(node -> !node.equals(this.root)).filter(node -> node.getEffect() == this.blurTransition.getBlurEffect()).forEach(node -> node.setEffect(null));
    }
}

