/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.custom_controls;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class ButtonWithIcon
extends HBox
implements Initializable {
    @FXML
    public Label label;
    @FXML
    public ImageView image_view;
    public String url;
    public Double width;
    public Double height;

    public ButtonWithIcon() throws Exception {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fx/custom_ui_components/button_with_icon.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.load();
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void setUrl(String string) {
        this.url = string;
        this.imageLoader();
    }

    public String getUrl() {
        return this.url;
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setButtonWidth(Double value) {
        this.width = value;
        this.imageLoader();
    }

    public Double getButtonWidth() {
        return this.width;
    }

    public void setButtonHeight(Double value) {
        this.height = value;
        this.imageLoader();
    }

    public Double getButtonHeight() {
        return this.height;
    }

    public void imageLoader() {
        if (this.url != null && this.width != null && this.height != null) {
            Image image = new Image(this.url, this.width.doubleValue(), this.height.doubleValue(), true, false);
            this.image_view.setImage(image);
        }
    }

    public void addIconChangeOnHoverListener(final String url1, final String url2) {
        this.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ButtonWithIcon.this.setUrl(url2);
                } else {
                    ButtonWithIcon.this.setUrl(url1);
                }
            }
        });
    }
}

