/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.custom_context_menu;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.ShapeConverter;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;

public class ContextMenuItemView
extends HBox {
    private static final List<CssMetaData<? extends Styleable, ?>> CLASS_CSS_META_DATA;
    private final StyleableObjectProperty<Shape> shapeProperty = new SimpleStyleableObjectProperty(SHAPE_META_DATA, (Object)this, "shape");
    private static final CssMetaData<ContextMenuItemView, Shape> SHAPE_META_DATA;
    private boolean iconAdded = false;

    public ContextMenuItemView(String labelText, Optional<String> labelStyle, List<String> classes, double prefWidth) {
        this.setAlignment(Pos.CENTER);
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(30.0);
        this.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
        this.getStyleClass().addAll(classes);
        Label label = new Label();
        label.setText(labelText);
        label.getStyleClass().add((Object)"body-1");
        labelStyle.ifPresent(arg_0 -> label.getStyleClass().add(arg_0));
        this.getChildren().add((Object)label);
        Region spacer = new Region();
        this.getChildren().add((Object)spacer);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SvgSizeable icon = new SvgSizeable();
        this.shapeProperty.addListener((observable, oldValue, newValue) -> {
            if (this.iconAdded) {
                return;
            }
            if (!(newValue instanceof SVGPath)) {
                return;
            }
            SVGPath path = (SVGPath)newValue;
            icon.shape.set(path.getContent());
            icon.getStyleClass().addAll((Collection)classes);
            this.getChildren().add((Object)icon);
            this.iconAdded = true;
        });
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CLASS_CSS_META_DATA;
    }

    static {
        SHAPE_META_DATA = new CssMetaData<ContextMenuItemView, Shape>("-fx-shape", ShapeConverter.getInstance()){

            public boolean isSettable(ContextMenuItemView menu) {
                return !menu.shapeProperty.isBound();
            }

            public StyleableProperty<Shape> getStyleableProperty(ContextMenuItemView menu) {
                return menu.shapeProperty;
            }
        };
        List parent = HBox.getClassCssMetaData();
        List<CssMetaData<ContextMenuItemView, Shape>> additional = List.of(SHAPE_META_DATA);
        ArrayList<CssMetaData<ContextMenuItemView, Shape>> own = new ArrayList<CssMetaData<ContextMenuItemView, Shape>>(parent.size() + additional.size());
        own.addAll(parent);
        own.addAll(additional);
        CLASS_CSS_META_DATA = Collections.unmodifiableList(own);
    }
}

