/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components.bubbles;

import io.olvid.windows.messenger.engine.sync.ProfilePictureKey;
import io.olvid.windows.messenger.fx.custom_components.bubbles.PolarPane;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.utils.FxColors;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ColorUtils;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.cache.FutureLruCache;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;

@DefaultProperty(value="children")
public class IdentityBubble
extends StackPane {
    private final FutureLruCache<String, ImageHelper.ImageInfo, Throwable> imageInfoLruCache = new FutureLruCache(40L);
    private final FutureLruCache<ProfilePictureKey, ImageHelper.ImageInfo, Throwable> profilePictureKeyLruCache = new FutureLruCache(10L);
    public static final double DEFAULT_RADIUS = 28.0;
    public static final int BOT_RIGHT_ANGLE = 48;
    public static final int TOP_RIGHT_ANGLE = -48;
    public static final double STROKE_WIDTH = 1.0;
    public static final double LABEL_RATIO = 1.125;
    public static final Paint KEYCLOAK_GRADIENT = new LinearGradient(-0.1, 0.1, 0.9, 0.9, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)107, (int)183, (int)0, (double)1.0)), new Stop(1.0, Color.rgb((int)47, (int)101, (int)245, (double)1.0))});
    private static final double GROUP_ICON_RATIO = 1.2;
    private static final double INACTIVE_ICON_RATIO = 1.8;
    private static final double UNREAD_RATIO = 0.18;
    public static final double KEYCLOAK_SIZE_RATIO = 1.75;
    public static final double KEYCLOAK_BACK_SIZE_RATIO = 1.35;
    private static final double LOCKED_ICON_RATIO = 1.0;
    private final StringProperty photoUrlRelPath = new SimpleStringProperty();
    private final ObjectProperty<ProfilePictureKey> profilePictureKeyProperty = new SimpleObjectProperty();
    private final ObjectProperty<byte[]> colorByteSource = new SimpleObjectProperty();
    private final double radius;
    private final StringProperty initial = new SimpleStringProperty();
    private final BooleanProperty keycloakManaged = new SimpleBooleanProperty(false);
    private final BooleanProperty group = new SimpleBooleanProperty(false);
    private final BooleanProperty inactive = new SimpleBooleanProperty(false);
    public final BooleanProperty locked = new SimpleBooleanProperty(false);
    public final Label bubbleLabel = new Label();
    public final Circle bubbleCircle = new Circle();
    public final ImageView imageView = new ImageView();
    private final StackPane keyCloakIcon = new StackPane();
    private final SvgSizeable groupIcon = new SvgSizeable();
    private SvgSizeable inactiveIcon = new SvgSizeable();
    private final SvgSizeable lockedIcon = new SvgSizeable();
    private Circle redCircle;

    public IdentityBubble(@NamedArg(value="radius") double radius) {
        this.getStyleClass().add((Object)"bubble");
        this.radius = radius;
        this.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.radius * 2.0 + this.getInsets().getRight() + this.getInsets().getLeft(), (Observable[])new Observable[]{this.insetsProperty()}));
        this.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.radius * 2.0 + this.getInsets().getTop() + this.getInsets().getBottom(), (Observable[])new Observable[]{this.insetsProperty()}));
        this.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.radius * 2.0 + this.getInsets().getRight() + this.getInsets().getLeft(), (Observable[])new Observable[]{this.insetsProperty()}));
        PolarPane polarPane = new PolarPane();
        polarPane.getChildren().add((Object)this.keyCloakIcon);
        this.getChildren().addAll((Object[])new Node[]{this.bubbleCircle, this.bubbleLabel, this.groupIcon, this.inactiveIcon, this.lockedIcon, this.imageView, polarPane});
        this.bubbleCircle.setStrokeType(StrokeType.CENTERED);
        this.bubbleCircle.setStrokeWidth(1.0);
        this.groupIcon.getStyleClass().addAll((Object[])new String[]{"icon-white", "svg-groups"});
        this.groupIcon.setHeight(radius * 1.2);
        this.groupIcon.setWidth(radius * 1.2);
        this.inactiveIcon.getStyleClass().addAll((Object[])new String[]{"icon-grey", "svg-inactive"});
        this.inactiveIcon.setHeight(radius * 1.8);
        this.inactiveIcon.setWidth(radius * 1.8);
        this.lockedIcon.getStyleClass().addAll((Object[])new String[]{"icon-grey", "svg-lock"});
        this.lockedIcon.setHeight(radius * 1.0);
        this.lockedIcon.setWidth(radius * 1.0);
        this.lockedIcon.managedProperty().bind((ObservableValue)this.lockedIcon.visibleProperty());
        this.lockedIcon.visibleProperty().bind((ObservableValue)this.locked);
        PolarPane.setCoordinate((Node)this.keyCloakIcon, radius, 48);
        this.bindVisibility();
        this.bind();
        this.initImage();
        this.initKeyCloakIcon();
        this.initUnread(polarPane);
    }

    public IdentityBubble() {
        this(28.0);
    }

    private void initUnread(PolarPane polarPane) {
        this.redCircle = new Circle(6.0);
        this.redCircle.getStyleClass().add((Object)"red-circle");
        this.redCircle.setVisible(false);
        this.redCircle.setRadius(this.radius * 0.18);
        polarPane.getChildren().add((Object)this.redCircle);
        PolarPane.setCoordinate((Node)this.redCircle, this.radius, -48);
    }

    private void bindVisibility() {
        this.bubbleLabel.managedProperty().bind((ObservableValue)this.bubbleLabel.visibleProperty());
        this.bubbleLabel.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNull().and((ObservableBooleanValue)this.group.not()).and((ObservableBooleanValue)this.inactive.not()).and((ObservableBooleanValue)this.locked.not()));
        this.groupIcon.managedProperty().bind((ObservableValue)this.groupIcon.visibleProperty());
        this.groupIcon.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNull().and((ObservableBooleanValue)this.group));
        this.inactiveIcon.managedProperty().bind((ObservableValue)this.inactiveIcon.visibleProperty());
        this.inactiveIcon.visibleProperty().bind((ObservableValue)this.inactive);
        this.imageView.managedProperty().bind((ObservableValue)this.imageView.visibleProperty());
        this.imageView.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNotNull().and((ObservableBooleanValue)this.inactive.not()));
        this.keyCloakIcon.managedProperty().bind((ObservableValue)this.keyCloakIcon.visibleProperty());
        this.keyCloakIcon.visibleProperty().bind((ObservableValue)this.keycloakManaged);
    }

    private void initKeyCloakIcon() {
        Node iconBackground = FxIcons.icon(FxIcons.SHIELD_BACKGROUND(null, FxColors.WHITE), this.radius / 1.35, 24.0, this.radius / 1.35, 24.0);
        Node shield = FxIcons.icon(FxIcons.SHIELD(null, FxColors.KEYCLOAK_COLOR), this.radius / 1.75, 16.0, this.radius / 1.75, 16.0);
        this.keyCloakIcon.getChildren().addAll((Object[])new Node[]{iconBackground, shield});
    }

    private void initImage() {
        Circle clipCircle = new Circle();
        double innerCircle = this.bubbleCircle.getRadius() - 0.5;
        clipCircle.setRadius(innerCircle);
        clipCircle.setCenterX(innerCircle);
        clipCircle.setCenterY(innerCircle);
        this.imageView.setClip((Node)clipCircle);
        this.imageView.setFitHeight(innerCircle * 2.0);
        this.imageView.setFitWidth(innerCircle * 2.0);
        this.imageView.setSmooth(false);
        this.photoUrlRelPath.addListener(this::photoUrlRelPathListener);
        this.profilePictureKeyProperty.addListener(this::profilePictureKeyListener);
    }

    private void photoUrlRelPathListener(ObservableValue<?> observable, Object oldValue, Object newValue) {
        ViewControllerHelper.checkUIThread();
        String path = (String)this.photoUrlRelPath.get();
        if (path == null) {
            this.imageView.setImage(null);
            return;
        }
        this.imageInfoLruCache.compute((String)this.photoUrlRelPath.get(), result -> ViewControllerHelper.smartUIUpdate(() -> {
            if (result.isSuccess()) {
                if (path.equals(this.photoUrlRelPath.get())) {
                    this.imageView.setImage(((ImageHelper.ImageInfo)result.getSuccess()).image());
                }
            } else {
                this.imageView.setImage(null);
            }
        }), p -> {
            try {
                return Result.success(ImageHelper.readSmallImage(p));
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }, Optional.empty());
    }

    private void profilePictureKeyListener(ObservableValue<?> observable, Object oldValue, Object newValue) {
        ViewControllerHelper.checkUIThread();
        if (this.photoUrlRelPath.get() != null) {
            return;
        }
        ProfilePictureKey profilePictureKey = (ProfilePictureKey)this.profilePictureKeyProperty.get();
        if (profilePictureKey == null) {
            this.imageView.setImage(null);
            return;
        }
        this.profilePictureKeyLruCache.compute((ProfilePictureKey)this.profilePictureKeyProperty.get(), result -> ViewControllerHelper.smartUIUpdate(() -> {
            if (result.isSuccess()) {
                if (profilePictureKey.equals(this.profilePictureKeyProperty.get())) {
                    this.imageView.setImage(((ImageHelper.ImageInfo)result.getSuccess()).image());
                } else {
                    this.imageView.setImage(null);
                }
            } else {
                this.imageView.setImage(null);
            }
        }), p -> {
            try {
                return ImageHelper.fetchAndReadSmallImage(p);
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }, Optional.empty());
    }

    private void bind() {
        this.bubbleLabel.textProperty().bind((ObservableValue)this.initial);
        double bubbleLabelFontSize = this.radius / 1.125;
        this.bubbleLabel.fontProperty().bind((ObservableValue)new SimpleObjectProperty((Object)new Font(bubbleLabelFontSize)));
        this.bubbleLabel.textFillProperty().bind((ObservableValue)new SimpleObjectProperty((Object)Color.WHITE));
        this.bubbleCircle.setRadius(this.radius - 0.5);
        this.bubbleCircle.fillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.inactive.get() || this.locked.get()) {
                return Color.rgb((int)224, (int)224, (int)224);
            }
            if (this.colorByteSource.get() == null) {
                return Color.WHITE;
            }
            return ColorUtils.getDarkColor((byte[])this.colorByteSource.get());
        }, (Observable[])new Observable[]{this.colorByteSource, this.inactive, this.locked}));
        this.bubbleCircle.strokeProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.inactive.get() || this.locked.get()) {
                return Color.TRANSPARENT;
            }
            if (this.keycloakManaged.get()) {
                return KEYCLOAK_GRADIENT;
            }
            return Color.WHITE;
        }, (Observable[])new Observable[]{this.keycloakManaged, this.inactive, this.locked}));
    }

    public String getPhotoUrlRelPath() {
        return (String)this.photoUrlRelPath.get();
    }

    public StringProperty photoUrlRelPathProperty() {
        return this.photoUrlRelPath;
    }

    public void setPhotoUrlRelPath(Optional<String> photoUrlRelPath) {
        this.photoUrlRelPath.set((Object)photoUrlRelPath.orElse(null));
    }

    public void setProfilePictureKey(Optional<ProfilePictureKey> profilePictureKey) {
        this.profilePictureKeyProperty.set((Object)profilePictureKey.orElse(null));
    }

    public byte[] getColorByteSource() {
        return (byte[])this.colorByteSource.get();
    }

    public ObjectProperty<byte[]> colorByteSourceProperty() {
        return this.colorByteSource;
    }

    public void setColorByteSource(byte[] colorByteSource) {
        this.colorByteSource.set((Object)colorByteSource);
    }

    public double getRadius() {
        return this.radius;
    }

    public String getInitial() {
        return (String)this.initial.get();
    }

    public StringProperty initialProperty() {
        return this.initial;
    }

    public void setInitial(Optional<Character> initial) {
        if (initial.isEmpty()) {
            this.initial.set(null);
        } else {
            this.initial.set((Object)initial.get().toString());
        }
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged.get();
    }

    public BooleanProperty keycloakManagedProperty() {
        return this.keycloakManaged;
    }

    public void setKeycloakManaged(boolean keycloakManaged) {
        this.keycloakManaged.set(keycloakManaged);
    }

    public boolean isGroup() {
        return this.group.get();
    }

    public BooleanProperty groupProperty() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group.set(group);
    }

    public void setInactive(boolean inactive) {
        this.inactive.set(inactive);
    }

    public void setLocked(boolean locked) {
        this.locked.set(locked);
    }

    public void bindUnreadVisibility(ObservableValue<Boolean> binding) {
        this.redCircle.visibleProperty().bind(binding);
    }
}

