/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.custom_components;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CastedList<T extends S, S>
implements List<T> {
    protected final Class<T> clazz;
    private final List<S> source;

    public CastedList(Class<T> clazz, List<S> source) {
        this.clazz = clazz;
        this.source = source;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.source.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<S> it;
            {
                this.it = CastedList.this.source.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return CastedList.this.clazz.cast(this.it.next());
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.source.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        return this.source.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.source.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.source.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.source.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        return this.source.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        return this.source.addAll(index, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.source.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.source.retainAll(c);
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<S> e1 = this.source.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            S o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        return this.source.hashCode();
    }

    @Override
    public T get(int index) {
        S s = this.source.get(index);
        return this.clazz.cast(s);
    }

    @Override
    public T set(int index, T element) {
        S s = this.source.set(index, element);
        return this.clazz.cast(s);
    }

    @Override
    public void add(int index, T element) {
        this.source.add(index, element);
    }

    @Override
    public T remove(int index) {
        S previous = this.source.remove(index);
        return this.clazz.cast(previous);
    }

    @Override
    public int indexOf(Object o) {
        return this.source.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.source.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new CastedListIterator(this.source.listIterator());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new CastedListIterator(this.source.listIterator(index));
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        List<S> s = this.source.subList(fromIndex, toIndex);
        return new CastedList<T, S>(this.clazz, s);
    }

    private class CastedListIterator
    implements ListIterator<T> {
        private final ListIterator<S> iterator;

        CastedListIterator(ListIterator<S> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return CastedList.this.clazz.cast(this.iterator.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            return CastedList.this.clazz.cast(this.iterator.previous());
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void set(T t) {
            this.iterator.set(t);
        }

        @Override
        public void add(T t) {
            this.iterator.add(t);
        }
    }
}

