/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.keycloak;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.windows.messenger.livedata.Diffable;
import java.util.Arrays;
import java.util.Objects;

public class KeycloakUserDetailsListItemData
implements Diffable {
    public final String id;
    public final byte[] identity;
    public final String firstName;
    public final String lastName;
    public final String position;
    public final String company;
    public final String fullSearchDisplayName;

    public KeycloakUserDetailsListItemData(JsonKeycloakUserDetails jsonKeycloakUserDetails) {
        this.id = jsonKeycloakUserDetails.getId();
        this.identity = jsonKeycloakUserDetails.getIdentity();
        this.firstName = jsonKeycloakUserDetails.getFirstName();
        this.lastName = jsonKeycloakUserDetails.getLastName();
        this.position = jsonKeycloakUserDetails.getPosition();
        this.company = jsonKeycloakUserDetails.getCompany();
        this.fullSearchDisplayName = JsonIdentityDetails.joinNames((String)this.firstName, (String)this.lastName, (boolean)false, (boolean)false);
    }

    public KeycloakUserDetailsListItemData(String id, byte[] identity, String firstName, String lastName, String position, String company) {
        this.id = id;
        this.identity = identity;
        this.firstName = firstName;
        this.lastName = lastName;
        this.position = position;
        this.company = company;
        this.fullSearchDisplayName = JsonIdentityDetails.joinNames((String)firstName, (String)lastName, (boolean)false, (boolean)false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeycloakUserDetailsListItemData) {
            KeycloakUserDetailsListItemData casted = (KeycloakUserDetailsListItemData)obj;
            return Objects.equals(this.id, casted.id);
        }
        return false;
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (obj instanceof KeycloakUserDetailsListItemData) {
            KeycloakUserDetailsListItemData casted = (KeycloakUserDetailsListItemData)obj;
            return Objects.equals(this.id, casted.id) && Arrays.equals(this.identity, casted.identity) && Objects.equals(this.firstName, casted.firstName) && Objects.equals(this.lastName, casted.lastName) && Objects.equals(this.position, casted.position) && Objects.equals(this.company, casted.company);
        }
        return false;
    }

    @Override
    public Object getItemId() {
        return this.id;
    }
}

