/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.keycloak;

import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.pojos.KeycloakSearchResponsePojo;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class KeycloakDirSearchViewModel {
    final MutableLiveData<List<KeycloakUserDetailsListItemData>> keycloakUserDetailsList = new MutableLiveData();
    private List<KeycloakUserDetailsListItemData> selectedItems;

    public LiveData<List<KeycloakUserDetailsListItemData>> getKeycloakUserDetailsList() {
        return this.keycloakUserDetailsList;
    }

    public List<KeycloakUserDetailsListItemData> getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedItems(List<KeycloakUserDetailsListItemData> selectedItems) {
        this.selectedItems = selectedItems;
    }

    public void customReSearch(String searchPattern) {
        Optional<OwnedIdentityInfo> selectedOwnedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (selectedOwnedIdentity.isEmpty()) {
            return;
        }
        KeycloakCallReturn<KeycloakSearchResponsePojo> searchRet = KeycloakManager.getInstance().search(selectedOwnedIdentity.get().bytesOwnedIdentity(), searchPattern);
        if (searchRet.isSuccess()) {
            ArrayList<KeycloakUserDetailsListItemData> keycloakUserDetailsListItemDataList = new ArrayList<KeycloakUserDetailsListItemData>(searchRet.getResult().results.size());
            for (JsonKeycloakUserDetails jsonKeycloakUserDetails : searchRet.getResult().results) {
                KeycloakUserDetailsListItemData keycloakUserDetailsListItemData = new KeycloakUserDetailsListItemData(jsonKeycloakUserDetails);
                keycloakUserDetailsListItemDataList.add(keycloakUserDetailsListItemData);
            }
            this.keycloakUserDetailsList.postValue(keycloakUserDetailsListItemDataList);
        }
    }
}

