/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.keycloak;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextHolder;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

@FXMLView(path="fx/contacts/keycloak/keycloak_card.fxml")
public class KeycloakCardController
extends BaseViewController {
    private final KeycloakUserDetailsListItemData keycloakUser;
    private final RightPanelContextHolder rightPanelNavigationController;
    @FXML
    private Button add_contact;
    @FXML
    private IdentityBubble contact_bubble;
    @FXML
    private Label name_label;
    @FXML
    private Label position_label;
    @FXML
    private Button close_button;
    @FXML
    private Region root;
    private final LiveDataListener<List<ContactInfo>> onChange = this::onContactChange;

    public KeycloakCardController(KeycloakUserDetailsListItemData keycloakUser, RightPanelContextHolder rightPanelNavigationController) {
        this.keycloakUser = keycloakUser;
        this.rightPanelNavigationController = rightPanelNavigationController;
        this.loadFxml();
        this.name_label.setText(String.join((CharSequence)" ", Stream.of(keycloakUser.firstName, keycloakUser.lastName).filter(Objects::nonNull).toList()));
        this.position_label.setText(String.join((CharSequence)" @ ", Stream.of(keycloakUser.position, keycloakUser.company).filter(Objects::nonNull).filter(it -> !it.isEmpty()).toList()));
        BubbleUtils.setBubbleData(keycloakUser, this.contact_bubble);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.add_contact.setOnAction(this::addContact);
        this.close_button.setOnAction(event -> this.rightPanelNavigationController.close());
    }

    private void addContact(ActionEvent event) {
        SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().ifPresent(ownedIdentityInfo -> {
            KeycloakCallReturn<Integer> ret = KeycloakManager.getInstance().addContact(ownedIdentityInfo.bytesOwnedIdentity(), this.keycloakUser.id, this.keycloakUser.identity);
            SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity.addListener(this.onChange);
            if (!ret.isSuccess()) {
                this.logger.error("AddKeycloakContactConfirmationModalController::onValidateClicked Couldn't add contact...");
            }
        });
    }

    public void onContactChange(List<ContactInfo> newValue, List<ContactInfo> oldValue) {
        Optional<ContactInfo> contactInfoOpt = newValue.stream().filter(contactInfo -> BytesKey.of(contactInfo.bytesContactIdentity()).equals(BytesKey.of(this.keycloakUser.identity))).findAny();
        contactInfoOpt.ifPresent(contactInfo -> {
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(DbManager.getInstance().getContactDao().get(contactInfo.ownedIdentityId(), contactInfo.bytesContactIdentity()));
            if (discussion != null) {
                SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity.removeListener(this.onChange);
                NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, discussion.getItemId()));
                this.rightPanelNavigationController.getRightPanelContext().replacePreviousState(new RightPanelContextState.ContactCard(contactInfo.genId()));
            }
        });
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity.removeListener(this.onChange);
    }
}

