/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list.toggle;

import io.olvid.windows.messenger.fx.contacts.contacts_list.toggle.ContactTab;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;

@FXMLView(path="fx/generic_types/list_view/filterToggle.fxml")
public class ContactToggleFilterController
extends BaseViewController {
    public static final String FXML_PATH = "fx/generic_types/list_view/filterToggle.fxml";
    private LiveDataListener<Optional<OwnedIdentityInfo>> ownedIdentityLiveDataListener;
    private final ObjectProperty<ContactTab> tabProperty = new SimpleObjectProperty();
    @FXML
    private ToggleButton contact_toggle;
    @FXML
    private ToggleButton directory_toggle;
    @FXML
    private ToggleButton other_toggle;
    @FXML
    private ToggleGroup contact;
    @FXML
    private Region root;
    private final BooleanProperty currentIdentHasKeycloak = new SimpleBooleanProperty();
    private final BooleanProperty keycloakAvailable = new SimpleBooleanProperty();

    public ContactToggleFilterController() {
        ViewControllerHelper.loadNodeWithExplicitController(this, FXML_PATH);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.initBind();
    }

    private void initBind() {
        HashMap<ToggleButton, ContactTab> tabMap = new HashMap<ToggleButton, ContactTab>();
        tabMap.put(this.contact_toggle, ContactTab.CONTACT);
        tabMap.put(this.other_toggle, ContactTab.OTHER);
        tabMap.put(this.directory_toggle, ContactTab.DIRECTORY);
        this.contact.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                oldValue.setSelected(true);
            }
            this.tabProperty.set((Object)((ContactTab)((Object)((Object)tabMap.get(this.contact.getSelectedToggle())))));
        });
        this.tabProperty.set((Object)((ContactTab)((Object)tabMap.get(this.contact.getSelectedToggle()))));
        this.ownedIdentityLiveDataListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> newValue.ifPresent(it -> this.currentIdentHasKeycloak.set(it.isKeycloakManaged())));
        SelectedOwnedIdentitySingleton.getInstance().addListener(this.ownedIdentityLiveDataListener);
        this.directory_toggle.visibleProperty().bind((ObservableValue)this.directory_toggle.managedProperty());
        this.directory_toggle.managedProperty().bind((ObservableValue)this.currentIdentHasKeycloak.and((ObservableBooleanValue)this.keycloakAvailable));
        this.keycloakAvailable.addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.tabProperty.get() == ContactTab.DIRECTORY) {
                this.contact_toggle.setSelected(true);
            }
        });
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public ObjectProperty<ContactTab> getTabProperty() {
        return this.tabProperty;
    }

    public boolean isKeycloakAvailable() {
        return this.keycloakAvailable.get();
    }

    public BooleanProperty keycloakAvailableProperty() {
        return this.keycloakAvailable;
    }

    public void setKeycloakAvailable(boolean keycloakAvailable) {
        this.keycloakAvailable.set(keycloakAvailable);
    }

    public void selectContact() {
        this.contact_toggle.setSelected(true);
    }

    public void selectOther() {
        this.other_toggle.setSelected(true);
    }

    public void selectDirectory() {
        this.directory_toggle.setSelected(true);
    }

    private ToggleButton getToggleButtonForTab(ContactTab tab) {
        return switch (tab) {
            default -> throw new MatchException(null, null);
            case ContactTab.CONTACT -> this.contact_toggle;
            case ContactTab.OTHER -> this.other_toggle;
            case ContactTab.DIRECTORY -> this.directory_toggle;
        };
    }

    public void addEmptyStyleClass(ContactTab tab) {
        ToggleButton toggleButton = this.getToggleButtonForTab(tab);
        if (toggleButton != null && !toggleButton.getStyleClass().contains((Object)"filter-toggle-empty")) {
            toggleButton.getStyleClass().add((Object)"filter-toggle-empty");
        }
    }

    public void removeEmptyStyleClass(ContactTab tab) {
        ToggleButton toggleButton = this.getToggleButtonForTab(tab);
        if (toggleButton != null) {
            toggleButton.getStyleClass().remove((Object)"filter-toggle-empty");
        }
    }
}

