/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contacts_list;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.contacts.contacts_list.AbstractContactSelectionModalController;
import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class IntroduceContactModalController
extends AbstractContactSelectionModalController<ContactInfo> {
    public IntroduceContactModalController(ContactInfo introducedContact) {
        this.associatedEntity = introducedContact;
        LiveData contacts = SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity;
        LiveData contactsExceptIntroducedContact = ListLiveData.filter(contacts, c -> !c.genId().equals(introducedContact.getItemId()));
        this.selectableContactListViewController = StandardPanelListController.builder().withLiveData(contactsExceptIntroducedContact).withDataClass(ContactInfo.class).withCellFactory((Callback<ListView<ContactInfo>, AbstractListCell<ContactInfo>>)((Callback)param -> new ContactListCell(true))).withoutBottomMargin().defaultComparator().noFilter().setSearchPredicate(ListItemSearchHelper::contactSearchPredicate).withMultipleSelection().withButtonController(this.buttonController).build();
        ViewControllerHelper.smartUIUpdate(() -> {
            this.selectableContactListViewController.getListView().setFixedCellSize(70.0);
            this.selectableContactListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
        });
        this.setSize(ModalConfiguration.ModalSize.MEDIUM);
        this.buttonController.cancel_button.setMaxWidth(80.0);
        this.buttonController.cancel_button.setMinWidth(80.0);
        this.buttonController.validate_button.setMaxWidth(80.0);
        this.buttonController.validate_button.setMinWidth(80.0);
        this.loadFxml();
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    @Override
    protected void validateHandler(MouseEvent event) {
        AppLogger.t("ContactCard::validatePresentation");
        if (this.selectableContactListViewController.getSelectionModel().getSelectedItems() == null || this.selectableContactListViewController.getSelectionModel().getSelectedItems().isEmpty()) {
            AppLogger.d("Empty contact list selected fo presentation");
            return;
        }
        AsyncTaskExecutor.submitTask(() -> InvitationApi.contactIntroduction((ContactInfo)this.associatedEntity, this.selectableContactListViewController.getSelectionModel().getSelectedItems()));
        this.closeModalDelegate.run();
    }
}

