/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contact_details;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;

public class ContactCardModel {
    private final LiveData<List<Group>> customAssociatedGroupListLiveData;
    private final BooleanProperty editMode = new SimpleBooleanProperty(false);
    private final BooleanProperty oneToOne = new SimpleBooleanProperty(false);
    private final StringProperty photoTempPath = new SimpleStringProperty();
    private final BooleanProperty keycloakManaged = new SimpleBooleanProperty(false);
    private final BooleanProperty contactActive = new SimpleBooleanProperty(false);
    private final BooleanProperty isReachable = new SimpleBooleanProperty(false);
    private final BooleanProperty disableInviteProperty = new SimpleBooleanProperty(false);
    public final Id<Contact> contactId;
    private final BooleanProperty hasPendingInvitation = new SimpleBooleanProperty(false);
    private LiveData<Optional<Invitation>> invitationLiveData;
    private final BooleanProperty isIncomingInvitation = new SimpleBooleanProperty(false);
    private final BooleanProperty isOutgoingInvitation = new SimpleBooleanProperty(false);
    private final LiveDataListener<Optional<Invitation>> invitationListener = this::invitationLiveDataListener;

    public ContactCardModel(Id<Contact> contactId) {
        this.contactId = contactId;
        this.customAssociatedGroupListLiveData = LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getGroupDao().getAllGroupsWithSpecificContact(contactId, true), List.of(Group.class, ContactGroupJoin.class));
        this.disableInviteProperty.bind((ObservableValue)this.oneToOne.or((ObservableBooleanValue)this.isReachable.not().and((ObservableBooleanValue)this.keycloakManaged.not())).or((ObservableBooleanValue)this.contactActive.not()));
        this.setupInvitationObserver();
    }

    public Optional<ContactInfo> getContactInfo() {
        return DbCache.getInstance().getContactInfo(this.contactId);
    }

    public LiveData<List<Group>> getCustomAssociatedGroupListLiveData() {
        return this.customAssociatedGroupListLiveData;
    }

    public Discussion getAssociatedDiscussion() {
        return DbManager.getInstance().getDiscussionDao().getDiscussionByContactId(this.contactId);
    }

    public boolean isEditMode() {
        return this.editMode.get();
    }

    public BooleanProperty editModeProperty() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode.set(editMode);
    }

    public boolean isOneToOne() {
        return this.oneToOne.get();
    }

    public BooleanProperty oneToOneProperty() {
        return this.oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne.set(oneToOne);
    }

    public String getPhotoTempPath() {
        return (String)this.photoTempPath.get();
    }

    public StringProperty photoTempPathProperty() {
        return this.photoTempPath;
    }

    public void setPhotoTempPath(String photoTempPath) {
        this.photoTempPath.set((Object)photoTempPath);
    }

    public BooleanProperty keycloakManagedProperty() {
        return this.keycloakManaged;
    }

    public void setKeycloak(boolean keycloak) {
        this.keycloakManaged.set(keycloak);
    }

    public boolean getIsReachable() {
        return this.isReachable.get();
    }

    public BooleanProperty isReachableProperty() {
        return this.isReachable;
    }

    public void setIsReachable(boolean isReachable) {
        this.isReachable.set(isReachable);
    }

    public void setContactActive(boolean active) {
        this.contactActive.set(active);
    }

    public BooleanProperty disableInvite() {
        return this.disableInviteProperty;
    }

    public BooleanProperty activeProperty() {
        return this.contactActive;
    }

    private void setupInvitationObserver() {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<OwnedIdentityInfo> selectedIdentityOpt = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
            Optional<ContactInfo> contactInfoOpt = this.getContactInfo();
            if (selectedIdentityOpt.isPresent() && contactInfoOpt.isPresent()) {
                byte[] contact = contactInfoOpt.get().bytesContactIdentity();
                this.invitationLiveData = DbManager.getInstance().getInvitationDao().getContactOneToOneInvitationLiveData((Id<OwnedIdentity>)selectedIdentityOpt.get().getItemId(), contact);
            }
        });
    }

    private void invitationLiveDataListener(Optional<Invitation> newInvitation, Optional<Invitation> oldInvitation) {
        Platform.runLater(() -> {
            if (newInvitation.isEmpty()) {
                this.hasPendingInvitation.set(false);
                this.isIncomingInvitation.set(false);
                this.isOutgoingInvitation.set(false);
            } else {
                Invitation invite = (Invitation)newInvitation.get();
                this.hasPendingInvitation.set(true);
                this.isIncomingInvitation.set(invite.getState() == InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT);
                this.isOutgoingInvitation.set(invite.getState() == InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT);
            }
            this.hasPendingInvitation.set(newInvitation.isPresent());
        });
    }

    public void unplugModel() {
        if (this.invitationLiveData != null) {
            this.invitationLiveData.removeListener(this::invitationLiveDataListener);
        }
    }

    public void plugModel() {
        if (this.invitationLiveData != null) {
            this.invitationLiveData.addListener(this::invitationLiveDataListener);
        }
    }

    public BooleanProperty hasPendingInvitationProperty() {
        return this.hasPendingInvitation;
    }

    public LiveData<Optional<Invitation>> getInvitationLiveData() {
        return this.invitationLiveData;
    }

    public BooleanProperty isIncomingInvitationProperty() {
        return this.isIncomingInvitation;
    }

    public BooleanProperty isOutgoingInvitationProperty() {
        return this.isOutgoingInvitation;
    }
}

