/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contact_details;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;
import io.olvid.windows.messenger.fx.contacts.contact_details.ConfirmDeleteContactModalController;
import io.olvid.windows.messenger.fx.contacts.contact_details.ContactCardModel;
import io.olvid.windows.messenger.fx.contacts.contact_details.GroupItem;
import io.olvid.windows.messenger.fx.contacts.contacts_list.IntroduceContactModalController;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.bubbles.PolarPane;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.lib.OlvidBindings;
import io.olvid.windows.messenger.fx.framework.utils.FxButtons;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ScrollbarOverlayHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextHolder;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;

public class ContactCardController
extends BaseViewController {
    private final ScrollPane root;
    private final VBox groups_box;
    private final Label name_label;
    private final TextField name_text_field;
    private final Label position_label;
    private final Button recreate_channel;
    private final Button delete_contact;
    private final Button bubble_button;
    private final Button open_discussion;
    private final Button add_contact;
    private final Button cancel_invitation;
    private final Button introduce_contact;
    private final Button close_button;
    private final Button previous_button;
    private final Button modification_button;
    private final Button accepte_contact;
    private final Button refuse_invitation;
    private final StackPane camera;
    private final IdentityBubble contact_bubble;
    private final Button channel_creation_button;
    private final VBox channel_creation_box;
    private final Region delete_contact_sep;
    private LiveDataListener<List<Group>> groupListener;
    private final ContactCardModel model;
    private final LiveDataListener<Optional<ContactInfo>> listener = this::onContactChange;
    private final RightPanelContextHolder navigation;
    private LiveDataListener<Boolean> navigationEmptyLiveDataListener;
    private final ObservableList<Group> groups = FXCollections.observableArrayList();

    public ContactCardController(Id<Contact> contactID, RightPanelContextHolder navigation) {
        String[] sheets;
        this.logger.trace("ContactCard::ContactCard");
        this.navigation = navigation;
        this.model = new ContactCardModel(contactID);
        this.root = new ScrollPane();
        this.root.setFitToWidth(true);
        this.root.setFitToHeight(true);
        this.root.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.root.setPrefWidth(460.0);
        this.root.getStyleClass().add((Object)"white-scroll");
        VBox mainContainer = new VBox();
        mainContainer.setAlignment(Pos.TOP_CENTER);
        mainContainer.getStyleClass().add((Object)"white-pane");
        mainContainer.setPadding(new Insets(24.0, 24.0, 24.0, 24.0));
        for (String s : sheets = new String[]{"color.css", "light_mode.css", "font.css", "pane.css", "buttons.css", "icon.css", "shape.css", "other.css", "list.css"}) {
            URL resource = this.getClass().getResource("/io/olvid/windows/messenger/design_system/" + s);
            if (resource == null) continue;
            this.root.getStylesheets().add((Object)resource.toExternalForm());
        }
        URL componentCss = this.getClass().getResource("contact_card.css");
        if (componentCss != null) {
            this.root.getStylesheets().add((Object)componentCss.toExternalForm());
        }
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER);
        VBox.setMargin((Node)header, (Insets)new Insets(0.0, 0.0, 16.0, 0.0));
        this.previous_button = new Button();
        this.previous_button.setCancelButton(true);
        this.previous_button.setPrefSize(29.0, 29.0);
        this.previous_button.getStyleClass().add((Object)"empty-button");
        SvgSizeable prevIcon = new SvgSizeable();
        prevIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-arrow-left"});
        this.previous_button.setGraphic((Node)prevIcon);
        HBox.setMargin((Node)this.previous_button, (Insets)new Insets(0.0, 16.0, 0.0, 0.0));
        this.close_button = new Button();
        this.close_button.setCancelButton(true);
        this.close_button.setPrefSize(29.0, 29.0);
        this.close_button.getStyleClass().add((Object)"empty-button");
        SvgSizeable closeIcon = new SvgSizeable();
        closeIcon.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-close"});
        this.close_button.setGraphic((Node)closeIcon);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.modification_button = new Button("Button");
        this.modification_button.setDefaultButton(true);
        this.modification_button.setPrefHeight(29.0);
        this.modification_button.getStyleClass().addAll((Object[])new String[]{"empty-button", "h2"});
        header.getChildren().addAll((Object[])new Node[]{this.previous_button, this.close_button, spacer, this.modification_button});
        this.bubble_button = new Button();
        this.bubble_button.setPrefSize(82.0, 82.0);
        this.bubble_button.getStyleClass().add((Object)"empty-button");
        VBox.setMargin((Node)this.bubble_button, (Insets)new Insets(0.0, 0.0, 28.0, 0.0));
        this.contact_bubble = new IdentityBubble(41.0);
        this.contact_bubble.setGroup(false);
        this.camera = new StackPane();
        Circle cameraCircle = new Circle(12.0);
        cameraCircle.getStyleClass().addAll((Object[])new String[]{"blue-shape", "border-white"});
        SvgSizeable cameraIcon = new SvgSizeable();
        cameraIcon.getStyleClass().addAll((Object[])new String[]{"icon-xxsmall", "icon-white"});
        this.camera.getChildren().addAll((Object[])new Node[]{cameraCircle, cameraIcon});
        PolarPane polarPane = new PolarPane();
        polarPane.getChildren().add((Object)this.camera);
        this.contact_bubble.getChildren().add((Object)polarPane);
        this.bubble_button.setGraphic((Node)this.contact_bubble);
        StackPane titleWrapper = new StackPane();
        VBox.setMargin((Node)titleWrapper, (Insets)new Insets(0.0, 0.0, 32.0, 0.0));
        this.name_label = new Label();
        this.name_label.getStyleClass().add((Object)"h1");
        this.name_label.setWrapText(true);
        this.name_label.setTextAlignment(TextAlignment.CENTER);
        this.name_text_field = new TextField();
        this.name_text_field.getStyleClass().add((Object)"h1");
        titleWrapper.getChildren().addAll((Object[])new Node[]{this.name_label, this.name_text_field});
        this.position_label = new Label();
        this.position_label.getStyleClass().add((Object)"body-1");
        this.position_label.setWrapText(true);
        this.position_label.setTextAlignment(TextAlignment.CENTER);
        VBox.setMargin((Node)this.position_label, (Insets)new Insets(0.0, 0.0, 32.0, 0.0));
        this.channel_creation_box = new VBox();
        this.channel_creation_box.setPadding(new Insets(24.0, 24.0, 24.0, 24.0));
        this.channel_creation_box.getStyleClass().add((Object)"connection-box");
        VBox.setMargin((Node)this.channel_creation_box, (Insets)new Insets(0.0, 0.0, 16.0, 0.0));
        Label ccTitle = new Label(ViewControllerHelper.getString("contact_card_channel_creation_ongoing_title"));
        ccTitle.getStyleClass().add((Object)"h2");
        ccTitle.setWrapText(true);
        Label ccDesc = new Label(ViewControllerHelper.getString("contact_card_channel_creation_ongoing_description"));
        ccDesc.getStyleClass().add((Object)"body-2");
        ccDesc.setWrapText(true);
        this.channel_creation_button = new Button(ViewControllerHelper.getString("contact_card_channel_creation_ongoing_action"));
        this.channel_creation_button.setMaxWidth(Double.MAX_VALUE);
        this.channel_creation_button.getStyleClass().add((Object)"secondary-button");
        VBox.setMargin((Node)this.channel_creation_button, (Insets)new Insets(16.0, 0.0, 0.0, 0.0));
        this.channel_creation_box.getChildren().addAll((Object[])new Node[]{ccTitle, ccDesc, this.channel_creation_button});
        HBox actionButtons = new HBox(10.0);
        VBox.setMargin((Node)actionButtons, (Insets)new Insets(0.0, 0.0, 40.0, 0.0));
        this.open_discussion = FxButtons.create(() -> this.handleGoToDiscussion(null)).label(ViewControllerHelper.getString("contact_card_talk")).leftIcon("svg-discussion-fill").fullWidth().centerContent(true).addStyleClasses("grey-button").addLabelStyleClasses("body-1", "black-text").minHeight(50.0).prefHeight(50.0).padding(new Insets(13.0, 16.0, 13.0, 16.0)).spacing(10.0).build();
        HBox.setHgrow((Node)this.open_discussion, (Priority)Priority.ALWAYS);
        this.add_contact = FxButtons.create(() -> this.handleUpgradeOneToOneButton(null)).label(ViewControllerHelper.getString("contact_card_add_a_contact")).leftIcon("svg-new-contact").fullWidth().centerContent(true).addStyleClasses("grey-button").addLabelStyleClasses("body-1", "black-text").minHeight(50.0).prefHeight(50.0).padding(new Insets(13.0, 16.0, 13.0, 16.0)).build();
        HBox.setHgrow((Node)this.add_contact, (Priority)Priority.ALWAYS);
        this.cancel_invitation = FxButtons.create(() -> this.handleCancelInvitation(null)).label(ViewControllerHelper.getString("contact_card_cancel_invitation")).fullWidth().centerContent(true).addStyleClasses("warning-button").addLabelStyleClasses("body-1", "white-text").minHeight(50.0).prefHeight(50.0).padding(new Insets(13.0, 16.0, 13.0, 16.0)).build();
        HBox.setHgrow((Node)this.cancel_invitation, (Priority)Priority.ALWAYS);
        this.accepte_contact = new Button(ViewControllerHelper.getString("button_label_accept"));
        this.accepte_contact.setOnAction(e -> this.handleAnswerInvitation(true));
        this.accepte_contact.getStyleClass().addAll((Object[])new String[]{"button-outline", "button-outline-primary"});
        this.accepte_contact.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.accepte_contact, (Priority)Priority.ALWAYS);
        this.accepte_contact.setMinHeight(50.0);
        this.accepte_contact.setPrefHeight(50.0);
        this.refuse_invitation = new Button(ViewControllerHelper.getString("button_label_refuse"));
        this.refuse_invitation.setOnAction(e -> this.handleAnswerInvitation(false));
        this.refuse_invitation.getStyleClass().addAll((Object[])new String[]{"button-outline", "button-outline-danger"});
        this.refuse_invitation.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.refuse_invitation, (Priority)Priority.ALWAYS);
        this.refuse_invitation.setMinHeight(50.0);
        this.refuse_invitation.setPrefHeight(50.0);
        this.introduce_contact = FxButtons.create(() -> this.handlePresentationButton(null)).label(ViewControllerHelper.getString("contact_card_introduce_a_contact")).leftIcon("svg-arrow-left").fullWidth().centerContent(true).addStyleClasses("grey-button").addLabelStyleClasses("body-1", "black-text").minHeight(50.0).prefHeight(50.0).padding(new Insets(13.0, 16.0, 13.0, 16.0)).build();
        HBox.setHgrow((Node)this.introduce_contact, (Priority)Priority.ALWAYS);
        actionButtons.getChildren().addAll((Object[])new Node[]{this.open_discussion, this.add_contact, this.cancel_invitation, this.accepte_contact, this.refuse_invitation, this.introduce_contact});
        Label commonGroupsTitle = new Label(ViewControllerHelper.getString("contact_card_common_group"));
        commonGroupsTitle.getStyleClass().add((Object)"h2");
        commonGroupsTitle.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)commonGroupsTitle, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)commonGroupsTitle, (Insets)new Insets(0.0, 0.0, 16.0, 0.0));
        this.groups_box = new VBox();
        this.recreate_channel = new Button();
        this.recreate_channel.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.recreate_channel.setMaxWidth(Double.MAX_VALUE);
        this.recreate_channel.getStyleClass().add((Object)"empty-button");
        Label recreateLabel = new Label(ViewControllerHelper.getString("contact_card_recreate_channel"));
        recreateLabel.setPrefHeight(61.0);
        recreateLabel.setMaxWidth(Double.MAX_VALUE);
        recreateLabel.getStyleClass().addAll((Object[])new String[]{"body-1", "black-text"});
        this.recreate_channel.setGraphic((Node)recreateLabel);
        this.delete_contact_sep = new Region();
        this.delete_contact_sep.getStyleClass().add((Object)"sep-light-grey");
        this.delete_contact = new Button();
        this.delete_contact.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.delete_contact.setMaxWidth(Double.MAX_VALUE);
        this.delete_contact.setPrefHeight(61.0);
        this.delete_contact.getStyleClass().addAll((Object[])new String[]{"empty-button", "danger-text"});
        Label deleteLabel = new Label();
        deleteLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.model.oneToOneProperty().get() ? ViewControllerHelper.getString("contact_card_remove_contact") : ViewControllerHelper.getString("contact_card_delete_user"), (Observable[])new Observable[]{this.model.oneToOneProperty()}));
        deleteLabel.setMaxWidth(Double.MAX_VALUE);
        deleteLabel.getStyleClass().addAll((Object[])new String[]{"body-1", "danger-text"});
        this.delete_contact.setGraphic((Node)deleteLabel);
        mainContainer.getChildren().addAll((Object[])new Node[]{header, this.bubble_button, titleWrapper, this.position_label, this.channel_creation_box, actionButtons, commonGroupsTitle, this.groups_box, this.recreate_channel, this.delete_contact_sep, this.delete_contact});
        this.root.setContent((Node)mainContainer);
        this.initialize();
        this.bindLifecycle();
        DbCache.getInstance().contactInfoMapLiveData.addListener(contactID, this.listener);
    }

    private void handleCancelInvitation(Event event) {
        Optional<Invitation> currentInv = this.model.getInvitationLiveData().getValue();
        Optional<OwnedIdentityInfo> ownedIdentityOpt = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (currentInv.isPresent() && ownedIdentityOpt.isPresent()) {
            byte[] ownedBytes = ownedIdentityOpt.get().bytesOwnedIdentity();
            AsyncTaskExecutor.submitTask(() -> {
                boolean success = InvitationApi.abortOneToOneInvitationSent((Invitation)currentInv.get(), ownedBytes);
                if (success) {
                    this.logger.info("Invitation 1-to-1 annul\u00e9e avec succ\u00e8s.");
                } else {
                    this.logger.error("\u00c9chec de l'annulation de l'invitation.");
                }
            });
        }
    }

    public void initialize() {
        this.logger.trace("ContactCard::initialize");
        this.groupListener = (newValue, oldValue) -> {
            if (newValue != null) {
                ViewControllerHelper.smartUIUpdate(() -> this.groups.setAll((Collection)newValue));
            }
        };
        OlvidBindings.bindMappedContent(this.groups_box.getChildren(), this.groups, this::createGroupItem);
        this.model.getCustomAssociatedGroupListLiveData().addListener(this.groupListener);
        this.initButtonModification();
        this.initBubble();
        this.initTextArea();
        this.initDiscussionButtons();
        this.delete_contact.setOnAction(this::handleDeleteButton);
        this.recreate_channel.setOnAction(event -> {
            if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isEmpty() || this.model.getContactInfo().isEmpty()) {
                return;
            }
            byte[] bytesOwnedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity();
            byte[] bytesContactIdentity = this.model.getContactInfo().get().bytesContactIdentity();
            try {
                EngineWrapper.getInstance().recreateAllChannels(bytesOwnedIdentity, bytesContactIdentity);
            }
            catch (Exception e) {
                this.logger.error("Cannot recreate channels with %s".formatted(this.model.getContactInfo().get().genId()), e);
            }
        });
        this.close_button.setOnAction(event -> this.close());
        this.previous_button.managedProperty().bind((ObservableValue)this.previous_button.visibleProperty());
        this.navigationEmptyLiveDataListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.previous_button.visibleProperty().set(newValue == false));
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().addListener(this.navigationEmptyLiveDataListener);
        this.previous_button.disableProperty().bind((ObservableValue)this.model.editModeProperty());
        this.previous_button.setOnAction(event -> this.navigation.goToPrevious());
        this.channel_creation_box.managedProperty().bind((ObservableValue)this.channel_creation_box.visibleProperty());
        this.channel_creation_box.visibleProperty().bind((ObservableValue)this.model.isReachableProperty().not().and((ObservableBooleanValue)this.model.keycloakManagedProperty().not()));
        this.handleChannelCreation();
    }

    private void close() {
        if (this.model.editModeProperty().get()) {
            this.stopEditing();
        } else {
            this.navigation.close();
        }
    }

    private void handleChannelCreation() {
        this.channel_creation_button.setOnAction(event -> this.model.getContactInfo().ifPresent(contactInfo -> {
            try {
                EngineWrapper.getInstance().recreateAllChannels(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().orElseThrow(IllegalStateException::new).bytesOwnedIdentity(), this.model.getContactInfo().get().bytesContactIdentity());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private Node createGroupItem(Group group) {
        Button item = new GroupItem(group).getLayout();
        item.setOnAction(event -> this.handleGroupSelected((Id<Group>)group.getItemId()));
        return item;
    }

    private void initDiscussionButtons() {
        this.open_discussion.setOnAction(this::handleGoToDiscussion);
        this.add_contact.setOnAction(this::handleUpgradeOneToOneButton);
        this.introduce_contact.setOnAction(this::handlePresentationButton);
        this.cancel_invitation.setOnAction(this::handleCancelInvitation);
        this.accepte_contact.setOnAction(e -> this.handleAnswerInvitation(true));
        this.refuse_invitation.setOnAction(e -> this.handleAnswerInvitation(false));
        this.open_discussion.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty());
        this.open_discussion.managedProperty().bind((ObservableValue)this.open_discussion.visibleProperty());
        this.introduce_contact.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty());
        this.introduce_contact.managedProperty().bind((ObservableValue)this.introduce_contact.visibleProperty());
        this.add_contact.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty().not().and((ObservableBooleanValue)this.model.hasPendingInvitationProperty().not()).and((ObservableBooleanValue)this.model.disableInvite().not()));
        this.add_contact.managedProperty().bind((ObservableValue)this.add_contact.visibleProperty());
        this.cancel_invitation.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty().not().and((ObservableBooleanValue)this.model.isOutgoingInvitationProperty()));
        this.cancel_invitation.managedProperty().bind((ObservableValue)this.cancel_invitation.visibleProperty());
        this.accepte_contact.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty().not().and((ObservableBooleanValue)this.model.isIncomingInvitationProperty()));
        this.accepte_contact.managedProperty().bind((ObservableValue)this.accepte_contact.visibleProperty());
        this.refuse_invitation.visibleProperty().bind((ObservableValue)this.model.oneToOneProperty().not().and((ObservableBooleanValue)this.model.isIncomingInvitationProperty()));
        this.refuse_invitation.managedProperty().bind((ObservableValue)this.refuse_invitation.visibleProperty());
    }

    private void initBubble() {
        OlvidBindings.bindClass((Node)this.bubble_button).to((ObservableValue<String>)Bindings.when((ObservableBooleanValue)this.model.editModeProperty()).then("bubble_edit").otherwise("bubble_inert"));
        this.bubble_button.disableProperty().bind((ObservableValue)this.model.editModeProperty().not());
        this.bubble_button.setOnAction(this::handleModifyContactPhoto);
        this.bubble_button.setGraphic((Node)this.contact_bubble);
        this.camera.managedProperty().bind((ObservableValue)this.camera.visibleProperty());
        this.camera.visibleProperty().bind((ObservableValue)this.model.editModeProperty());
        PolarPane.setAngle((Node)this.camera, 45);
        PolarPane.setRadius((Node)this.camera, this.contact_bubble.getRadius());
    }

    private void initTextArea() {
        this.name_label.managedProperty().bind((ObservableValue)this.name_label.visibleProperty());
        this.name_label.visibleProperty().bind((ObservableValue)this.model.editModeProperty().not());
        this.name_text_field.managedProperty().bind((ObservableValue)this.name_text_field.visibleProperty());
        this.name_text_field.visibleProperty().bind((ObservableValue)this.model.editModeProperty());
    }

    private void initButtonModification() {
        this.modification_button.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.model.editModeProperty()).then(ViewControllerHelper.getString("group_card_modification_button_save")).otherwise(ViewControllerHelper.getString("group_card_modification_button_modify")));
        this.modification_button.setOnAction(event -> {
            if (this.model.editModeProperty().get()) {
                this.save();
                this.model.editModeProperty().set(false);
            } else {
                this.model.editModeProperty().set(true);
            }
        });
    }

    private void save() {
        String currentPhoto;
        String displayName;
        this.logger.trace("ContactCard::handleEditContactNickname");
        if (this.model.getContactInfo().isEmpty()) {
            return;
        }
        ContactInfo contact = this.model.getContactInfo().get();
        String currentTitle = this.name_text_field.getText() == null ? null : this.name_text_field.getText().trim().replace("\n", " ");
        if (!Objects.equals(currentTitle, displayName = contact.customDisplayName().orElse(contact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)))) {
            if (currentTitle == null || currentTitle.isEmpty()) {
                AsyncTaskExecutor.submitTask(() -> ContactApi.editContactNicknameDbTask(contact.genId(), Optional.empty()));
            } else {
                AsyncTaskExecutor.submitTask(() -> ContactApi.editContactNicknameDbTask(contact.genId(), Optional.of(currentTitle)));
            }
        }
        if (!Objects.equals(currentPhoto = (String)this.model.photoTempPathProperty().get(), this.model.getContactInfo().get().getCustomPhotoUrlOrPhotoUrl().orElse(null))) {
            this.model.getContactInfo().ifPresent(contactInfo -> AsyncTaskExecutor.submitTask(() -> DbManager.getInstance().getContactDao().updateContactCustomUrl(contactInfo.genId(), currentPhoto)));
        }
    }

    private void stopEditing() {
        this.model.getContactInfo().flatMap(ContactInfo::getCustomPhotoUrlOrPhotoUrl).ifPresentOrElse(s -> {
            if (!Objects.equals(s, this.model.getPhotoTempPath())) {
                this.model.setPhotoTempPath((String)s);
                this.contact_bubble.setPhotoUrlRelPath(Optional.of(s));
            }
        }, () -> {
            this.model.setPhotoTempPath(null);
            this.contact_bubble.setPhotoUrlRelPath(Optional.empty());
        });
        this.model.editModeProperty().set(false);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        ScrollbarOverlayHelper.setupOverlayScrollbar(this.root);
        this.model.plugModel();
    }

    @Override
    public void onLayoutDetached() {
        this.logger.trace("ContactCard::onLayoutDetached");
        DbCache.getInstance().contactInfoMapLiveData.removeListener(this.model.contactId, this.listener);
        this.model.getCustomAssociatedGroupListLiveData().removeListener(this.groupListener);
        OlvidBindings.unbindMappedContent(this.groups_box.getChildren(), this.groups);
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().removeListener(this.navigationEmptyLiveDataListener);
        ScrollbarOverlayHelper.removeListeners(this.root);
        this.model.unplugModel();
    }

    private void onContactChange(Optional<ContactInfo> newContactOpt, Optional<ContactInfo> oldContact) {
        this.logger.trace("ContactCard::onChange");
        if (newContactOpt.isEmpty()) {
            if (oldContact != null && oldContact.isPresent() && !this.navigation.goToPrevious()) {
                this.navigation.close();
            }
            return;
        }
        ContactInfo newContact = newContactOpt.get();
        if (!newContact.areContentTheSame(oldContact)) {
            this.logger.trace("ContactCard::setContent");
            ViewControllerHelper.smartUIUpdate(() -> {
                this.model.setKeycloak(newContact.isKeycloakManaged());
                this.model.setOneToOne(newContact.isOneToOne());
                this.model.setIsReachable(newContact.isReachable());
                this.model.setContactActive(newContact.isActive());
                this.model.setPhotoTempPath(newContact.getCustomPhotoUrlOrPhotoUrl().orElse(null));
                BubbleUtils.setBubbleData(newContact, this.contact_bubble);
                String displayName = newContact.customDisplayName().orElse(newContact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
                this.name_label.setText(displayName);
                String position = newContact.detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY);
                this.position_label.setText(position);
                this.name_text_field.setText((String)newContact.customDisplayName().orElse(null));
            });
        }
    }

    private void handleGroupSelected(Id<Group> group) {
        if (group == null) {
            return;
        }
        RightPanelContextState.GroupCard newState = new RightPanelContextState.GroupCard(group);
        this.navigation.getRightPanelContext().updateLocalContext(newState, false);
    }

    private void handlePresentationButton(Event event) {
        this.logger.trace("ContactCard::handlePresentationButton");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(new IntroduceContactModalController(contactInfoOpt.get())));
    }

    private void handleDeleteButton(Event event) {
        this.logger.trace("ContactCard::handleDeleteButton");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        Runnable deleteAction = () -> {
            ContactInfo contactInfo = (ContactInfo)contactInfoOpt.get();
            AsyncTaskExecutor.submitTask(() -> {
                Contact contact = DbManager.getInstance().getContactDao().get(contactInfo.genId());
                if (contact.isCollected()) {
                    if (Api.getContactApi().deleteContact(contact)) {
                        this.logger.debug("Deleted Contact");
                        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
                        if (discussion != null && discussion.isContactDiscussion() && discussion.getContactId().isPresent() && DbCache.getInstance().getContactInfo(discussion.getContactId().get()).isPresent() && Arrays.equals(DbCache.getInstance().getContactInfo(discussion.getContactId().get()).get().bytesContactIdentity(), contact.getBytesContactIdentity())) {
                            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, null));
                            this.navigation.close();
                        }
                    } else {
                        this.logger.debug("Unable to delete contact");
                    }
                } else if (Api.getContactApi().downgradeOneToOneContact(contact)) {
                    this.logger.debug("Contact downgraded");
                } else {
                    this.logger.error("Unable to downgrade contact");
                }
            });
        };
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(new ConfirmDeleteContactModalController(deleteAction, contactInfoOpt.get())));
    }

    private void handleUpgradeOneToOneButton(Event event) {
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        ContactInfo contactInfo = contactInfoOpt.get();
        if (SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent()) {
            OwnedIdentityInfo ownedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get();
            if (this.model.keycloakManagedProperty().get()) {
                KeycloakManager.getInstance().addContactWithEngineSignedDetails(ownedIdentity.bytesOwnedIdentity(), contactInfo.bytesContactIdentity());
            }
            AsyncTaskExecutor.submitTask(() -> ContactApi.upgradeContactToOneToOne((ContactInfo)contactInfoOpt.get(), ownedIdentity.bytesOwnedIdentity()));
        }
    }

    private void handleGoToDiscussion(Event event) {
        this.logger.trace("ContactCard::handleGoToDiscussion");
        AsyncTaskExecutor.submitTask(() -> {
            Discussion associatedDiscussion = this.model.getAssociatedDiscussion();
            DiscussionApi.unHideDiscussionIfHiddenDbTask(associatedDiscussion);
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, associatedDiscussion.getItemId()));
        });
    }

    private void handleModifyContactPhoto(ActionEvent event) {
        this.logger.trace("ContactCard::handleModifyContactPhoto");
        Optional<ContactInfo> contactInfoOpt = this.model.getContactInfo();
        if (contactInfoOpt.isEmpty()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("photo_chooser_title"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File homeFile = homePath == null ? null : new File(homePath);
        fileChooser.setInitialDirectory(homeFile);
        File photo = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (photo != null && !photo.getAbsolutePath().isEmpty()) {
            AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(photo.getAbsolutePath(), 1080, 1080, photoTempPath -> {
                this.model.setPhotoTempPath((String)photoTempPath);
                this.contact_bubble.setPhotoUrlRelPath(Optional.of(photoTempPath));
            }, error -> this.logger.error("ContactCard::importAndUpdateGroupPhotoTask: task error: ", (Exception)error)));
        }
    }

    private void handleAnswerInvitation(boolean accept) {
        Optional<Invitation> currentInv = this.model.getInvitationLiveData().getValue();
        Optional<OwnedIdentityInfo> ownedIdentityOpt = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
        if (currentInv.isPresent() && ownedIdentityOpt.isPresent()) {
            byte[] ownedBytes = ownedIdentityOpt.get().bytesOwnedIdentity();
            AsyncTaskExecutor.submitTask(() -> InvitationApi.answerOneToOneInvitation((Invitation)currentInv.get(), accept, ownedBytes));
        }
    }
}

