/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.contacts.contact_details;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class ConfirmDeleteContactModalController
extends BaseModalController {
    private final VBox root = new VBox(24.0);
    private final Runnable onConfirm;
    private final Button closeButton = new Button();
    private final ContactInfo contactInfo;

    public ConfirmDeleteContactModalController(Runnable onConfirm, ContactInfo contact) {
        Objects.requireNonNull(contact);
        this.onConfirm = onConfirm;
        this.contactInfo = contact;
        this.buildUI();
    }

    @Override
    public ModalConfiguration.ModalSize getSize() {
        return ModalConfiguration.ModalSize.SELF_SIZE;
    }

    private void buildUI() {
        this.root.setMinWidth(400.0);
        this.root.setMaxWidth(500.0);
        this.root.setMaxHeight(270.0);
        this.root.setPadding(new Insets(16.0));
        this.root.getStyleClass().addAll((Object[])new String[]{"white-pane", "modal-child-container"});
        this.root.getStylesheets().add((Object)"fx/contacts/contact_details/contact_card.css");
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        Label title = new Label(this.contactInfo.isOneToOne() ? ViewControllerHelper.getString("contact_card_remove_contact") : ViewControllerHelper.getString("contact_card_delete_user"));
        title.getStyleClass().add((Object)"h1");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.setOnAction(e -> this.getCloseModalDelegate().run());
        header.getChildren().addAll((Object[])new Node[]{title, spacer, this.closeButton});
        Label message = new Label(this.contactInfo.isOneToOne() ? ViewControllerHelper.getString("contact_downgrade_user_explanation", this.contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)) : ViewControllerHelper.getString("contact_delete_user_explanation", this.contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
        message.getStyleClass().add((Object)"body-1");
        message.setWrapText(true);
        HBox buttonBox = new HBox(12.0);
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        Button cancelButton = new Button(ViewControllerHelper.getString("modal.cancel"));
        cancelButton.getStyleClass().add((Object)"secondary-button");
        cancelButton.setOnAction(e -> this.getCloseModalDelegate().run());
        Button confirmButton = new Button(ViewControllerHelper.getString("confirm_label"));
        confirmButton.getStyleClass().add((Object)"warning-button");
        confirmButton.setOnAction(e -> {
            this.getCloseModalDelegate().run();
            if (this.onConfirm != null) {
                this.onConfirm.run();
            }
        });
        buttonBox.getChildren().addAll((Object[])new Node[]{cancelButton, confirmButton});
        Region separator = new Region();
        VBox.setVgrow((Node)separator, (Priority)Priority.ALWAYS);
        this.root.getChildren().addAll((Object[])new Node[]{header, message, separator, buttonBox});
    }

    @Override
    public Region getLayout() {
        return this.root;
    }
}

