/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvGroupOwnerAndUidKey;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.sync.ContactSyncSnapshot;
import io.olvid.windows.messenger.engine.sync.GroupSyncSnapshot;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OwnedIdentitySyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String CUSTOM_NAME = "custom_name";
    public static final String CONTACTS = "contacts";
    public static final String GROUPS = "groups";
    public static final String GROUPS2 = "groups2";
    public static final String PINNED = "pinned";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("custom_name", "contacts", "groups", "groups2"));
    public String custom_name;
    @JsonSerialize(contentUsing=ObvBytesKey.Serializer.class)
    @JsonDeserialize(contentUsing=ObvBytesKey.Deserializer.class)
    public List<ObvBytesKey> pinned_discussions;
    public Boolean pinned_sorted;
    public HashSet<String> domain;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, ContactSyncSnapshot> contacts;
    @JsonSerialize(keyUsing=ObvGroupOwnerAndUidKey.Serializer.class)
    @JsonDeserialize(keyUsing=ObvGroupOwnerAndUidKey.Deserializer.class)
    public HashMap<ObvGroupOwnerAndUidKey, GroupSyncSnapshot> groups;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, GroupSyncSnapshot> groups2;

    public static OwnedIdentitySyncSnapshot of(DbManager db, OwnedIdentity ownedIdentity) {
        OwnedIdentitySyncSnapshot ownedIdentitySyncSnapshot = new OwnedIdentitySyncSnapshot();
        ownedIdentitySyncSnapshot.custom_name = ownedIdentity.getNickname().orElse(null);
        ownedIdentitySyncSnapshot.contacts = new HashMap();
        for (Contact contact : db.getContactDao().getSortedOneToOneContactsByOwnedIdentity(ownedIdentity)) {
            ownedIdentitySyncSnapshot.contacts.put(new ObvBytesKey(contact.getBytesContactIdentity()), ContactSyncSnapshot.of(db, contact));
        }
        ownedIdentitySyncSnapshot.groups = new HashMap();
        for (Group group : db.getGroupDao().getGroupsAssociatedToIdentity((Id<OwnedIdentity>)ownedIdentity.getItemId())) {
            ownedIdentitySyncSnapshot.groups.put(new ObvGroupOwnerAndUidKey(group.getBytesGroupIdentifier()), GroupSyncSnapshot.of(db, group));
        }
        ownedIdentitySyncSnapshot.groups2 = new HashMap();
        for (Group group2 : db.getGroupDao().getGroupsAssociatedToIdentity((Id<OwnedIdentity>)ownedIdentity.getItemId())) {
            ownedIdentitySyncSnapshot.groups2.put(new ObvBytesKey(group2.getBytesGroupIdentifier()), GroupSyncSnapshot.of(db, group2));
        }
        ownedIdentitySyncSnapshot.domain = DEFAULT_DOMAIN;
        return ownedIdentitySyncSnapshot;
    }

    @JsonIgnore
    public void restore(DbManager db, OwnedIdentity ownedIdentity) {
        if (this.domain.contains(CUSTOM_NAME) && this.custom_name != null) {
            db.getOwnedIdentityDao().updateNickname((Id<OwnedIdentity>)ownedIdentity.getItemId(), Optional.of(this.custom_name));
        }
        if (this.domain.contains(CONTACTS) && this.contacts != null) {
            for (Map.Entry<ObvBytesKey, ContactSyncSnapshot> entry : this.contacts.entrySet()) {
                try {
                    entry.getValue().restore(db, ownedIdentity.getBytesOwnedIdentity(), entry.getKey().getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.domain.contains(GROUPS) && this.groups != null) {
            for (Map.Entry<Object, Object> entry : this.groups.entrySet()) {
                try {
                    ((GroupSyncSnapshot)entry.getValue()).restore(db, ownedIdentity, ((ObvGroupOwnerAndUidKey)entry.getKey()).getGroupOwnerAndUid());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.domain.contains(GROUPS2) && this.groups2 != null) {
            for (Map.Entry<Object, Object> entry : this.groups2.entrySet()) {
                try {
                    ((GroupSyncSnapshot)entry.getValue()).restore(db, ownedIdentity, ((ObvBytesKey)entry.getKey()).getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        GroupHelper.updateGroupMembersNamesForIdentity(ownedIdentity);
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof OwnedIdentitySyncSnapshot)) {
            return false;
        }
        OwnedIdentitySyncSnapshot other = (OwnedIdentitySyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        block12: while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "custom_name": {
                    if (Objects.equals(this.custom_name, other.custom_name)) break;
                    return false;
                }
                case "contacts": {
                    if (!Objects.equals(this.contacts.keySet(), other.contacts.keySet())) {
                        return false;
                    }
                    for (Map.Entry<Object, Object> entry : this.contacts.entrySet()) {
                        if (((ContactSyncSnapshot)entry.getValue()).areContentsTheSame(other.contacts.get(entry.getKey()))) continue;
                        return false;
                    }
                    continue block12;
                }
                case "groups": {
                    if (!Objects.equals(this.groups.keySet(), other.groups.keySet())) {
                        return false;
                    }
                    for (Map.Entry<Object, Object> entry : this.groups.entrySet()) {
                        if (((GroupSyncSnapshot)entry.getValue()).areContentsTheSame(other.groups.get(entry.getKey()))) continue;
                        return false;
                    }
                    continue block12;
                }
                case "groups2": {
                    if (!Objects.equals(this.groups2.keySet(), other.groups2.keySet())) {
                        return false;
                    }
                    for (Map.Entry<Object, Object> entry : this.groups2.entrySet()) {
                        if (((GroupSyncSnapshot)entry.getValue()).areContentsTheSame(other.groups2.get(entry.getKey()))) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        return true;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

