/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.sync.DiscussionCustomizationSyncSnapshot;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String CUSTOM_NAME = "custom_name";
    public static final String PERSONAL_NOTE = "personal_note";
    public static final String DISCUSSION_CUSTOMIZATION = "discussion_customization";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("custom_name", "personal_note", "discussion_customization"));
    public String custom_name;
    public String personal_note;
    public DiscussionCustomizationSyncSnapshot discussion_customization;
    public HashSet<String> domain;

    public static GroupSyncSnapshot of(DbManager db, Group group2) {
        DiscussionCustomization discussionCustomization;
        GroupSyncSnapshot groupV2SyncSnapshot = new GroupSyncSnapshot();
        groupV2SyncSnapshot.custom_name = group2.getCustomName().orElse(null);
        groupV2SyncSnapshot.personal_note = group2.getPersonalNote().orElse(null);
        Discussion discussion = db.getDiscussionDao().getDiscussionFromGroupIdentifier(group2.getBytesGroupIdentifier(), group2.getOwnedIdentityId());
        if (discussion != null && (discussionCustomization = db.getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId())) != null) {
            groupV2SyncSnapshot.discussion_customization = DiscussionCustomizationSyncSnapshot.of(discussionCustomization);
        }
        groupV2SyncSnapshot.domain = DEFAULT_DOMAIN;
        return groupV2SyncSnapshot;
    }

    public void restore(DbManager db, OwnedIdentity ownedIdentity, byte[] bytesGroupIdentifier) {
        Group group2 = db.getGroupDao().get(ownedIdentity, bytesGroupIdentifier);
        if (group2 != null) {
            Discussion discussion = db.getDiscussionDao().getDiscussionFromGroupIdentifier(group2.getBytesGroupIdentifier(), (Id<OwnedIdentity>)ownedIdentity.getItemId());
            if (this.domain.contains(CUSTOM_NAME)) {
                db.getGroupDao().updateCustomName((Id<Group>)group2.getItemId(), Optional.ofNullable(this.custom_name));
            }
            if (this.domain.contains(PERSONAL_NOTE) && this.personal_note != null) {
                db.getGroupDao().updatePersonalNote((Id<Group>)group2.getItemId(), Optional.ofNullable(this.personal_note));
            }
            if (this.domain.contains(DISCUSSION_CUSTOMIZATION) && this.discussion_customization != null && discussion != null) {
                this.discussion_customization.restore(db, discussion);
            }
        }
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof GroupSyncSnapshot)) {
            return false;
        }
        GroupSyncSnapshot other = (GroupSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "custom_name": {
                    if (Objects.equals(this.custom_name, other.custom_name)) break;
                    return false;
                }
                case "personal_note": {
                    if (Objects.equals(this.personal_note, other.personal_note)) break;
                    return false;
                }
                case "discussion_customization": {
                    if ((this.discussion_customization != null || other.discussion_customization == null) && (this.discussion_customization == null || this.discussion_customization.areContentsTheSame(other.discussion_customization))) break;
                    return false;
                }
            }
        }
        return true;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

