/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscussionCustomizationSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String LOCAL_SETTINGS = "local_settings";
    public static final String SHARED_SETTINGS = "shared_settings";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(List.of("local_settings", "shared_settings"));
    public LocalSettings local_settings;
    public SharedSettings shared_settings;
    public HashSet<String> domain;

    public static DiscussionCustomizationSyncSnapshot of(DiscussionCustomization discussionCustomization) {
        DiscussionCustomizationSyncSnapshot discussionCustomizationSyncSnapshot = new DiscussionCustomizationSyncSnapshot();
        if (discussionCustomization.getSharedSettingsJson() != null) {
            SharedSettings sharedSettings = new SharedSettings();
            sharedSettings.version = discussionCustomization.getSharedSettingsVersion();
            sharedSettings.existence_duration = discussionCustomization.getSettingExistenceDuration().orElse(null);
            sharedSettings.visibility_duration = discussionCustomization.getSettingVisibilityDuration().orElse(null);
            sharedSettings.read_once = discussionCustomization.getSettingReadOnce();
            discussionCustomizationSyncSnapshot.shared_settings = sharedSettings;
        }
        discussionCustomizationSyncSnapshot.domain = DEFAULT_DOMAIN;
        return discussionCustomizationSyncSnapshot;
    }

    public void restore(DbManager db, Discussion discussion) {
        boolean insertionNeeded = false;
        boolean changed = false;
        DiscussionCustomization discussionCustomization = db.getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
        if (discussionCustomization == null) {
            discussionCustomization = DiscussionCustomization.createDiscussionCustomizationFromDefaultValues(discussion);
            insertionNeeded = true;
        }
        if (this.domain.contains(SHARED_SETTINGS) && this.shared_settings != null && this.shared_settings.version != null) {
            changed = true;
            discussionCustomization.setSharedSettingsVersion(this.shared_settings.version);
            discussionCustomization.setSettingVisibilityDuration(Optional.ofNullable(this.shared_settings.visibility_duration));
            discussionCustomization.setSettingExistenceDuration(Optional.ofNullable(this.shared_settings.existence_duration));
            discussionCustomization.setSettingReadOnce(this.shared_settings.read_once != null && this.shared_settings.read_once != false);
            JsonExpiration jsonExpiration = new JsonExpiration();
            jsonExpiration.setVisibilityDuration(this.shared_settings.visibility_duration);
            jsonExpiration.setExistenceDuration(this.shared_settings.existence_duration);
            jsonExpiration.setReadOnce(this.shared_settings.read_once);
            JsonSharedSettings jsonSharedSettings = new JsonSharedSettings();
            jsonSharedSettings.setVersion(this.shared_settings.version);
            jsonSharedSettings.setJsonExpiration(jsonExpiration);
            IdentityRef identityRef = db.getIdentityRefDao().getOrCreateOwnedIdentityRef(discussion.getOwnedIdentityId());
            SystemMessage settingsMessage = MessageBuilder.createDiscussionSettingsUpdateMessage(discussion, jsonExpiration, identityRef, System.currentTimeMillis(), MessageBuilder.MessageSystemPosition.MESSAGE_TIMESTAMP);
            db.getSystemMessageDao().insert(settingsMessage);
        }
        if (changed) {
            if (insertionNeeded) {
                db.getDiscussionCustomizationDao().insert(discussionCustomization);
            } else {
                db.getDiscussionCustomizationDao().update(discussionCustomization);
            }
        }
    }

    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof DiscussionCustomizationSyncSnapshot)) {
            return false;
        }
        DiscussionCustomizationSyncSnapshot other = (DiscussionCustomizationSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "shared_settings": {
                    if ((this.shared_settings != null || other.shared_settings == null) && (this.shared_settings == null || this.shared_settings.areContentsTheSame(other.shared_settings))) break;
                    return false;
                }
            }
        }
        return true;
    }

    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SharedSettings {
        public Integer version;
        public Long existence_duration;
        public Long visibility_duration;
        public Boolean read_once;

        public boolean areContentsTheSame(SharedSettings other) {
            return Objects.equals(this.version, other.version) && Objects.equals(this.existence_duration, other.existence_duration) && Objects.equals(this.visibility_duration, other.visibility_duration) && (this.read_once != null && this.read_once != false) == (other.read_once != null && other.read_once != false);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LocalSettings {
        public Boolean send_read_receipt;

        public boolean areContentsTheSame(LocalSettings other) {
            return Objects.equals(this.send_read_receipt, other.send_read_receipt);
        }
    }
}

