/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.sync.DiscussionCustomizationSyncSnapshot;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContactSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String CUSTOM_NAME = "custom_name";
    public static final String DISCUSSION_CUSTOMIZATION = "discussion_customization";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("custom_name", "discussion_customization"));
    public String custom_name;
    public Integer custom_hue;
    public DiscussionCustomizationSyncSnapshot discussion_customization;
    public HashSet<String> domain;

    public static ContactSyncSnapshot of(DbManager db, Contact contact) {
        DiscussionCustomization discussionCustomization;
        Discussion discussion;
        ContactSyncSnapshot contactSyncSnapshot = new ContactSyncSnapshot();
        contactSyncSnapshot.custom_name = contact.getCustomDisplayName().orElse(null);
        if (contact.isOneToOne() && (discussion = db.getDiscussionDao().get(contact)) != null && (discussionCustomization = db.getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId())) != null) {
            contactSyncSnapshot.discussion_customization = DiscussionCustomizationSyncSnapshot.of(discussionCustomization);
        }
        contactSyncSnapshot.domain = DEFAULT_DOMAIN;
        return contactSyncSnapshot;
    }

    public void restore(DbManager db, byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        Contact contact = db.getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact != null) {
            Discussion discussion = db.getDiscussionDao().get(contact);
            if (this.domain.contains(CUSTOM_NAME)) {
                db.getContactDao().updateContactCustomName((Id<Contact>)contact.getItemId(), Optional.ofNullable(this.custom_name));
            }
            if (this.domain.contains(DISCUSSION_CUSTOMIZATION) && this.discussion_customization != null && discussion != null) {
                this.discussion_customization.restore(db, discussion);
            }
        }
    }

    @JsonIgnore
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof ContactSyncSnapshot)) {
            return false;
        }
        ContactSyncSnapshot other = (ContactSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "custom_name": {
                    if (Objects.equals(this.custom_name, other.custom_name)) break;
                    return false;
                }
                case "discussion_customization": {
                    if ((this.discussion_customization != null || other.discussion_customization == null) && (this.discussion_customization == null || this.discussion_customization.areContentsTheSame(other.discussion_customization))) break;
                    return false;
                }
            }
        }
        return true;
    }

    @JsonIgnore
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

