/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.service;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractExpirationTimerService {
    private Long scheduledAlarmTimestamp = null;
    private Timer expireTimer = null;
    private TimerTask expireTimerTask = null;
    protected AppLogger logger = new AppLogger(this.getClass());

    protected AbstractExpirationTimerService() {
        AsyncTaskExecutor.submitTask(() -> {
            this.expirationAction();
            this.scheduleNextExpiration();
        });
    }

    protected abstract void expirationAction();

    protected abstract Optional<Long> getNextExpiration();

    public void scheduleNextExpiration() {
        try {
            this.logger.debug("scheduleNextExpiration");
            Optional<Long> nextExpiration = this.getNextExpiration();
            if (nextExpiration.isEmpty()) {
                return;
            }
            if (Objects.equals(this.scheduledAlarmTimestamp, nextExpiration.get())) {
                this.logger.trace("MessageExpirationHelper::scheduleNextExpiration already scheduled");
                return;
            }
            this.scheduledAlarmTimestamp = nextExpiration.get();
            if (this.expireTimer == null) {
                this.expireTimer = new Timer("AppMessageExpirationServiceTimer");
            }
            if (this.expireTimerTask != null) {
                this.expireTimerTask.cancel();
            }
            this.expireTimerTask = new TimerTask(){

                @Override
                public void run() {
                    AbstractExpirationTimerService.this.expirationAction();
                    AbstractExpirationTimerService.this.scheduleNextExpiration();
                }
            };
            long delay = this.scheduledAlarmTimestamp - System.currentTimeMillis() + 10L;
            if (delay < 0L) {
                delay = 0L;
            }
            this.expireTimer.schedule(this.expireTimerTask, delay);
        }
        catch (Exception e) {
            this.logger.error("Error while scheduling next expiration handling task...", e);
        }
    }
}

