/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications.tools;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;

public class UpdateContactDisplayNameAndPhotoDbTask
implements Runnable {
    private final byte[] bytesIdentity;
    private final byte[] bytesOwnedIdentity;
    private final JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto;

    public UpdateContactDisplayNameAndPhotoDbTask(byte[] bytesContactIdentity, byte[] bytesOwnedIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto) {
        this.bytesIdentity = bytesContactIdentity;
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.jsonIdentityDetailsWithVersionAndPhoto = jsonIdentityDetailsWithVersionAndPhoto;
    }

    @Override
    public void run() {
        if (this.jsonIdentityDetailsWithVersionAndPhoto == null) {
            return;
        }
        JsonIdentityDetails identityDetails = this.jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails();
        if (identityDetails == null || identityDetails.isEmpty()) {
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(this.bytesOwnedIdentity, this.bytesIdentity);
        if (contact == null) {
            return;
        }
        DbManager.getInstance().getIdentityDetailsDao().updateDetailsAndPhoto(contact.getIdentityDetailsId(), identityDetails, this.jsonIdentityDetailsWithVersionAndPhoto.getPhotoUrl());
        DbManager.getInstance().getContactDao().updatedUnpublishedDetails((Id<Contact>)contact.getItemId(), ContactGenerated.UnpublishedDetails.NOTHING_NEW);
        DbManager.getInstance().getContactDao().updateSortDisplayName((Id<Contact>)contact.getItemId());
        ContactApi.updateAllGroupMemberName((Id<Contact>)contact.getItemId());
    }
}

