/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications.tools;

import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.logger.AppLogger;

public class InsertContactRevokedMessageTask
implements Runnable {
    private final byte[] bytesOwnedIdentity;
    private final byte[] bytesContactIdentity;

    public InsertContactRevokedMessageTask(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.bytesContactIdentity = bytesContactIdentity;
    }

    @Override
    public void run() {
        try {
            Contact contact = DbManager.getInstance().getContactDao().get(this.bytesOwnedIdentity, this.bytesContactIdentity);
            if (contact == null) {
                throw new Exception("Contact not found");
            }
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(contact);
            if (discussion != null) {
                SystemMessage message = MessageBuilder.createContactInactiveReasonMessage(discussion, ObvContactActiveOrInactiveReason.REVOKED);
                DbManager.getInstance().getSystemMessageDao().insert(message);
                DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, message, false);
            }
        }
        catch (Exception e) {
            AppLogger.e("InsertContactRevokedMessageTask::run Unable to insert contact revoked message.", e);
        }
    }
}

