/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.engine.engine.types.ObvReturnReceipt;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.dao.attachment.AttachmentRecipientInfoDao;
import io.olvid.windows.messenger.database.dao.attachment.OutboundAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.MessageRecipientInfoDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.OutboundMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.helpers.message.tasks.ExpiringOutboundMessageSentTask;
import io.olvid.windows.messenger.engine.helpers.message.tasks.NewMessageReceivedTask;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.misc.Watches;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MessageNotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_new_message_received", "engine_notification_message_uploaded", "engine_notification_message_upload_failed", "engine_notification_return_receipt_received"};

    MessageNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("MessageNotificationListener: notification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_new_message_received": {
                    ObvMessage obvMessage = (ObvMessage)userInfo.get("message");
                    if (obvMessage == null) {
                        return;
                    }
                    new NewMessageReceivedTask(obvMessage).run();
                    break;
                }
                case "engine_notification_message_uploaded": {
                    Watches.Watch watch = Watches.getInstance().start("MessageNotificationListener#messageUploadedHandler");
                    this.messageUploadedHandler(userInfo);
                    watch.stop();
                    break;
                }
                case "engine_notification_return_receipt_received": {
                    Watches.Watch watch = Watches.getInstance().start("MessageNotificationListener#returnReceiptReceivedHandler");
                    this.returnReceiptReceivedHandler(userInfo);
                    watch.stop();
                    break;
                }
                case "engine_notification_message_upload_failed": {
                    this.messageUploadFailedHandler(userInfo);
                    break;
                }
                default: {
                    this.logger.error("Invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("MessageNotificationListener::callback: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void messageUploadedHandler(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("identifier");
        Long timestampFromServer = (Long)userInfo.get("timestamp_from_server");
        MessageRecipientInfoDao messageRecipientInfosDao = DbManager.getInstance().getMessageRecipientInfoDao();
        List<MessageRecipientInfo> messageRecipientInfos = messageRecipientInfosDao.getAllByEngineMessageIdentifier(bytesOwnedIdentity, engineMessageIdentifier);
        if (!messageRecipientInfos.isEmpty()) {
            Id<OutboundMessage> messageId = messageRecipientInfos.get(0).getMessageId();
            for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfos) {
                this.updateMessageRecipientInfoTimestampSent(messageRecipientInfo, timestampFromServer);
                messageRecipientInfosDao.update(messageRecipientInfo);
            }
            Api.getMessageApi().refreshOutboundStatus(messageId);
        }
    }

    private void returnReceiptReceivedHandler(HashMap<String, Object> userInfo) {
        Long timestamp = (Long)userInfo.get("timestamp");
        if (timestamp == null) {
            return;
        }
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] serverUid = (byte[])userInfo.get("server_uid");
        byte[] returnReceiptNonce = (byte[])userInfo.get("nonce");
        byte[] encryptedPayload = (byte[])userInfo.get("encrypted_payload");
        MessageRecipientInfoDao messageRecipientInfoDao = DbManager.getInstance().getMessageRecipientInfoDao();
        OutboundAttachmentDao outboundAttachmentDao = DbManager.getInstance().getOutboundAttachmentDao();
        AttachmentRecipientInfoDao attachmentRecipientInfoDao = DbManager.getInstance().getAttachmentRecipientInfoDao();
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("MessageNotificationListener::returnReceiptReceivedHandler: Didn't find ownedIdentity");
            return;
        }
        byte[][] returnReceiptKeys = messageRecipientInfoDao.getReturnReceiptKeysForNonce(returnReceiptNonce);
        if (returnReceiptKeys == null) {
            this.logger.trace("MessageNotificationListener::returnReceiptReceivedHandler: return receipt keys are null. It Could happened if the message is deleted.");
            return;
        }
        ObvReturnReceipt obvReturnReceipt = null;
        byte[] goodReturnReceiptKey = null;
        for (byte[] returnReceiptKey : returnReceiptKeys) {
            obvReturnReceipt = EngineWrapper.getInstance().decryptReturnReceipt(returnReceiptKey, encryptedPayload);
            if (obvReturnReceipt == null) continue;
            goodReturnReceiptKey = returnReceiptKey;
            break;
        }
        if (obvReturnReceipt != null) {
            IdentityRef identityRef;
            if (Arrays.equals(ownedIdentity.getBytesOwnedIdentity(), obvReturnReceipt.getBytesContactIdentity())) {
                identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)ownedIdentity.getItemId());
            } else {
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, obvReturnReceipt.getBytesContactIdentity());
                identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contactRef);
            }
            List<MessageRecipientInfo> messageRecipientInfos = messageRecipientInfoDao.getFromReturnReceipt(identityRef, returnReceiptNonce, goodReturnReceiptKey);
            Integer attachmentIndex = obvReturnReceipt.getAttachmentNumber();
            block11: for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfos) {
                ReturnReceiptStatus status = ReturnReceiptStatus.of(obvReturnReceipt.getStatus());
                if (attachmentIndex == null) {
                    switch (status) {
                        case UNKNOWN: {
                            continue block11;
                        }
                        case DELIVERED: {
                            this.updateMessageRecipientInfoTimestampDelivered(messageRecipientInfo, timestamp);
                            break;
                        }
                        case READ: {
                            this.updateMessageRecipientInfoTimestampRead(messageRecipientInfo, timestamp);
                        }
                    }
                    messageRecipientInfoDao.update(messageRecipientInfo);
                    Api.getMessageApi().refreshOutboundStatus(messageRecipientInfo.getMessageId());
                    continue;
                }
                AttachmentRecipientInfo attachmentRecipientInfos = attachmentRecipientInfoDao.getFromMessageRecipientInfo(messageRecipientInfo, attachmentIndex);
                if (attachmentRecipientInfos == null) continue;
                switch (status) {
                    case UNKNOWN: {
                        continue block11;
                    }
                    case DELIVERED: {
                        this.updateAttachmentRecipientInfoTimestampDelivered(attachmentRecipientInfos, timestamp);
                        break;
                    }
                    case READ: {
                        this.updateAttachmentRecipientInfoTimestampRead(attachmentRecipientInfos, timestamp);
                    }
                }
                attachmentRecipientInfoDao.update(attachmentRecipientInfos);
                OutboundAttachment attachment = outboundAttachmentDao.get(attachmentRecipientInfos.getAttachmentId());
                if (attachment == null || !AttachmentUtils.refreshStatus(attachment)) continue;
                outboundAttachmentDao.updateStatus((Id<OutboundAttachment>)attachment.getItemId(), attachment.getStatus());
            }
        }
        EngineWrapper.getInstance().deleteReturnReceipt(bytesOwnedIdentity, serverUid);
    }

    private void messageUploadFailedHandler(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("identifier");
        List<MessageRecipientInfo> messageRecipientInfos = DbManager.getInstance().getMessageRecipientInfoDao().getAllByEngineMessageIdentifier(bytesOwnedIdentity, engineMessageIdentifier);
        if (!messageRecipientInfos.isEmpty()) {
            OutboundMessage message;
            Id<OutboundMessage> messageId = messageRecipientInfos.get(0).getMessageId();
            boolean hasUnsentMessageRecipientInfo = false;
            for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfos) {
                if (!messageRecipientInfo.getTimestampSent().isEmpty()) continue;
                hasUnsentMessageRecipientInfo = true;
                break;
            }
            if (hasUnsentMessageRecipientInfo && (message = DbManager.getInstance().getOutboundMessageDao().get(messageId)) != null) {
                message.setStatus(OutboundMessageGenerated.Status.UNDELIVERED);
                DbManager.getInstance().getOutboundMessageDao().updateStatus((Id<OutboundMessage>)message.getItemId(), message.getStatus());
                DbManager.getInstance().getOutboundMessageMetadataDao().insert(new OutboundMessageMetadata(message, OutboundMessageMetadataGenerated.Kind.UNDELIVERED, System.currentTimeMillis()));
                AsyncTaskExecutor.submitTask(new ExpiringOutboundMessageSentTask(message));
            }
        }
    }

    private void updateMessageRecipientInfoTimestampSent(MessageRecipientInfo messageRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        Optional<Long> timestampSentOpt = messageRecipientInfo.getTimestampSent();
        if (timestampSentOpt.isEmpty() || timestampSentOpt.get() > timestamp) {
            messageRecipientInfo.setTimestampSent(Optional.of(timestamp));
        }
    }

    private void updateMessageRecipientInfoTimestampDelivered(MessageRecipientInfo messageRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        this.updateMessageRecipientInfoTimestampSent(messageRecipientInfo, timestamp);
        Optional<Long> timestampDeliveredOpt = messageRecipientInfo.getTimestampDelivered();
        if (timestampDeliveredOpt.isEmpty() || timestampDeliveredOpt.get() > timestamp) {
            messageRecipientInfo.setTimestampDelivered(Optional.of(timestamp));
        }
    }

    private void updateMessageRecipientInfoTimestampRead(MessageRecipientInfo messageRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        this.updateMessageRecipientInfoTimestampDelivered(messageRecipientInfo, timestamp);
        Optional<Long> timestampReadOpt = messageRecipientInfo.getTimestampRead();
        if (timestampReadOpt.isEmpty()) {
            messageRecipientInfo.setTimestampRead(Optional.of(timestamp));
        }
    }

    public static void updateAttachmentRecipientInfoTimestampSent(AttachmentRecipientInfo attachmentRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        Optional<Long> timestampSentOpt = attachmentRecipientInfo.getTimestampSent();
        if (timestampSentOpt.isEmpty() || timestampSentOpt.get() > timestamp) {
            attachmentRecipientInfo.setTimestampSent(Optional.of(timestamp));
        }
    }

    private void updateAttachmentRecipientInfoTimestampDelivered(AttachmentRecipientInfo attachmentRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        MessageNotificationListener.updateAttachmentRecipientInfoTimestampSent(attachmentRecipientInfo, timestamp);
        Optional<Long> timestampDeliveredOpt = attachmentRecipientInfo.getTimestampDelivered();
        if (timestampDeliveredOpt.isEmpty() || timestampDeliveredOpt.get() > timestamp) {
            attachmentRecipientInfo.setTimestampDelivered(Optional.of(timestamp));
        }
    }

    private void updateAttachmentRecipientInfoTimestampRead(AttachmentRecipientInfo attachmentRecipientInfo, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        this.updateAttachmentRecipientInfoTimestampDelivered(attachmentRecipientInfo, timestamp);
        Optional<Long> timestampReadOpt = attachmentRecipientInfo.getTimestampRead();
        if (timestampReadOpt.isEmpty()) {
            attachmentRecipientInfo.setTimestampRead(Optional.of(timestamp));
        }
    }
}

