/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.datatypes.containers.OwnedIdentitySynchronizationStatus;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.EngineAPI;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.owned_device.OwnedDevicesSynchronisationWithEngineTask;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.OwnedIdentitySyncingNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class IdentityNotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_owned_identity_list_updated", "engine_notification_owned_identity_display_name_changed", "engine_notification_owned_identity_latest_details_updated", "engine_notification_owned_identity_changed_active_status", "engine_notification_own_capabilities_updated", "engine_notification_api_key_accepted", "engine_notification_api_key_status_query_success", "engine_notification_api_key_status_query_failed", "engine_notification_push_topic_notified", "engine_notification_keycloak_update_required", "engine_notification_owned_identity_device_list_changed", "engine_notification_owned_identity_deleted_from_another_device", "engine_notification_owned_identity_synchronizing_with_server"};

    IdentityNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("IdentityNotification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_owned_identity_list_updated": {
                    this.ownedIdentityListUpdated(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_latest_details_updated": {
                    this.ownedIdentityLatestDetailsUpdated(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_display_name_changed": {
                    this.ownedIdentityDetailsChanged(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_changed_active_status": {
                    this.ownedIdentityActiveStatusChanged(userInfo);
                    break;
                }
                case "engine_notification_own_capabilities_updated": {
                    this.ownCapabilitiesUpdated(userInfo);
                    break;
                }
                case "engine_notification_api_key_accepted": {
                    this.apiKeyAccepted(userInfo);
                    break;
                }
                case "engine_notification_api_key_status_query_success": {
                    this.apiKeyStatusQuerySuccess(userInfo);
                    break;
                }
                case "engine_notification_api_key_status_query_failed": {
                    this.apiKeyStatusQueryFailed(userInfo);
                    break;
                }
                case "engine_notification_push_topic_notified": {
                    this.processPushTopic(userInfo);
                    break;
                }
                case "engine_notification_keycloak_update_required": {
                    this.keycloakSyncNeeded(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_device_list_changed": {
                    this.deviceSync(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_deleted_from_another_device": {
                    this.ownedIdentityDeletedFromAnotherDevice(userInfo);
                    break;
                }
                case "engine_notification_owned_identity_synchronizing_with_server": {
                    this.ownedIdentitySyncWithServerHandler(userInfo);
                    break;
                }
                default: {
                    this.logger.error("IdentityListener: invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("IdentityNotificationListener::callback: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void processPushTopic(HashMap<String, Object> userInfo) {
        String topic = (String)userInfo.get("topic");
        if (topic == null) {
            return;
        }
        KeycloakManager.getInstance().processPushTopicNotification(topic);
    }

    private void ownedIdentityDeletedFromAnotherDevice(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        if (bytesOwnedIdentity == null) {
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            return;
        }
        OwnedIdentityApi.deleteOwnedIdentity(ownedIdentity);
    }

    private void deviceSync(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        if (bytesOwnedIdentity == null) {
            return;
        }
        AsyncTaskExecutor.submitTask(new OwnedDevicesSynchronisationWithEngineTask(bytesOwnedIdentity));
    }

    private void keycloakSyncNeeded(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        if (bytesOwnedIdentity == null) {
            return;
        }
        KeycloakManager.getInstance().forceSyncManagedIdentity(bytesOwnedIdentity);
    }

    private void ownedIdentityListUpdated(HashMap<String, Object> userInfo) {
        ObvIdentity[] obvOwnedIdentities;
        try {
            obvOwnedIdentities = EngineWrapper.getInstance().getOwnedIdentities();
        }
        catch (Exception e) {
            this.logger.error("Unable to get engine identities", e);
            return;
        }
        List<OwnedIdentity> dbOwnedIdentities = DbManager.getInstance().getOwnedIdentityDao().getAllSortedByIndex();
        if (dbOwnedIdentities == null) {
            this.logger.error("Unable to get fkaOwnedIdentity from db");
            return;
        }
        HashMap<BytesKey, ObvIdentity> obvOwnedIdentitiesMap = new HashMap<BytesKey, ObvIdentity>();
        for (ObvIdentity obvIdentity : obvOwnedIdentities) {
            obvOwnedIdentitiesMap.put(new BytesKey(obvIdentity.getBytesIdentity()), obvIdentity);
        }
        for (OwnedIdentity ownedIdentity : dbOwnedIdentities) {
            ObvIdentity obvIdentity;
            BytesKey bytesKey = new BytesKey(ownedIdentity.getBytesOwnedIdentity());
            if (!obvOwnedIdentitiesMap.containsKey(bytesKey) || (obvIdentity = (ObvIdentity)obvOwnedIdentitiesMap.get(bytesKey)).isKeycloakManaged() == ownedIdentity.isKeycloakManaged()) continue;
            DbManager.getInstance().getOwnedIdentityDao().updateKeycloakManaged(ownedIdentity.getBytesOwnedIdentity(), obvIdentity.isKeycloakManaged());
            if (obvIdentity.isKeycloakManaged()) {
                try {
                    ObvKeycloakState obvKeycloakState = EngineWrapper.getInstance().getOwnedIdentityKeycloakState(ownedIdentity.getBytesOwnedIdentity());
                    KeycloakManager.getInstance().registerKeycloakManagedIdentity(ownedIdentity.getBytesOwnedIdentity(), obvKeycloakState.keycloakServer, obvKeycloakState.clientId, obvKeycloakState.clientSecret, obvKeycloakState.jwks, obvKeycloakState.signatureKey, obvKeycloakState.serializedAuthState, obvKeycloakState.ownApiKey, obvKeycloakState.latestRevocationListTimestamp, false, obvKeycloakState.transferRestricted);
                }
                catch (Exception e) {
                    this.logger.error("Engine failed to retrieve keycloak state", e);
                }
                continue;
            }
            KeycloakManager.getInstance().unregisterKeycloakManagedIdentity(ownedIdentity.getBytesOwnedIdentity());
        }
    }

    private void ownedIdentityDetailsChanged(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        JsonIdentityDetails jsonIdentityDetails = (JsonIdentityDetails)userInfo.get("display_name");
        String photoUrl = (String)userInfo.get("photo_url");
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null || jsonIdentityDetails == null || jsonIdentityDetails.isEmpty()) {
            this.logger.error("ownedIdentityDetailsChanged: invalid parameters");
            return;
        }
        IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(ownedIdentity.getIdentityDetailsId());
        if (identityDetails == null) {
            this.logger.error("ownedIdentityDetailsChanged: invalid parameters");
            return;
        }
        DbManager.getInstance().getIdentityDetailsDao().updateDetailsAndPhoto((Id<IdentityDetails>)identityDetails.getItemId(), jsonIdentityDetails, photoUrl);
    }

    private void apiKeyAccepted(HashMap<String, Object> userInfo) {
        EnumSet<OwnedIdentity.ApiKeyPermission> oldPermissions;
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        EngineAPI.ApiKeyStatus engineApiKeyStatus = (EngineAPI.ApiKeyStatus)userInfo.get("api_key_status");
        List engineApiKeyPermissions = (List)userInfo.get("permissions");
        Optional<Long> apiKeyExpirationTimestamp = Optional.ofNullable((Long)userInfo.get("api_key_expiration_timestamp"));
        if (bytesOwnedIdentity == null || engineApiKeyStatus == null || engineApiKeyPermissions == null) {
            this.logger.error("API_KEY_ACCEPTED: Error when retrieving userInfo");
            return;
        }
        OwnedIdentityGenerated.ApiKeyStatus apiKeyStatus = OwnedIdentity.of(engineApiKeyStatus);
        EnumSet<OwnedIdentity.ApiKeyPermission> apiKeyPermissions = OwnedIdentity.ApiKeyPermission.of(engineApiKeyPermissions);
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("API_KEY_ACCEPTED: Unable to retrieve fkaOwnedIdentity");
            return;
        }
        boolean changed = false;
        if (ownedIdentity.getApiKeyStatus() != apiKeyStatus) {
            changed = true;
            ownedIdentity.setApiKeyStatus(apiKeyStatus);
        }
        if (!apiKeyExpirationTimestamp.equals(ownedIdentity.getApiKeyExpirationTimestamp())) {
            changed = true;
            ownedIdentity.setApiKeyExpirationTimestamp(apiKeyExpirationTimestamp);
        }
        if (!(oldPermissions = ownedIdentity.getApiKeyPermissionsEnum()).equals(apiKeyPermissions)) {
            ownedIdentity.setApiKeyPermissions(apiKeyPermissions);
            changed = true;
        }
        if (changed) {
            DbManager.getInstance().getOwnedIdentityDao().updateApiKey(ownedIdentity.getBytesOwnedIdentity(), ownedIdentity.getApiKeyStatus(), ownedIdentity.getApiKeyPermissionsEnum(), ownedIdentity.getApiKeyExpirationTimestamp());
        }
    }

    private void ownedIdentityLatestDetailsUpdated(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        boolean hasUnpublished = (Boolean)userInfo.get("has_unpublished");
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity != null) {
            switch (ownedIdentity.getUnpublishedDetails()) {
                case NOTHING_NEW: {
                    if (!hasUnpublished) break;
                    ownedIdentity.setUnpublishedDetails(OwnedIdentityGenerated.UnpublishedDetails.EXIST);
                    DbManager.getInstance().getOwnedIdentityDao().update(ownedIdentity);
                    break;
                }
                case EXIST: {
                    if (hasUnpublished) break;
                    ownedIdentity.setUnpublishedDetails(OwnedIdentityGenerated.UnpublishedDetails.NOTHING_NEW);
                    DbManager.getInstance().getOwnedIdentityDao().update(ownedIdentity);
                }
            }
        }
    }

    private void ownedIdentityActiveStatusChanged(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        Boolean active = (Boolean)userInfo.get("active");
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null || active == null) {
            this.logger.error("ownedIdentityActiveStatusChanged: invalid user data");
            return;
        }
        DbManager.getInstance().getOwnedIdentityDao().updateActive(ownedIdentity, active);
    }

    private void ownCapabilitiesUpdated(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        List obvCapabilities = (List)userInfo.get("capabilities");
        if (bytesOwnedIdentity == null || obvCapabilities == null) {
            this.logger.error("ownCapabilitiesUpdated: invalid user data received");
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("ownCapabilitiesUpdated: cannot find owned identity in db");
            return;
        }
        Capabilities capabilities = DbManager.getInstance().getCapabilitiesDao().get(ownedIdentity.getCapabilitiesId());
        if (capabilities == null) {
            this.logger.error("ownCapabilitiesUpdated: cannot find owned identity capabilities in db");
            return;
        }
        block5: for (ObvCapability obvCapability : ObvCapability.values()) {
            boolean capable = obvCapabilities.contains(obvCapability);
            switch (obvCapability) {
                case WEBRTC_CONTINUOUS_ICE: {
                    if (capable == capabilities.isWebrtcContinuousIce()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateWebrtcContinuousIce(ownedIdentity, capable);
                    continue block5;
                }
                case ONE_TO_ONE_CONTACTS: {
                    if (capable == capabilities.isOneToOneContacts()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateOneToOneContacts(ownedIdentity, capable);
                    continue block5;
                }
                case GROUPS_V2: {
                    if (capable == capabilities.isGroupsV2()) continue block5;
                    DbManager.getInstance().getCapabilitiesDao().updateGroupsV2(ownedIdentity, capable);
                }
            }
        }
    }

    private void ownedIdentitySyncWithServerHandler(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        OwnedIdentitySynchronizationStatus syncStatus = (OwnedIdentitySynchronizationStatus)userInfo.get("status");
        if (bytesOwnedIdentity == null) {
            this.logger.error("IdentityNotificationListener::ownedIdentitySyncWithServerHandler owned identity is null in engine notification, returning....");
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        this.logger.debug("IdentityNotificationListener::ownedIdentitySyncWithServerHandler One of owned identities");
        switch (syncStatus) {
            case SYNCHRONIZED: {
                UtilityNC.fireOwnedIdentitySyncingNotification((Id<OwnedIdentity>)ownedIdentity.getItemId(), OwnedIdentitySyncingNotification.SyncingNotificationState.SYNCED, OwnedIdentitySyncingNotification.SyncingNotificationState.SYNCED);
                break;
            }
            case INITIAL_SYNC_IN_PROGRESS: {
                UtilityNC.fireOwnedIdentitySyncingNotification((Id<OwnedIdentity>)ownedIdentity.getItemId(), OwnedIdentitySyncingNotification.SyncingNotificationState.UNKNOWN, OwnedIdentitySyncingNotification.SyncingNotificationState.IN_PROGRESS);
                break;
            }
            case MANUAL_SYNC_IN_PROGRESS: {
                UtilityNC.fireOwnedIdentitySyncingNotification((Id<OwnedIdentity>)ownedIdentity.getItemId(), OwnedIdentitySyncingNotification.SyncingNotificationState.IN_PROGRESS, OwnedIdentitySyncingNotification.SyncingNotificationState.UNKNOWN);
                break;
            }
            case OTHER_SYNC_IN_PROGRESS: {
                this.logger.trace("IdentityNotificationListener::ownedIdentitySyncWithServerHandler received " + String.valueOf(OwnedIdentitySynchronizationStatus.OTHER_SYNC_IN_PROGRESS) + " , nothing to do...");
            }
        }
    }

    private void apiKeyStatusQuerySuccess(HashMap<String, Object> userInfo) {
        this.logger.error("not implemented notification listener: apiKeyStatusQuerySuccess");
    }

    private void apiKeyStatusQueryFailed(HashMap<String, Object> userInfo) {
        this.logger.error("not implemented notification listener: apiKeyStatusQueryFailed");
    }
}

