/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.identities.ObvGroup;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.database.tables.gen.GroupMemberPermissionsGenerated;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionCreationHelper;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.UpdateGroupDetailsDbTask;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.engine.helpers.message.tasks.PostPendingMessageTask;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class GroupV1NotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_group_created", "engine_notification_group_deleted", "engine_notification_group_member_added", "engine_notification_group_member_removed", "engine_notification_pending_group_member_added", "engine_notification_pending_group_member_removed", "engine_notification_pending_group_member_decline_toggled", "engine_notification_new_group_photo", "engine_notification_group_published_details_updated", "engine_notification_group_published_details_trusted", "engine_notification_new_group_published_details"};

    GroupV1NotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("GroupV1NotificationListener: notification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_group_created": {
                    this.groupCreated(userInfo);
                    break;
                }
                case "engine_notification_group_deleted": {
                    this.groupDeleted(userInfo);
                    break;
                }
                case "engine_notification_group_member_added": {
                    this.groupMemberAdded(userInfo);
                    break;
                }
                case "engine_notification_group_member_removed": {
                    this.groupMemberDeleted(userInfo);
                    break;
                }
                case "engine_notification_pending_group_member_added": {
                    this.groupPendingMemberAdded(userInfo);
                    break;
                }
                case "engine_notification_pending_group_member_removed": {
                    this.groupPendingMemberDeleted(userInfo);
                    break;
                }
                case "engine_notification_pending_group_member_decline_toggled": {
                    this.groupPendingMemberDeclined(userInfo);
                    break;
                }
                case "engine_notification_new_group_photo": {
                    this.newGroupPhoto(userInfo);
                    break;
                }
                case "engine_notification_group_published_details_updated": {
                    this.groupPublishedDetailsUpdated(userInfo);
                    break;
                }
                case "engine_notification_group_published_details_trusted": {
                    this.groupPublishedDetailsTrusted(userInfo);
                    break;
                }
                case "engine_notification_new_group_published_details": {
                    this.newGroupPublishedDetails(userInfo);
                    break;
                }
                default: {
                    this.logger.error("GroupV1NotificationListener: invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("GroupV1NotificationListener: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void groupCreated(HashMap<String, Object> userInfo) {
        ObvGroup obvGroup = (ObvGroup)userInfo.get("group");
        boolean hasMultipleDetails = (Boolean)userInfo.get("has_multiple_details");
        String photoUrl = (String)userInfo.get("photo_url");
        if (obvGroup == null) {
            this.logger.error("GroupV1NotificationListener: groupCreated: unable to decode obvGroup");
            return;
        }
        byte[] bytesGroupOwnerAndUid = obvGroup.getBytesGroupOwnerAndUid();
        byte[] bytesOwnedIdentity = obvGroup.getBytesOwnedIdentity();
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupCreated: unable to get owned Identity");
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                Discussion discussion;
                Optional<Long> messageCount;
                Group group = DbManager.getInstance().getGroupDao().get(ownedIdentity, bytesGroupOwnerAndUid);
                if (group != null) {
                    throw new SQLException("GroupNotificationListener: groupCreated: found a contact that should not be there");
                }
                PreGroup preGroup = DbManager.getInstance().getPreGroupDao().get(bytesOwnedIdentity, bytesGroupOwnerAndUid);
                if (preGroup == null) {
                    group = Group.createGroupV1ForMultipleDetails(obvGroup.getBytesGroupOwnerAndUid(), obvGroup.getBytesGroupOwnerIdentity() == null, ownedIdentity, obvGroup.getGroupDetails(), photoUrl, hasMultipleDetails);
                    group = DbManager.getInstance().getGroupDao().createIfNotExists(group);
                    if (group == null) {
                        throw new SQLException("Cannot insert group in db");
                    }
                    ownPermissions = GroupHelper.getV1OwnGroupPermissions(ownedIdentity, group, obvGroup.getBytesGroupOwnerIdentity() == null);
                    ownPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(ownPermissions);
                    if (ownPermissions == null) {
                        throw new SQLException("Cannot insert group permission in db");
                    }
                } else {
                    group = Group.createGroupV1ForMultipleDetails(obvGroup.getBytesGroupOwnerAndUid(), obvGroup.getBytesGroupOwnerIdentity() == null, ownedIdentity, obvGroup.getGroupDetails(), photoUrl, hasMultipleDetails);
                    group = DbManager.getInstance().getGroupDao().createIfNotExists(group);
                    if (group == null) {
                        throw new SQLException("Cannot insert group in db");
                    }
                    ownPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission(preGroup);
                    if (ownPermissions == null) {
                        throw new SQLException("Cannot find own permissions associated with pre group");
                    }
                    ownPermissions.setGroupOrPreGroup(Either.left(group));
                    if (DbManager.getInstance().getGroupMemberPermissionsDao().update(ownPermissions) != 1) {
                        throw new SQLException("Cannot update group member own permissions");
                    }
                    if (DbManager.getInstance().getPreGroupDao().delete(preGroup) != 1) {
                        throw new SQLException("Cannot delete pre group");
                    }
                }
                if ((messageCount = MessageHelper.countUserMessagesInDiscussion(discussion = DiscussionCreationHelper.createOrReuseGroupDiscussionDbTask(group))).isPresent() && messageCount.get() > 0L) {
                    SystemMessage systemMessage = MessageBuilder.createGroupReJoinedMessage(discussion);
                    DbManager.getInstance().getSystemMessageDao().createIfNotExists(systemMessage);
                }
                for (byte[] bytesGroupMemberIdentity : obvGroup.getBytesGroupMembersIdentities()) {
                    Contact contact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)ownedIdentity.getItemId(), bytesGroupMemberIdentity);
                    if (contact == null) continue;
                    ContactGroupJoin contactGroupJoin = new ContactGroupJoin(contact, ownedIdentity, group);
                    if (DbManager.getInstance().getContactGroupJoinDao().createIfNotExists(contactGroupJoin) == null) {
                        throw new SQLException("Impossible to insert ContactGroupJoin");
                    }
                    GroupMemberPermissions groupMemberPermissions = Arrays.equals(obvGroup.getBytesGroupOwnerIdentity(), contact.getBytesContactIdentity()) ? new GroupMemberPermissions(ownedIdentity, null, null, contactGroupJoin, null, GroupHelper.getDefaultAdminPermissionsAsString()) : new GroupMemberPermissions(ownedIdentity, null, null, contactGroupJoin, null, GroupHelper.getDefaultMemberPermissionsAsString());
                    DbManager.getInstance().getGroupMemberPermissionsDao().insert(groupMemberPermissions);
                    ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                    MessageInsertionHelper.insertMemberJoinedGroupMessage(discussion, contactRef);
                }
                HashSet<BytesKey> hashSet = new HashSet<BytesKey>();
                for (byte[] bytesDeclinedPendingMember : obvGroup.getBytesDeclinedPendingMembers()) {
                    hashSet.add(new BytesKey(bytesDeclinedPendingMember));
                }
                for (ObvIdentity obvPendingGroupMember : obvGroup.getPendingGroupMembers()) {
                    PendingGroupMember pendingGroupMember;
                    ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, obvPendingGroupMember.getBytesIdentity());
                    if (contactRef.getContactId().isEmpty()) {
                        IdentityDetails identityDetails = new IdentityDetails(obvPendingGroupMember.getIdentityDetails());
                        identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
                        if (identityDetails == null) throw new SQLException("GroupV1NotificationListener::run Couldn't create identity details");
                        pendingGroupMember = new PendingGroupMember(group, contactRef, identityDetails, identityDetails.computeSortDisplayName(Optional.empty()), hashSet.contains(new BytesKey(obvPendingGroupMember.getBytesIdentity())));
                    } else {
                        Contact contact = DbManager.getInstance().getContactDao().get(contactRef.getContactId().get());
                        IdentityDetails identityDetailsProxy = new IdentityDetails(contact.getIdentityDetailsId().getId());
                        pendingGroupMember = new PendingGroupMember(group, contactRef, identityDetailsProxy, contact.getSortDisplayName(), hashSet.contains(new BytesKey(obvPendingGroupMember.getBytesIdentity())));
                    }
                    GroupMemberPermissions groupMemberPermissions = new GroupMemberPermissions(ownedIdentity, null, null, null, pendingGroupMember, GroupHelper.getDefaultMemberPermissionsAsString());
                    if (DbManager.getInstance().getPendingGroupMemberDao().createIfNotExists(pendingGroupMember) != null && DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(groupMemberPermissions) != null) continue;
                    throw new SQLException("Impossible to insert PendingGroupV1Member");
                }
                return null;
            });
        }
        catch (SQLException e) {
            this.logger.error("GroupV1NotificationListener: groupCreated: sql exception in transaction", e);
        }
    }

    private void groupDeleted(HashMap<String, Object> userInfo) {
        byte[] bytesGroupOwnerAndUid = (byte[])userInfo.get("bytes_group_owner_and_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        if (bytesGroupOwnerAndUid == null || bytesOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupDeleted: unable to decode userInfo");
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupDeleted: unable to get owned Identity");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(ownedIdentity, bytesGroupOwnerAndUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupDeleted: group not found");
            return;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
        if (discussion == null) {
            this.logger.error("GroupV1NotificationListener: groupDeleted: discussion not found");
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                Optional<Long> messageCount = MessageHelper.countUserMessagesInDiscussion(discussion);
                if (messageCount.isPresent() && messageCount.get() == 0L) {
                    if (DbManager.getInstance().getDiscussionDao().delete(discussion) <= 0) {
                        throw new SQLException("Cannot delete discussion");
                    }
                } else {
                    DiscussionApi.lockDiscussion(discussion);
                    if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                        throw new SQLException("Cannot update discussion");
                    }
                    MessageInsertionHelper.insertLeftGroupMessage(discussion);
                }
                DbManager.getInstance().getGroupDao().delete(group);
                return null;
            });
        }
        catch (SQLException throwables) {
            this.logger.error("GroupV1NotificationListener: groupDeleted: sql exception in transaction", throwables);
        }
    }

    private void groupMemberAdded(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("contact_identity");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || bytesGroupUid == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberAdded: unable to decode userInfo");
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (ownedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberAdded: unable to get owned Identity");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(ownedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberAdded: group not found");
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberAdded: contact not found");
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                JsonSharedSettings jsonSharedSettings;
                DiscussionCustomization discussionCustomization;
                Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
                if (discussion == null) {
                    throw new SQLException("Cannot find discussion");
                }
                ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(group, contact);
                GroupMemberPermissionsGenerated groupMemberPermissions = null;
                if (contactGroupJoin == null) {
                    contactGroupJoin = new ContactGroupJoin(contact, ownedIdentity, group);
                    contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().createIfNotExists(contactGroupJoin);
                    if (contactGroupJoin == null) {
                        throw new SQLException("Cannot insert ContactGroupJoin");
                    }
                    groupMemberPermissions = new GroupMemberPermissions(ownedIdentity, null, null, contactGroupJoin, null, GroupHelper.getDefaultMemberPermissionsAsString());
                    DbManager.getInstance().getGroupMemberPermissionsDao().insert(groupMemberPermissions);
                    ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                    MessageInsertionHelper.insertMemberJoinedGroupMessage(discussion, contactRef);
                }
                List<PendingMessage> pendingMessages = DbManager.getInstance().getPendingMessageDao().getAllByDiscussionAndContact(discussion, contact.getBytesContactIdentity());
                for (PendingMessage pendingMessage : pendingMessages) {
                    new PostPendingMessageTask(pendingMessage).run();
                }
                if (groupMemberPermissions != null && groupMemberPermissions.hasPermissionAdmin() && (discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId())) != null && (jsonSharedSettings = discussionCustomization.getSharedSettingsJson()) != null) {
                    MessagePostHelper.postDiscussionSettingsUpdatedMessageDbTask(discussion, jsonSharedSettings);
                }
                return null;
            });
        }
        catch (SQLException e) {
            this.logger.error("GroupV1NotificationListener: groupMemberAdded: sqlexception in transaction", e);
        }
    }

    private void groupMemberDeleted(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("contact_identity");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || bytesGroupUid == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberDeleted: unable to decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberAdded: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberDeleted: group not found");
            return;
        }
        Contact contact = DbManager.getInstance().getContactDao().get(bytesOwnedIdentity, bytesContactIdentity);
        if (contact == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberDeleted: contact not found");
            return;
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
        if (discussion == null) {
            this.logger.error("GroupV1NotificationListener: groupMemberDeleted: discussion not found");
            return;
        }
        ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(group, contact);
        if (contactGroupJoin != null) {
            DbManager.getInstance().getContactGroupJoinDao().customDelete(contactGroupJoin);
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
            MessageInsertionHelper.insertMemberLeftGroupMessage(discussion, contactRef);
        }
    }

    private void groupPendingMemberAdded(HashMap<String, Object> userInfo) {
        byte[] groupId = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        ObvIdentity obvIdentity = (ObvIdentity)userInfo.get("contact_identity");
        if (bytesOwnedIdentity == null || obvIdentity == null || groupId == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberAdded: cannot decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberAdded: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, groupId);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberAdded: group not found");
            return;
        }
        PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().getMember(group, obvIdentity.getBytesIdentity());
        GroupMemberPermissions groupMemberPermissions = null;
        if (pendingGroupMember == null) {
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(associatedOwnedIdentity, obvIdentity.getBytesIdentity());
            if (contactRef.getContactId().isEmpty()) {
                IdentityDetails identityDetails = new IdentityDetails(obvIdentity.getIdentityDetails());
                identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
                if (identityDetails != null) {
                    pendingGroupMember = new PendingGroupMember(group, contactRef, identityDetails, identityDetails.computeSortDisplayName(Optional.empty()), false);
                } else {
                    this.logger.error("GroupV1NotificationListener::run Couldn't create identity details");
                }
            } else {
                Contact contact = DbManager.getInstance().getContactDao().get(contactRef.getContactId().get());
                IdentityDetails identityDetailsProxy = new IdentityDetails(contact.getIdentityDetailsId().getId());
                pendingGroupMember = new PendingGroupMember(group, contactRef, identityDetailsProxy, contact.getSortDisplayName(), false);
            }
            groupMemberPermissions = new GroupMemberPermissions(associatedOwnedIdentity, null, null, null, pendingGroupMember, GroupHelper.getDefaultMemberPermissionsAsString());
            if (DbManager.getInstance().getPendingGroupMemberDao().createIfNotExists(pendingGroupMember) == null || DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(groupMemberPermissions) == null) {
                this.logger.error("Impossible to insert pending members or pending member permissions...");
            }
        } else {
            DbManager.getInstance().getIdentityDetailsDao().updateDetails(pendingGroupMember.getIdentityDetailsId(), obvIdentity.getIdentityDetails());
        }
    }

    private void groupPendingMemberDeleted(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        ObvIdentity obvIdentity = (ObvIdentity)userInfo.get("contact_identity");
        if (bytesOwnedIdentity == null || obvIdentity == null || bytesGroupUid == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberDeleted: cannot decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberAdded: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GrowupV1NotificationListener: groupPendingMemberDeleted: group not found");
            return;
        }
        PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().getMember(group, obvIdentity.getBytesIdentity());
        if (pendingGroupMember != null) {
            DbManager.getInstance().getPendingGroupMemberDao().customDelete(pendingGroupMember);
        }
    }

    private void groupPendingMemberDeclined(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesContactIdentity = (byte[])userInfo.get("bytes_contact_identity");
        boolean declined = (Boolean)userInfo.get("declined");
        if (bytesOwnedIdentity == null || bytesContactIdentity == null || bytesGroupUid == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberDeclined: cannot decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberDeclined: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupPendingMemberDeclined: groupV1 not found");
            return;
        }
        PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().getMember(group, bytesContactIdentity);
        if (pendingGroupMember != null) {
            pendingGroupMember.setDeclined(declined);
            DbManager.getInstance().getPendingGroupMemberDao().pendingUpdateDeclined(pendingGroupMember);
        }
    }

    private void newGroupPhoto(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesGroupOwnerAndUid = (byte[])userInfo.get("bytes_group_uid");
        Integer version = (Integer)userInfo.get("version");
        Boolean isTrusted = (Boolean)userInfo.get("is_trusted");
        if (version == null || isTrusted == null) {
            this.logger.error("GroupV1NotificationListener: newGroupPhoto: cannot decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: newGroupPhoto: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupOwnerAndUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: newGroupPhoto: group not found");
            return;
        }
        if (isTrusted.booleanValue()) {
            try {
                JsonGroupDetailsWithVersionAndPhoto[] jsons = EngineWrapper.getInstance().getGroupPublishedAndLatestOrTrustedDetails(bytesOwnedIdentity, bytesGroupOwnerAndUid);
                if (jsons[jsons.length - 1].getVersion() == version.intValue()) {
                    AsyncTaskExecutor.submitTask(new UpdateGroupDetailsDbTask(group, jsons[jsons.length - 1]));
                }
            }
            catch (Exception e) {
                this.logger.error("GroupV1NotificationListener: newGroupPhoto: engine exception", e);
            }
        }
    }

    private void groupPublishedDetailsUpdated(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        JsonGroupDetailsWithVersionAndPhoto groupDetails = (JsonGroupDetailsWithVersionAndPhoto)userInfo.get("group_details");
        if (bytesGroupUid == null || bytesOwnedIdentity == null || groupDetails == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsUpdated: cannot decode userInfo");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsUpdated: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsUpdated: group not found");
            return;
        }
        if (GroupHelper.isOwnedIdentityAdmin((Id<Group>)group.getItemId())) {
            AsyncTaskExecutor.submitTask(new UpdateGroupDetailsDbTask(group, groupDetails));
        }
        EngineWrapper.getInstance().trustPublishedGroupDetails(bytesOwnedIdentity, bytesGroupUid);
    }

    private void groupPublishedDetailsTrusted(HashMap<String, Object> userInfo) {
        byte[] bytesGroupUid = (byte[])userInfo.get("bytes_group_uid");
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        JsonGroupDetailsWithVersionAndPhoto groupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)userInfo.get("group_details");
        if (bytesGroupUid == null || bytesOwnedIdentity == null || groupDetailsWithVersionAndPhoto == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsTrusted: cannot decode userInfo");
            return;
        }
        String groupName = groupDetailsWithVersionAndPhoto.getGroupDetails().getName();
        if (groupName == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsTrusted: cannot get new group name");
            return;
        }
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsTrusted: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: groupPublishedDetailsTrusted: group not found");
            return;
        }
        AsyncTaskExecutor.submitTask(new UpdateGroupDetailsDbTask(group, groupDetailsWithVersionAndPhoto));
    }

    private void newGroupPublishedDetails(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] bytesGroupOwnerAndUid = (byte[])userInfo.get("bytes_group_uid");
        OwnedIdentity associatedOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesOwnedIdentity);
        if (associatedOwnedIdentity == null) {
            this.logger.error("GroupV1NotificationListener: newGroupPublishedDetails: ownedIdentity not found");
            return;
        }
        Group group = DbManager.getInstance().getGroupDao().get(associatedOwnedIdentity, bytesGroupOwnerAndUid);
        if (group == null) {
            this.logger.error("GroupV1NotificationListener: newGroupPublishedDetails: group not found");
            return;
        }
        DbManager.getInstance().getGroupDao().updatePublishedDetailsStatus(group, GroupGenerated.PublishedDetails.NEW_UNSEEN);
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
        ContactGroupJoin groupOwnerContactGroupJoin = DbManager.getInstance().getGroupMemberPermissionsDao().getOwnerContactGroupJoin(group);
        Contact contact = DbManager.getInstance().getContactDao().get(groupOwnerContactGroupJoin.getContactId());
        if (discussion != null) {
            ContactRef groupOwnerRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
            MessageInsertionHelper.insertNewPublishedDetailsMessage(discussion, groupOwnerRef);
        }
        try {
            EngineWrapper.getInstance().trustPublishedGroupDetails(bytesOwnedIdentity, bytesGroupOwnerAndUid);
        }
        catch (Exception e) {
            this.logger.error("GroupV1NotificationListener: newGroupPublishedDetails: engine exception", e);
        }
    }
}

