/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.ObvTransferStep;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.engine.atom.tasks.ApplySyncAtomTask;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionCreationHelper;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.engine.helpers.groups.tasks.GroupV2UpsertNotificationHandler;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.fx.notifications.NotificationCenter;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class DialogNotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_ui_dialog", "engine_notification_ui_dialog_deleted"};

    DialogNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("InvitationNotificationListener: notification received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_ui_dialog": {
                    this.uiDialog(userInfo);
                    break;
                }
                case "engine_notification_ui_dialog_deleted": {
                    this.uiDialogDeleted(userInfo);
                    break;
                }
                default: {
                    this.logger.error("InvitationNotificationListener: invalid notification name: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("InvitationNotificationListener: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void uiDialog(HashMap<String, Object> userInfo) {
        ObvDialog obvDialog = (ObvDialog)userInfo.get("dialog");
        long creationTimestamp = (Long)userInfo.get("creation_timestamp");
        if (obvDialog == null) {
            this.logger.error("InvitationNotificationListener: uiDialog: unable to decode userInfo");
            return;
        }
        if (obvDialog.getCategory().getId() == 18) {
            ObvTransferStep obvTransferStep = obvDialog.getCategory().getObvTransferStep();
            Optional<TransferApi.Step> step = TransferApi.of(obvTransferStep);
            if (step.isPresent()) {
                UtilityNC.fireIdentityTransfertStepNotification(step.get(), obvDialog.getUuid(), obvDialog.getBytesOwnedIdentity(), obvDialog.getEncodedElements());
            } else {
                this.logger.debug("InvitationNotificationListener: uiDialog: transfer step not implemented");
            }
            return;
        }
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(obvDialog.getBytesOwnedIdentity());
        if (ownedIdentity == null) {
            this.logger.error("InvitationNotificationListener: uiDialog: owned identity not found");
            return;
        }
        if (obvDialog.getCategory().getId() == 17) {
            new ApplySyncAtomTask(obvDialog.getUuid(), ownedIdentity, obvDialog.getCategory().getObvSyncItem()).run();
            return;
        }
        InvitationGenerated.State state = DialogNotificationListener.getState(obvDialog.getCategory());
        if (state == null) {
            this.logger.error("InvitationNotificationListener: uiDialog: get unhandled dialog type: " + obvDialog.getCategory().getId());
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                Invitation existingInvitation = DbManager.getInstance().getInvitationDao().getInvitationByDialogUUID(obvDialog.getUuid());
                if (existingInvitation != null) {
                    this.updateInvitation(existingInvitation, state, obvDialog);
                } else {
                    switch (state) {
                        case INVITATION_WAIT_YOU_TO_ACCEPT: 
                        case INVITATION_WAIT_IT_TO_ACCEPT: 
                        case INVITATION_STATUS_IN_PROGRESS: 
                        case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: 
                        case INVITATION_WAIT_IT_FOR_SAS_EXCHANGE: 
                        case INTRODUCTION_WAIT_IT_TO_ACCEPT: 
                        case INTRODUCTION_WAIT_YOU_TO_ACCEPT: 
                        case ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT: 
                        case ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT: {
                            this.createContactInvitation(state, obvDialog, ownedIdentity, creationTimestamp);
                            break;
                        }
                        case GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT: 
                        case GROUP_V2_INVITATION_FROZEN: 
                        case GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT: 
                        case GROUP_V2_INVITATION_ACCEPTED: {
                            this.createGroupInvitation(state, obvDialog, ownedIdentity, creationTimestamp);
                        }
                    }
                }
                return null;
            });
        }
        catch (SQLException throwables) {
            this.logger.error("InvitationNotificationListener: uiDialog: exception in transaction", throwables);
        }
    }

    private Optional<JsonIdentityDetails> extractJsonIdentityDetailsForContactInvitation(InvitationGenerated.State State2, ObvDialog obvDialog) {
        try {
            switch (State2) {
                case INVITATION_WAIT_YOU_TO_ACCEPT: 
                case INVITATION_WAIT_IT_TO_ACCEPT: 
                case INVITATION_STATUS_IN_PROGRESS: 
                case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: 
                case INVITATION_WAIT_IT_FOR_SAS_EXCHANGE: {
                    if (State2 == InvitationGenerated.State.INVITATION_WAIT_IT_TO_ACCEPT) {
                        JsonIdentityDetails jsonIdentityDetails = new JsonIdentityDetails();
                        jsonIdentityDetails.setFirstName(obvDialog.getCategory().getContactDisplayNameOrSerializedDetails());
                        return Optional.of(jsonIdentityDetails);
                    }
                    JsonIdentityDetails jsonIdentityDetails = (JsonIdentityDetails)EngineWrapper.getJsonObjectMapper().readValue(obvDialog.getCategory().getContactDisplayNameOrSerializedDetails(), JsonIdentityDetails.class);
                    return Optional.of(jsonIdentityDetails);
                }
                case INTRODUCTION_WAIT_IT_TO_ACCEPT: 
                case INTRODUCTION_WAIT_YOU_TO_ACCEPT: {
                    JsonIdentityDetails jsonIdentityDetails = (JsonIdentityDetails)EngineWrapper.getJsonObjectMapper().readValue(obvDialog.getCategory().getContactDisplayNameOrSerializedDetails(), JsonIdentityDetails.class);
                    return Optional.of(jsonIdentityDetails);
                }
                case GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT: 
                case GROUP_V2_INVITATION_FROZEN: 
                case GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT: 
                case ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT: 
                case ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT: 
                case GROUP_V2_INVITATION_ACCEPTED: {
                    return Optional.empty();
                }
            }
        }
        catch (Exception e) {
            AppLogger.e("InvitationNotificationListener: extractJsonIdentityDetailsForContactInvitation: cannot parse details", e);
        }
        return Optional.empty();
    }

    private void updateInvitation(Invitation existingInvitation, InvitationGenerated.State State2, ObvDialog obvDialog) throws SQLException {
        boolean updateSuccess;
        if (existingInvitation.getDiscussion().getPreContactId().isPresent()) {
            IdentityDetails existingIdentityDetails;
            PreContact preContact = DbManager.getInstance().getPreContactDao().get(existingInvitation.getDiscussion().getPreContactId().get());
            Optional<JsonIdentityDetails> jsonIdentityDetails = this.extractJsonIdentityDetailsForContactInvitation(State2, obvDialog);
            if (jsonIdentityDetails.isPresent() && !(existingIdentityDetails = DbManager.getInstance().getIdentityDetailsDao().get(preContact.getIdentityDetailsId())).equalsTo(jsonIdentityDetails.get())) {
                DbManager.getInstance().getIdentityDetailsDao().updateDetails((Id<IdentityDetails>)existingIdentityDetails.getItemId(), jsonIdentityDetails.get());
            }
        }
        if (obvDialog.getCategory().getObvGroupV2() != null) {
            new GroupV2UpsertNotificationHandler(obvDialog.getCategory().getObvGroupV2(), false, false, false, true).run();
        }
        boolean bl = updateSuccess = DbManager.getInstance().getInvitationDao().updateStateDataTimestampAndSas((Id<Invitation>)existingInvitation.getItemId(), State2, obvDialog.getEncodedElements().getBytes(), System.currentTimeMillis(), obvDialog.getCategory().getSasToDisplay()) == 1;
        if (!updateSuccess) {
            throw new SQLException("Cannot update invitation");
        }
        this.logger.debug("InvitationNotificationListener: contact invitation successfully updated invitation");
    }

    private void createContactInvitation(InvitationGenerated.State State2, ObvDialog obvDialog, OwnedIdentity ownedIdentity, long creationTimestamp) throws Exception {
        Optional<JsonIdentityDetails> jsonIdentityDetails = this.extractJsonIdentityDetailsForContactInvitation(State2, obvDialog);
        Invitation newInvitation = Invitation.createEmptyInvitation(State2, obvDialog.getUuid(), ownedIdentity, obvDialog.getEncodedElements().getBytes(), creationTimestamp);
        if (State2 == InvitationGenerated.State.INTRODUCTION_WAIT_IT_TO_ACCEPT || State2 == InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT) {
            Contact mediatorContact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)ownedIdentity.getItemId(), obvDialog.getCategory().getBytesMediatorOrGroupOwnerIdentity());
            ContactRef mediatorRef = mediatorContact != null ? DbManager.getInstance().getContactRefDao().getOrCreateContactRef(mediatorContact) : DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, obvDialog.getCategory().getBytesMediatorOrGroupOwnerIdentity());
            newInvitation.setMediatorRef(Optional.of(mediatorRef));
        }
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, obvDialog.getCategory().getBytesContactIdentity());
        PreContact preContact = DbManager.getInstance().getPreContactDao().get(contactRef);
        Optional<Id<Contact>> contactIdOpt = contactRef.getContactId();
        Optional<Contact> contactOpt = contactIdOpt.map(id -> (Contact)DbManager.getInstance().getContactDao().get(id));
        if (contactOpt.isPresent() && contactOpt.get().isCollected() && preContact == null) {
            IdentityDetails identityDetailsProxy = new IdentityDetails(contactOpt.get().getIdentityDetailsId().getId());
            preContact = new PreContact(contactRef, identityDetailsProxy);
            preContact = DbManager.getInstance().getPreContactDao().createIfNotExists(preContact);
            if (preContact == null) {
                throw new SQLException("Cannot insert preContact");
            }
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(preContact));
        } else if (preContact != null) {
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(preContact));
        } else if (contactOpt.isPresent()) {
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(contactOpt.get()));
        } else {
            if (jsonIdentityDetails.isEmpty()) {
                throw new SQLException("Undetermined identity details for new pre contact");
            }
            IdentityDetails identityDetails = new IdentityDetails(jsonIdentityDetails.get());
            identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
            if (identityDetails == null) {
                throw new SQLException("Cannot insert pre-contact identity details");
            }
            preContact = new PreContact(contactRef, identityDetails);
            preContact = DbManager.getInstance().getPreContactDao().createIfNotExists(preContact);
            if (preContact == null) {
                throw new SQLException("Cannot insert preContact");
            }
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReuseOneToOneDiscussionDbTask(preContact));
        }
        newInvitation = DbManager.getInstance().getInvitationDao().createIfNotExists(newInvitation);
        if (newInvitation == null) {
            throw new SQLException("Cannot insert invitation");
        }
        NotificationCenter.getInstance().post(newInvitation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createGroupInvitation(InvitationGenerated.State State2, ObvDialog obvDialog, OwnedIdentity ownedIdentity, long creationTimestamp) throws Exception {
        Invitation newInvitation = Invitation.createEmptyInvitation(State2, obvDialog.getUuid(), ownedIdentity, obvDialog.getEncodedElements().getBytes(), creationTimestamp);
        boolean isV1 = obvDialog.getCategory().getObvGroupV2() == null;
        ObvGroupV2 obvGroupV2 = obvDialog.getCategory().getObvGroupV2();
        byte[] groupIdentifier = isV1 ? obvDialog.getCategory().getBytesGroupOwnerAndUid() : obvGroupV2.groupIdentifier.getBytes();
        PreGroup preGroup = DbManager.getInstance().getPreGroupDao().get(ownedIdentity.getBytesOwnedIdentity(), groupIdentifier);
        Group group = DbManager.getInstance().getGroupDao().get(ownedIdentity, groupIdentifier);
        if (group != null) {
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReuseGroupDiscussionDbTask(group));
        } else if (preGroup != null) {
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReusePreGroupDiscussionDbTask(preGroup));
        } else {
            String description;
            String name;
            if (isV1) {
                JsonGroupDetails jsonGroupDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(obvDialog.getCategory().getSerializedGroupDetails(), JsonGroupDetails.class);
                name = jsonGroupDetails.getName();
                description = jsonGroupDetails.getDescription();
            } else {
                JsonGroupDetails groupDetails = (JsonGroupDetails)EngineWrapper.getJsonObjectMapper().readValue(obvDialog.getCategory().getObvGroupV2().detailsAndPhotos.serializedGroupDetails, JsonGroupDetails.class);
                name = groupDetails.getName();
                description = groupDetails.getDescription();
            }
            preGroup = new PreGroup(ownedIdentity, groupIdentifier, name, null, description);
            preGroup = DbManager.getInstance().getPreGroupDao().createIfNotExists(preGroup);
            if (preGroup == null) {
                throw new SQLException("Cannot insert preGroup");
            }
            GroupMemberPermissions ownGroupPermissions = isV1 ? GroupHelper.getV1OwnGroupPermissions(ownedIdentity, preGroup, obvDialog.getCategory().getBytesMediatorOrGroupOwnerIdentity()) : new GroupMemberPermissions(ownedIdentity, null, preGroup, null, null, GroupHelper.getStringsFromObvPermissions(obvDialog.getCategory().getObvGroupV2().ownPermissions));
            ownGroupPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(ownGroupPermissions);
            if (ownGroupPermissions == null) {
                throw new SQLException("Cannot insert preGroup own permissions");
            }
            if (isV1) {
                for (ObvIdentity pendingMemberObvIdentity : obvDialog.getCategory().getPendingGroupMemberIdentities()) {
                    PendingGroupMember pendingGroupMember;
                    ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(ownedIdentity, pendingMemberObvIdentity.getBytesIdentity());
                    if (contactRef.getContactId().isEmpty()) {
                        IdentityDetails identityDetails = new IdentityDetails(pendingMemberObvIdentity.getIdentityDetails());
                        identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
                        if (identityDetails == null) throw new SQLException("InvitationNotificationListener::run Couldn't create identity details");
                        pendingGroupMember = new PendingGroupMember(preGroup, contactRef, identityDetails, identityDetails.computeSortDisplayName(Optional.empty()));
                    } else {
                        Contact contact = DbManager.getInstance().getContactDao().get(contactRef.getContactId().get());
                        IdentityDetails identityDetailsProxy = new IdentityDetails(contact.getIdentityDetailsId().getId());
                        pendingGroupMember = new PendingGroupMember(preGroup, contactRef, identityDetailsProxy, contact.getSortDisplayName());
                    }
                    if ((pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().createIfNotExists(pendingGroupMember)) == null) {
                        throw new SQLException("Cannot insert pending group member");
                    }
                    Set<String> pendingMemberPermissionsSet = Arrays.equals(contactRef.getBytesContactIdentity(), obvDialog.getCategory().getBytesMediatorOrGroupOwnerIdentity()) ? GroupHelper.getDefaultAdminPermissionsAsString() : GroupHelper.getDefaultMemberPermissionsAsString();
                    GroupMemberPermissions pendingMemberPermissions = new GroupMemberPermissions(ownedIdentity, null, null, null, pendingGroupMember, pendingMemberPermissionsSet);
                    pendingMemberPermissions = DbManager.getInstance().getGroupMemberPermissionsDao().createIfNotExists(pendingMemberPermissions);
                    if (pendingMemberPermissions != null) continue;
                    throw new SQLException("Cannot insert pending group member permissions");
                }
            } else {
                new GroupV2UpsertNotificationHandler(obvDialog.getCategory().getObvGroupV2(), false, false, false, true).run();
            }
            newInvitation.setDiscussion(DiscussionCreationHelper.createOrReusePreGroupDiscussionDbTask(preGroup));
            newInvitation = DbManager.getInstance().getInvitationDao().createIfNotExists(newInvitation);
            if (newInvitation == null) {
                throw new SQLException("Cannot insert invitation");
            }
        }
        NotificationCenter.getInstance().post(newInvitation);
    }

    private void uiDialogDeleted(HashMap<String, Object> userInfo) {
        UUID dialogUuid = (UUID)userInfo.get("uuid");
        Invitation invitationToDelete = DbManager.getInstance().getInvitationDao().getInvitationByDialogUUID(dialogUuid);
        if (invitationToDelete == null) {
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                Discussion discussion = invitationToDelete.getDiscussion();
                boolean lastDiscussionInvitation = DbManager.getInstance().getInvitationDao().getInvitationCountForDiscussion(discussion) <= 1L;
                Optional<Long> messageCount = MessageHelper.countUserMessagesInDiscussion(discussion);
                boolean discussionIsEmpty = messageCount.filter(aLong -> aLong <= 0L).isPresent();
                if (discussion.isPreDiscussion() && discussionIsEmpty && lastDiscussionInvitation && invitationToDelete.getState() != InvitationGenerated.State.GROUP_V2_INVITATION_ACCEPTED) {
                    DbManager.getInstance().getDiscussionDao().delete(discussion);
                } else if (discussion.isPreDiscussion() && !discussionIsEmpty && lastDiscussionInvitation && invitationToDelete.getState() != InvitationGenerated.State.GROUP_V2_INVITATION_ACCEPTED) {
                    if (discussion.getPreGroupId().isPresent()) {
                        DbManager.getInstance().getPreGroupDao().deleteById(discussion.getPreGroupId().get());
                    }
                    DiscussionApi.lockDiscussion(discussion);
                    if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                        throw new SQLException("Cannot lock discussion");
                    }
                }
                if (discussion.isPreDiscussion() && lastDiscussionInvitation) {
                    if (discussion.getPreContactId().isPresent()) {
                        DbManager.getInstance().getPreContactDao().deleteWithIdentityDetails(discussion.getPreContactId().get());
                    } else if (discussion.getPreGroupId().isPresent()) {
                        DbManager.getInstance().getPreGroupDao().deleteById(discussion.getPreGroupId().get());
                    }
                }
                DbManager.getInstance().getInvitationDao().delete(invitationToDelete);
                return null;
            });
        }
        catch (SQLException throwables) {
            this.logger.error("InvitationNotificationListener: uiDialogDeleted: exception in transaction", throwables);
        }
    }

    private static InvitationGenerated.State getState(ObvDialog.Category obvDialogCategory) {
        switch (obvDialogCategory.getId()) {
            case 0: {
                return InvitationGenerated.State.INVITATION_WAIT_IT_TO_ACCEPT;
            }
            case 1: {
                return InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT;
            }
            case 2: {
                return InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE;
            }
            case 3: {
                return InvitationGenerated.State.INVITATION_WAIT_IT_FOR_SAS_EXCHANGE;
            }
            case 5: {
                return InvitationGenerated.State.INVITATION_STATUS_IN_PROGRESS;
            }
            case 6: {
                return InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT;
            }
            case 7: {
                return InvitationGenerated.State.INTRODUCTION_WAIT_IT_TO_ACCEPT;
            }
            case 8: {
                return InvitationGenerated.State.GROUP_V1_INVITATION_WAIT_YOU_TO_ACCEPT;
            }
            case 13: {
                return InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_IT_TO_ACCEPT;
            }
            case 14: {
                return InvitationGenerated.State.ONE_TO_ONE_INVITATION_WAIT_YOU_TO_ACCEPT;
            }
            case 15: {
                return InvitationGenerated.State.GROUP_V2_INVITATION_WAIT_YOU_TO_ACCEPT;
            }
            case 16: {
                return InvitationGenerated.State.GROUP_V2_INVITATION_FROZEN;
            }
        }
        return null;
    }
}

