/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.Logger;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.windows.messenger.database.dao.attachment.ReceivedAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.datatypes.fyle.JsonMetadata;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.files.SizeAndSha256;
import io.olvid.windows.messenger.engine.helpers.message.ReturnReceiptStatus;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.engine.notifications.MessageNotificationListener;
import io.olvid.windows.messenger.fx.helpers.JsonHelper;
import io.olvid.windows.messenger.livedata.cache.AttachmentProgressCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AttachmentNotificationListener
extends AbstractNotificationListener {
    static final String[] notificationsToSubscribe = new String[]{"engine_notification_download_attachment_progress", "engine_notification_attachment_downloaded", "engine_notification_upload_attachment_progress", "engine_notification_attachment_uploaded", "engine_notification_attachment_upload_cancelled", "engine_notification_attachment_failed"};

    AttachmentNotificationListener(Engine engine) {
        super(engine, notificationsToSubscribe);
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        this.logger.debug("AttachmentNotificationListener received: " + notificationName);
        try {
            switch (notificationName) {
                case "engine_notification_download_attachment_progress": {
                    this.attachmentDownloadProgress(userInfo);
                    break;
                }
                case "engine_notification_attachment_downloaded": {
                    this.attachmentDownloaded(userInfo);
                    break;
                }
                case "engine_notification_upload_attachment_progress": {
                    this.attachmentUploadProgress(userInfo);
                    break;
                }
                case "engine_notification_attachment_uploaded": {
                    this.attachmentUploaded(userInfo);
                    break;
                }
                case "engine_notification_attachment_upload_cancelled": {
                    this.attachmentUploadCancelled(userInfo);
                    break;
                }
                case "engine_notification_attachment_failed": {
                    this.attachmentDownloadFailed(userInfo);
                    break;
                }
                default: {
                    this.logger.error("AttachmentNotificationListener: unable to handle: " + notificationName);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("AttachmentNotificationListener::callback: Something went wrong handling notification " + notificationName, e);
        }
    }

    private void attachmentDownloadProgress(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] messageIdentifier = (byte[])userInfo.get("message_identifier");
        int attachmentNumber = (Integer)userInfo.get("attachment_number");
        float progress = ((Float)userInfo.get("progress")).floatValue();
        AttachmentProgressCache.getInstance().updateDownloading(bytesOwnedIdentity, messageIdentifier, attachmentNumber, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Message extends ReceivedMessageGenerated<Message>, MessageDao extends ReceivedMessageDao<Message, ?, ?>, Attachment extends ReceivedAttachmentGenerated<Attachment>, AttachmentDao extends ReceivedAttachmentDao<Message, Attachment>> boolean attachmentDownloaded(MessageDao messageDao, AttachmentDao attachmentDao, JsonMetadata jsonMetadata, ObvAttachment downloadedObvAttachment) throws Exception {
        Attachment attachment = attachmentDao.getByEngineIdentifierAndNumber(downloadedObvAttachment.getBytesOwnedIdentity(), downloadedObvAttachment.getMessageIdentifier(), downloadedObvAttachment.getNumber());
        if (attachment == null) {
            return false;
        }
        AttachmentProgressCache.getInstance().doneDownloading(((AbstractTableGenerated)attachment).getItemId());
        Fyle fyle = DbManager.getInstance().getFyleDao().get(((AbstractAttachmentGenerated)attachment).getFyleId());
        byte[] sha256 = jsonMetadata.getSha256();
        String lockKey = Logger.toHexString((byte[])sha256);
        FileApi._acquireLock(lockKey);
        try {
            SizeAndSha256 sizeAndSha256 = FileApi._computeSHA256FromEncryptedFile(downloadedObvAttachment.getUrl());
            Id messageId = attachmentDao.getMessageId(attachment);
            ReceivedMessageDao receivedMessageDao = DbManager.getInstance().getReceivedMessageDao(messageId);
            ReceivedMessageGenerated message = (ReceivedMessageGenerated)receivedMessageDao.get(messageId);
            if (sizeAndSha256 == null || !Arrays.equals(sha256, sizeAndSha256.sha256)) {
                new DeleteAttachmentsDbTask((ReceivedAttachmentGenerated<?>)attachment).run();
            } else {
                Fyle existingFyle = DbManager.getInstance().getFyleDao().getFromHash(sha256);
                if (existingFyle == null) {
                    fyle.setSha256(Optional.of(sha256));
                    fyle.moveToFyleDirectory(downloadedObvAttachment.getUrl());
                    DbManager.getInstance().getFyleDao().updateFylePathAndHash(fyle, fyle.getFilePath(), sha256);
                } else {
                    ((AbstractAttachmentGenerated)attachment).setFyle(existingFyle);
                    attachmentDao.update(attachment);
                    DbManager.getInstance().getFyleDao().delete(fyle);
                }
                attachmentDao.setAttachmentCompleted(attachment);
                Api.getMessageApi().sendAttachmentReturnReceipt(message, ReturnReceiptStatus.DELIVERED, downloadedObvAttachment.getNumber());
            }
            if (message != null) {
                Api.getMessageApi().updateAttachmentCountsAndLinkPreviewInfo(message, messageDao, attachmentDao);
            }
        }
        finally {
            FileApi._releaseLock(lockKey);
        }
        return true;
    }

    private void attachmentDownloaded(HashMap<String, Object> userInfo) throws Exception {
        ObvAttachment downloadedObvAttachment = (ObvAttachment)userInfo.get("attachment");
        if (downloadedObvAttachment == null) {
            this.logger.error("attachmentDownloaded: downloadedObvAttachment is null in userInfo");
            return;
        }
        JsonMetadata jsonMetadata = JsonHelper.bytesToJsonMetadata(downloadedObvAttachment.getMetadata());
        if (jsonMetadata == null) {
            this.logger.error("attachmentDownloaded: jsonMetadata is null in downloadedObvAttachment");
            return;
        }
        try {
            boolean succeeded = this.attachmentDownloaded(DbManager.getInstance().getInboundMessageDao(), DbManager.getInstance().getInboundAttachmentDao(), jsonMetadata, downloadedObvAttachment);
            if (!succeeded) {
                this.attachmentDownloaded(DbManager.getInstance().getOwnedMessageDao(), DbManager.getInstance().getOwnedAttachmentDao(), jsonMetadata, downloadedObvAttachment);
            }
            Api.getAttachmentApi().markAttachmentForDeletion(downloadedObvAttachment);
        }
        catch (Exception e) {
            this.logger.error("attachmentDownloaded: unhandled exception", e);
            throw new Exception("attachmentDownloaded: unhandled exception");
        }
    }

    private void attachmentUploadProgress(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("message_identifier");
        int engineNumber = (Integer)userInfo.get("attachment_number");
        float progress = ((Float)userInfo.get("progress")).floatValue();
        float speed = ((Float)userInfo.getOrDefault("speed", Float.valueOf(0.0f))).floatValue();
        Integer eta = userInfo.getOrDefault("eta", null);
        if (engineMessageIdentifier == null) {
            return;
        }
        AttachmentProgressCache.getInstance().updateUploading(bytesOwnedIdentity, engineMessageIdentifier, engineNumber, progress, speed, Optional.ofNullable(eta));
    }

    private void attachmentUploaded(HashMap<String, Object> userInfo) throws Exception {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("message_identifier");
        int engineNumber = (Integer)userInfo.get("attachment_number");
        try {
            if (engineMessageIdentifier != null) {
                TransactionWrapper.startStatementTransaction(() -> {
                    List<AttachmentRecipientInfo> attachmentRecipientInfos = DbManager.getInstance().getAttachmentRecipientInfoDao().getFromIndexAndMessageIdentifier(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
                    Id<OutboundAttachment> attachmentId = null;
                    for (AttachmentRecipientInfo attachmentRecipientInfo : attachmentRecipientInfos) {
                        MessageNotificationListener.updateAttachmentRecipientInfoTimestampSent(attachmentRecipientInfo, System.currentTimeMillis());
                        if (attachmentId == null) {
                            attachmentId = attachmentRecipientInfo.getAttachmentId();
                        } else if (!Objects.equals(attachmentId, attachmentRecipientInfo.getAttachmentId())) {
                            throw new Exception("attachmentUploaded: unexpected attachment found for the AttachmentRecipientInfo " + String.valueOf(attachmentRecipientInfo.getItemId()));
                        }
                        DbManager.getInstance().getAttachmentRecipientInfoDao().update(attachmentRecipientInfo);
                    }
                    if (attachmentId == null) {
                        return null;
                    }
                    OutboundAttachment outboundAttachment = (OutboundAttachment)DbManager.getInstance().getOutboundAttachmentDao().get(attachmentId);
                    if (outboundAttachment != null && AttachmentUtils.refreshStatus(outboundAttachment)) {
                        DbManager.getInstance().getOutboundAttachmentDao().updateStatus((Id<OutboundAttachment>)outboundAttachment.getItemId(), outboundAttachment.getStatus());
                    }
                    AttachmentProgressCache.getInstance().doneUploading(attachmentId, engineMessageIdentifier);
                    return null;
                });
            }
        }
        catch (SQLException throwables) {
            this.logger.error("attachmentUploaded: unable to complete transaction", throwables);
            throw new Exception("attachmentUploaded: unable to complete transaction");
        }
    }

    private void attachmentUploadCancelled(HashMap<String, Object> userInfo) throws Exception {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("message_identifier");
        int engineNumber = (Integer)userInfo.get("attachment_number");
        if (engineMessageIdentifier != null) {
            try {
                TransactionWrapper.startStatementTransaction(() -> {
                    List<AttachmentRecipientInfo> attachmentRecipientInfos = DbManager.getInstance().getAttachmentRecipientInfoDao().getFromIndexAndMessageIdentifier(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
                    if (attachmentRecipientInfos.isEmpty()) {
                        AppLogger.e("attachmentUploaded: Cannot find any AttachmentRecipientInfo to update");
                        return null;
                    }
                    Set<Id<AttachmentRecipientInfo>> infoToUpdate = attachmentRecipientInfos.stream().map(AbstractTableGenerated::getItemId).collect(Collectors.toSet());
                    if (DbManager.getInstance().getAttachmentRecipientInfoDao().updateRecipientInfoForCancelledAttachment(infoToUpdate, System.currentTimeMillis()) != attachmentRecipientInfos.size()) {
                        throw new Exception("attachmentUploaded: unable to completely update attachment recipient info");
                    }
                    AttachmentProgressCache.getInstance().doneUploading(attachmentRecipientInfos.iterator().next().getAttachmentId(), engineMessageIdentifier);
                    Id<OutboundAttachment> attachmentId = attachmentRecipientInfos.iterator().next().getAttachmentId();
                    for (AttachmentRecipientInfo attachmentRecipientInfo : attachmentRecipientInfos) {
                        if (Objects.equals(attachmentRecipientInfo.getAttachmentId(), attachmentId)) continue;
                        throw new Exception("attachmentUploaded: unexpected attachment found for the AttachmentRecipientInfo " + String.valueOf(attachmentRecipientInfo.getItemId()));
                    }
                    DbManager.getInstance().getOutboundAttachmentDao().updateStatus(attachmentId, OutboundAttachmentGenerated.Status.CANCELLED);
                    return null;
                });
            }
            catch (SQLException e) {
                this.logger.error("attachmentUploadCanceled: unable to complete transaction");
                throw new Exception("attachmentUploadCanceled: unable to complete transaction");
            }
        }
    }

    private void attachmentDownloadFailed(HashMap<String, Object> userInfo) {
        byte[] bytesOwnedIdentity = (byte[])userInfo.get("bytes_owned_identity");
        byte[] engineMessageIdentifier = (byte[])userInfo.get("message_identifier");
        Integer engineNumber = (Integer)userInfo.get("attachment_number");
        if (engineMessageIdentifier == null || engineNumber == null) {
            return;
        }
        AttachmentProgressCache.getInstance().doneDownloading(bytesOwnedIdentity, engineMessageIdentifier, engineNumber);
    }
}

