/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.notifications;

import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.EngineNotificationListener;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.HashMap;

public abstract class AbstractNotificationListener
implements EngineNotificationListener {
    private Long registrationNumber;
    protected AppLogger logger;

    public AbstractNotificationListener(Engine engine, String[] notificationsToSubscribe) {
        for (String notificationName : notificationsToSubscribe) {
            engine.addNotificationListener(notificationName, (EngineNotificationListener)this);
        }
        this.logger = new AppLogger(this.getClass());
    }

    public abstract void callback(String var1, HashMap<String, Object> var2);

    public void setEngineNotificationListenerRegistrationNumber(long registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public long getEngineNotificationListenerRegistrationNumber() {
        return this.registrationNumber;
    }

    public boolean hasEngineNotificationListenerRegistrationNumber() {
        return this.registrationNumber != null;
    }

    protected void unRegisterListener(String[] notificationNames) {
        for (String notification : notificationNames) {
            EngineWrapper.getInstance().removeNotificationListener(notification, this);
        }
    }

    protected void registerListener(String[] notificationNames) {
        for (String notification : notificationNames) {
            EngineWrapper.getInstance().addNotificationListener(notification, this);
        }
    }
}

