/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.manager;

import io.olvid.engine.engine.types.ObvBackupKeyInformation;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.notifications.AbstractNotificationListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;

public final class BackupManager
extends AbstractNotificationListener {
    private static final BackupManager instance = new BackupManager();
    private Optional<Delegate> delegate = Optional.empty();
    private final MutableLiveData<Optional<ObvBackupKeyInformation>> keyInformationLiveData = new MutableLiveData();

    public static BackupManager getInstance() {
        return instance;
    }

    public void setDelegate(Delegate delegate) {
        this.delegate = Optional.of(delegate);
        this.keyInformationLiveData.postValue(Api.getBackupApi().getBackupKeyInformation());
    }

    public MutableLiveData<Optional<ObvBackupKeyInformation>> getKeyInformationLiveData() {
        return this.keyInformationLiveData;
    }

    private BackupManager() {
        super(EngineWrapper.getInstance().getEngineInstance(), BackupNotification.notifications());
    }

    @Override
    public void callback(String notificationName, HashMap<String, Object> userInfo) {
        Optional<BackupNotification> notificationOpt = BackupNotification.of(notificationName);
        if (notificationOpt.isEmpty()) {
            this.logger.error("BackupManager::get callback from unknown notification" + notificationName);
            return;
        }
        BackupNotification notification = notificationOpt.get();
        switch (notification.ordinal()) {
            case 0: {
                String backupSeed = (String)userInfo.get("seed");
                this.delegate.ifPresent(d -> {
                    d.newBackupSeed(backupSeed);
                    this.keyInformationLiveData.postValue(Api.getBackupApi().getBackupKeyInformation());
                });
                break;
            }
            case 1: {
                this.keyInformationLiveData.postValue(Api.getBackupApi().getBackupKeyInformation());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                byte[] backupKeyUid = (byte[])userInfo.get("backup_key_uid");
                Integer version = (Integer)userInfo.get("version");
                byte[] encryptedContent = (byte[])userInfo.get("encrypted_content");
                if (backupKeyUid == null || version == null || encryptedContent == null) {
                    return;
                }
                this.delegate.ifPresent(d -> d.newBackup(encryptedContent, backupKeyUid, version));
                this.keyInformationLiveData.postValue(Api.getBackupApi().getBackupKeyInformation());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                byte[] backupKeyUid = (byte[])userInfo.get("bytes_backup_key_uid");
                Integer version = (Integer)userInfo.get("version");
                if (backupKeyUid == null || version == null) break;
                Api.getBackupApi().appBackupSuccess(backupKeyUid, version, null);
            }
        }
    }

    static enum BackupNotification {
        NEW_BACKUP_SEED_GENERATED("engine_notification_new_backup_seed_generated"),
        BACKUP_KEY_VERIFICATION_SUCCESSFUL("engine_notification_backup_key_verification_successful"),
        BACKUP_SEED_GENERATION_FAILED("engine_notification_backup_seed_generation_failed"),
        BACKUP_FOR_EXPORT_FINISHED("engine_notification_backup_for_export_finished"),
        BACKUP_FOR_EXPORT_FAILED("engine_notification_backup_for_export_failed"),
        APP_BACKUP_REQUESTED("engine_notification_app_backup_requested");

        public final String notificationName;

        private BackupNotification(String name) {
            this.notificationName = name;
        }

        public String getNotificationName() {
            return this.notificationName;
        }

        static String[] notifications() {
            return (String[])Arrays.stream(BackupNotification.values()).map(BackupNotification::getNotificationName).toArray(String[]::new);
        }

        static Optional<BackupNotification> of(String name) {
            return Arrays.stream(BackupNotification.values()).filter(n -> n.notificationName.equals(name)).findFirst();
        }
    }

    public static interface Delegate {
        public void newBackupSeed(String var1);

        public void newBackup(byte[] var1, byte[] var2, Integer var3);
    }
}

