/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.standalone_interfaces;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import java.util.Optional;

public class AppSettingsHelper {
    public static boolean needToSendReadReceiptsInDiscussionDbTask(Id<Discussion> discussionGenId) {
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization(discussionGenId);
        boolean sendReadReceiptConfigured = false;
        if (discussionCustomization != null) {
            sendReadReceiptConfigured = discussionCustomization.getPrefSendReadReceipt().orElse(false);
        }
        return sendReadReceiptConfigured |= DbManager.getInstance().getApplicationSettingsDao().getSendReadReceiptSetting();
    }

    public static void updateMuteDuration(MuteDuration muteDuration) {
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP, muteDuration.toStringValue());
    }

    public static Timestamp getMuteNotificationsTimestamp() {
        String rawValue = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.MUTE_NOTIFICATION_TIMESTAMP);
        if (rawValue == null) {
            return new Timestamp(Timestamp.Kind.NONE, null);
        }
        try {
            long value = Long.parseLong(rawValue);
            if (value == -1L) {
                return new Timestamp(Timestamp.Kind.UNLIMITED, value);
            }
            return new Timestamp(Timestamp.Kind.LIMITED, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Timestamp(Timestamp.Kind.NONE, null);
        }
    }

    public record Timestamp(Kind kind, Long timestamp) {
        public Optional<Long> getLimitedTimestamp() {
            return Optional.ofNullable(this.timestamp);
        }

        public static enum Kind {
            NONE,
            LIMITED,
            UNLIMITED;

        }
    }
}

