/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.owned_identity;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.configuration.EngineConfiguration;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.owned_device.OwnedDevicesSynchronisationWithEngineTask;
import io.olvid.windows.messenger.engine.helpers.owned_identity.DeleteOwnedIdentityAndEverythingRelatedToItDbTask;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DeviceUtils;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class OwnedIdentityApi {
    private static JsonIdentityDetails createJsonIdentityDetails(String firstName, String lastName, String company, String position) {
        JsonIdentityDetails identityToBeCreated = new JsonIdentityDetails();
        identityToBeCreated.setFirstName(firstName);
        identityToBeCreated.setLastName(lastName);
        identityToBeCreated.setCompany(company);
        identityToBeCreated.setPosition(position);
        return identityToBeCreated;
    }

    public static OwnedIdentity createIdentitySync(String serverUrl, @Nullable UUID apiKey, String firstName, String lastName, String company, String position, ObvKeycloakState obvKeycloakState) {
        if (apiKey == null) {
            apiKey = EngineConfiguration.getInstance().getApiKey();
        }
        if (serverUrl == null) {
            serverUrl = EngineConfiguration.getInstance().getServerName();
        }
        AppLogger.d("Server url: " + serverUrl);
        JsonIdentityDetails jsonIdentityDetails = OwnedIdentityApi.createJsonIdentityDetails(firstName, lastName, company, position);
        ObvIdentity createdObvIdentity = EngineWrapper.getInstance().generateOwnedIdentity(serverUrl, jsonIdentityDetails, obvKeycloakState, DeviceUtils.getSystemDeviceName());
        if (createdObvIdentity == null) {
            AppLogger.e("IdentityService: createIdentitySync: engine exception, unable to create identity");
            return null;
        }
        Capabilities capabilities = new Capabilities(false, false, false);
        capabilities = DbManager.getInstance().getCapabilitiesDao().createIfNotExists(capabilities);
        if (capabilities == null) {
            AppLogger.e("IdentityService: createIdentitySync: unable to insert Capabilities in database");
            return null;
        }
        IdentityDetails identityDetails = new IdentityDetails(jsonIdentityDetails);
        identityDetails = DbManager.getInstance().getIdentityDetailsDao().createIfNotExists(identityDetails);
        if (identityDetails == null) {
            AppLogger.e("IdentityService: createIdentitySync: unable to insert IdentityDetails in database");
            return null;
        }
        OwnedIdentity ownedIdentity = new OwnedIdentity(createdObvIdentity, OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN, identityDetails, capabilities);
        ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().createIfNotExists(ownedIdentity);
        if (ownedIdentity == null) {
            AppLogger.e("IdentityService: createIdentitySync: unable to insert OwnedIdentity in database");
            return null;
        }
        EngineWrapper.getInstance().registerToPushNotification(createdObvIdentity.getBytesIdentity(), false, null);
        AsyncTaskExecutor.submitTask(new OwnedDevicesSynchronisationWithEngineTask(ownedIdentity));
        return ownedIdentity;
    }

    public static boolean deleteOwnedIdentity(OwnedIdentity ownedIdentity) {
        try {
            EngineWrapper.getInstance().deleteOwnedIdentity(ownedIdentity.getBytesOwnedIdentity());
            AsyncTaskExecutor.submitTask(new DeleteOwnedIdentityAndEverythingRelatedToItDbTask(ownedIdentity));
            return true;
        }
        catch (Exception e) {
            AppLogger.e("IdentityApi: deleteOwnedIdentity: engine exception", e);
            return false;
        }
    }

    public static boolean deleteOwnedIdentityAndNotifyContacts(OwnedIdentity ownedIdentity, boolean deleteEverywhere) {
        try {
            EngineWrapper.getInstance().deleteOwnedIdentityAndNotifyContacts(ownedIdentity.getBytesOwnedIdentity(), deleteEverywhere);
            AsyncTaskExecutor.submitTask(new DeleteOwnedIdentityAndEverythingRelatedToItDbTask(ownedIdentity));
            return true;
        }
        catch (Exception e) {
            AppLogger.e("IdentityApi: deleteOwnedIdentityAndNotifyContacts: engine exception", e);
            return false;
        }
    }

    public static boolean modifyOwnedIdentityDetails(byte[] bytesOwnedIdentity, JsonIdentityDetails jsonIdentityDetails) {
        try {
            EngineWrapper.getInstance().updateLatestIdentityDetails(bytesOwnedIdentity, jsonIdentityDetails);
            EngineWrapper.getInstance().publishLatestIdentityDetails(bytesOwnedIdentity);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("IdentityService: modifyOwnedIdentityDetails: engine exception", e);
            return false;
        }
    }

    public static boolean modifyOwnedIdentityDetails(byte[] bytesOwnedIdentity, String firstName, String lastName, String company, String position) {
        firstName = StringUtils.ifEmptyThenNull(firstName);
        lastName = StringUtils.ifEmptyThenNull(lastName);
        if (firstName == null && lastName == null) {
            AppLogger.e("IdentityService: createIdentity: firstName and lastName are empty or null, one of them is required");
            return false;
        }
        company = StringUtils.ifEmptyThenNull(company);
        position = StringUtils.ifEmptyThenNull(position);
        JsonIdentityDetails newIdentityDetails = OwnedIdentityApi.createJsonIdentityDetails(firstName, lastName, company, position);
        return OwnedIdentityApi.modifyOwnedIdentityDetails(bytesOwnedIdentity, newIdentityDetails);
    }

    public static boolean removeOwnedIdentityPhoto(byte[] bytesOwnedIdentity) {
        try {
            EngineWrapper.getInstance().updateOwnedIdentityPhoto(bytesOwnedIdentity, null);
            EngineWrapper.getInstance().publishLatestIdentityDetails(bytesOwnedIdentity);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("IdentityService: updateOwnedIdentityPhoto: engine exception", e);
            return false;
        }
    }

    public static void importAndUpdateOwnedIdentityPhoto(byte[] bytesOwnedIdentity, String originalPhotoPath, @Nullable Runnable onSuccess, @Nullable Runnable onFail) {
        if (bytesOwnedIdentity == null || originalPhotoPath == null) {
            AppLogger.e("IdentityService: importAndUpdateOwnedIdentityPhoto: invalid parameter given: ");
            return;
        }
        AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(originalPhotoPath, 1080, 1080, relativePhotoUrl -> {
            try {
                EngineWrapper.getInstance().updateOwnedIdentityPhoto(bytesOwnedIdentity, FileApi.absolutePathFromRelative(relativePhotoUrl));
                EngineWrapper.getInstance().publishLatestIdentityDetails(bytesOwnedIdentity);
            }
            catch (Exception e) {
                AppLogger.e("IdentityService: importAndUpdateOwnedIdentityPhoto: engine exception", e);
            }
            if (onSuccess != null) {
                onSuccess.run();
            }
        }, error -> {
            AppLogger.e("IdentityService: importAndUpdateOwnedIdentityPhoto: task error: " + String.valueOf(error));
            if (onFail != null) {
                onFail.run();
            }
        }));
    }
}

