/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.owned_identity;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteOwnedIdentityAndEverythingRelatedToItDbTask
implements Runnable {
    final OwnedIdentity ownedIdentity;
    private final AppLogger logger = new AppLogger(DeleteOwnedIdentityAndEverythingRelatedToItDbTask.class);

    public DeleteOwnedIdentityAndEverythingRelatedToItDbTask(OwnedIdentity ownedIdentity) {
        this.ownedIdentity = ownedIdentity;
    }

    @Override
    public void run() {
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                List inboundAttachments = DbManager.getInstance().getInboundAttachmentDao().getAttachmentsForOwnedIdentity(this.ownedIdentity);
                List outboundAttachments = DbManager.getInstance().getOutboundAttachmentDao().getAttachmentsForOwnedIdentity(this.ownedIdentity);
                List ownedAttachments = DbManager.getInstance().getOwnedAttachmentDao().getAttachmentsForOwnedIdentity(this.ownedIdentity);
                DbManager.getInstance().getOwnedIdentityDao().delete(this.ownedIdentity);
                DbManager.getInstance().getCapabilitiesDao().deleteById(this.ownedIdentity.getCapabilitiesId());
                DbManager.getInstance().getIdentityDetailsDao().deleteById(this.ownedIdentity.getIdentityDetailsId());
                ArrayList<String> thumbnailPathes = new ArrayList<String>();
                for (InboundAttachment inboundAttachment : inboundAttachments) {
                    if (inboundAttachment.isThumbnailComputationFailed()) continue;
                    thumbnailPathes.add(inboundAttachment.getThumbnailPath());
                }
                for (OutboundAttachment outboundAttachment : outboundAttachments) {
                    if (outboundAttachment.isThumbnailComputationFailed()) continue;
                    thumbnailPathes.add(outboundAttachment.getThumbnailPath());
                }
                for (OwnedAttachment ownedAttachment : ownedAttachments) {
                    if (ownedAttachment.isThumbnailComputationFailed()) continue;
                    thumbnailPathes.add(ownedAttachment.getThumbnailPath());
                }
                FileApi._deleteThumbnailFiles(thumbnailPathes);
                HashSet<Id<Fyle>> fylesSet = new HashSet<Id<Fyle>>(inboundAttachments.size());
                for (InboundAttachment inboundAttachment : inboundAttachments) {
                    fylesSet.add(inboundAttachment.getFyleId());
                }
                for (OutboundAttachment outboundAttachment : outboundAttachments) {
                    fylesSet.add(outboundAttachment.getFyleId());
                }
                for (OwnedAttachment ownedAttachment : ownedAttachments) {
                    fylesSet.add(ownedAttachment.getFyleId());
                }
                FileApi._deleteFylesIfOrphansTask(fylesSet.stream().toList());
                UnreadMessageCountCache.getInstance().identityWasDeleted((Id<OwnedIdentity>)this.ownedIdentity.getItemId());
                return null;
            });
        }
        catch (SQLException e) {
            this.logger.error("Unable to perform deletion", e);
        }
    }
}

