/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageVoteDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.pollMessage.PollMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.pollMessage.PollMessageVoteGenerated;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.engine.helpers.message.MessagePostHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Watches;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;

public class VoteToPollTask
implements Callable<Boolean> {
    private static final String TAG = "VoteToPollTask";
    private final AbstractUserMessageGenerated<?> message;
    private final Discussion discussion;
    private final IdentityRef sender;
    private final PollMessageChoice choice;
    private final long voteTimestamp;
    private final boolean postPollVoteMessageToDiscussionParticipants;

    public VoteToPollTask(AbstractUserMessageGenerated<?> message, Discussion discussion, IdentityRef sender, PollMessageChoice choice, long voteTimestamp, boolean postPollVoteMessageToDiscussionParticipants) {
        this.message = message;
        this.discussion = discussion;
        this.sender = sender;
        this.choice = choice;
        this.voteTimestamp = voteTimestamp;
        this.postPollVoteMessageToDiscussionParticipants = postPollVoteMessageToDiscussionParticipants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        Watches.Watch watch = Watches.getInstance().start("VoteToPollTask.call");
        try {
            Boolean bl = this.execute();
            return bl;
        }
        catch (Exception e) {
            AppLogger.e("VoteToPollTask: unexpected error while processing vote", e);
            Boolean bl = false;
            return bl;
        }
        finally {
            watch.stop();
            Watches.getInstance().printIfIsDevMode();
        }
    }

    private Boolean execute() throws SQLException {
        if (this.choice == null) {
            AppLogger.e("VoteToPollTask: invalid choice (null)");
            return false;
        }
        Optional<Id<PollMessage>> pollMessageIdOpt = this.message.getPollMessageId();
        if (pollMessageIdOpt.isEmpty()) {
            AppLogger.e("VoteToPollTask: message has no pollMessageId, cannot vote");
            return false;
        }
        Id<PollMessage> pollMessageId = pollMessageIdOpt.get();
        PollMessageDao pollDao = DbManager.getInstance().getPollMessageDao();
        PollMessageVoteDao voteDao = DbManager.getInstance().getPollMessageVoteDao();
        Watches.Watch loadPollWatch = Watches.getInstance().start("VoteToPollTask.loadPoll");
        AbstractTableGenerated poll = pollDao.get((Id)pollMessageId);
        loadPollWatch.stop();
        if (poll == null) {
            AppLogger.e("VoteToPollTask: poll not found for pollMessageId=" + String.valueOf(pollMessageId));
            return false;
        }
        Watches.Watch loadVoteWatch = Watches.getInstance().start("VoteToPollTask.loadExistingVote");
        PollMessageVote vote = voteDao.getVoteByPollMessageBySenderByChoice((Id<PollMessage>)poll.getItemId(), (Id<IdentityRef>)this.sender.getItemId(), (Id<PollMessageChoice>)this.choice.getItemId());
        loadVoteWatch.stop();
        boolean isNewVote = false;
        if (vote == null) {
            Optional<PollMessageVote> voteOpt = PollMessageVote.of((PollMessage)poll, this.sender, this.choice, null, this.voteTimestamp, true, 0);
            if (voteOpt.isEmpty()) {
                AppLogger.e("VoteToPollTask: failed to generate new vote");
                return false;
            }
            vote = voteOpt.get();
            isNewVote = true;
            AppLogger.d("VoteToPollTask: creating new vote for pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(this.choice.getItemId()));
        } else {
            boolean previous = vote.isVoted();
            vote.setVoted(!previous);
            AppLogger.d("VoteToPollTask: toggling vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(this.choice.getItemId()) + ", previous=" + previous + ", now=" + vote.isVoted());
        }
        if (!((PollMessageGenerated)poll).isMultipleChoice()) {
            Watches.Watch enforceSingleWatch = Watches.getInstance().start("VoteToPollTask.enforceSingleChoice");
            List<PollMessageVote> allVotes = voteDao.getVotesForMessageBySender((Id<PollMessage>)poll.getItemId(), (Id<IdentityRef>)this.sender.getItemId());
            int maxVersion = allVotes.stream().mapToInt(PollMessageVoteGenerated::getVersion).max().orElse(0);
            int baseVersion = Math.max(vote.getVersion(), maxVersion) + 1;
            vote.setVersion(baseVersion);
            Watches.Watch persistTargetWatch = Watches.getInstance().start("VoteToPollTask.persistTargetVoteSingle");
            if (isNewVote) {
                voteDao.insert(vote);
                isNewVote = false;
            } else {
                voteDao.update(vote);
            }
            persistTargetWatch.stop();
            allVotes = voteDao.getVotesForMessageBySender((Id<PollMessage>)poll.getItemId(), (Id<IdentityRef>)this.sender.getItemId());
            for (PollMessageVote v : allVotes) {
                boolean shouldBeVoted;
                boolean bl = shouldBeVoted = ((Id)v.getItemId()).equals(vote.getItemId()) && vote.isVoted();
                if (v.isVoted() == shouldBeVoted && v.getVersion() == baseVersion) continue;
                v.setVoted(shouldBeVoted);
                v.setVersion(baseVersion);
                v.setTimestamp(this.voteTimestamp);
                voteDao.update(v);
                AppLogger.d("VoteToPollTask: enforcing single-choice. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", voteId=" + String.valueOf(v.getItemId()) + ", voted=" + shouldBeVoted + ", version=" + baseVersion);
            }
            enforceSingleWatch.stop();
        } else {
            if (vote.getVersion() <= 0 && vote.isVoted()) {
                vote.setVersion(1);
            } else if (!isNewVote) {
                vote.setVersion(vote.getVersion() + 1);
            } else {
                vote.setVersion(1);
            }
            vote.setTimestamp(this.voteTimestamp);
            Watches.Watch persistVoteWatch = Watches.getInstance().start("VoteToPollTask.persistVoteMultiple");
            if (isNewVote) {
                voteDao.insert(vote);
            } else {
                voteDao.update(vote);
            }
            persistVoteWatch.stop();
        }
        if (this.postPollVoteMessageToDiscussionParticipants) {
            Watches.Watch postMsgWatch = Watches.getInstance().start("VoteToPollTask.postPollMessageChoice");
            boolean success = MessagePostHelper.postPollMessageChoiceDbTask(this.message, this.discussion, vote);
            postMsgWatch.stop();
            if (!success) {
                AppLogger.e("VoteToPollTask: cannot post poll message choice to discussion participants");
                return false;
            }
        }
        AppLogger.d("VoteToPollTask: vote processed successfully. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(this.choice.getItemId()));
        return true;
    }
}

