/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageChoiceDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageDao;
import io.olvid.windows.messenger.database.dao.pollMessage.PollMessageVoteDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.pollMessage.PollMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.pollMessage.PollMessageVoteGenerated;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessage;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageChoice;
import io.olvid.windows.messenger.database.tables.pollMessage.PollMessageVote;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Watches;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;

public class UpdatePollVotesTask
implements Callable<Boolean> {
    private static final String TAG = "UpdatePollVotesTask";
    private final AbstractUserMessageGenerated<?> message;
    private final Discussion discussion;
    private final UUID pollCandidateUuid;
    private final IdentityRef sender;
    private final long pollVoteTimestamp;
    private final boolean voted;
    private final int version;

    public UpdatePollVotesTask(AbstractUserMessageGenerated<?> message, Discussion discussion, UUID pollCandidateUuid, Id<IdentityRef> senderId, long pollVoteTimestamp, boolean voted, int version) {
        this.message = message;
        this.discussion = discussion;
        this.pollCandidateUuid = pollCandidateUuid;
        this.sender = DbManager.getInstance().getIdentityRefDao().get(senderId);
        this.pollVoteTimestamp = pollVoteTimestamp;
        this.voted = voted;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        Watches.Watch watch = Watches.getInstance().start("UpdatePollVotesTask.call");
        try {
            Boolean bl = this.execute();
            return bl;
        }
        catch (Exception e) {
            AppLogger.e("UpdatePollVotesTask: unexpected error while updating poll votes", e);
            Boolean bl = false;
            return bl;
        }
        finally {
            watch.stop();
            Watches.getInstance().printIfIsDevMode();
        }
    }

    private Boolean execute() throws SQLException {
        if (this.pollCandidateUuid == null) {
            AppLogger.e("UpdatePollVotesTask: pollCandidateUuid is null");
            return false;
        }
        if (this.sender == null) {
            AppLogger.e("UpdatePollVotesTask: sender is null");
            return false;
        }
        if (this.message.getPollMessageId().isEmpty()) {
            AppLogger.e("UpdatePollVotesTask: message does not have a pollMessageId");
            return false;
        }
        Id<PollMessage> pollMessageId = this.message.getPollMessageId().get();
        PollMessageDao pollDao = DbManager.getInstance().getPollMessageDao();
        PollMessageChoiceDao choiceDao = DbManager.getInstance().getPollMessageOptionDao();
        PollMessageVoteDao voteDao = DbManager.getInstance().getPollMessageVoteDao();
        Watches.Watch loadPollWatch = Watches.getInstance().start("UpdatePollVotesTask.loadPoll");
        AbstractTableGenerated poll = pollDao.get((Id)pollMessageId);
        loadPollWatch.stop();
        if (poll == null) {
            AppLogger.e("UpdatePollVotesTask: poll not found for pollMessageId=" + String.valueOf(pollMessageId));
            return false;
        }
        Watches.Watch loadOptionWatch = Watches.getInstance().start("UpdatePollVotesTask.loadOption");
        Optional<PollMessageChoice> optionOpt = choiceDao.getByExternalIdentifier(this.pollCandidateUuid, (Id<PollMessage>)poll.getItemId());
        loadOptionWatch.stop();
        if (optionOpt.isEmpty()) {
            AppLogger.e("UpdatePollVotesTask: option not found in DB for pollId=" + String.valueOf(poll.getItemId()) + ", candidateUuid=" + String.valueOf(this.pollCandidateUuid));
            return false;
        }
        PollMessageChoice option = optionOpt.get();
        Watches.Watch loadVotesWatch = Watches.getInstance().start("UpdatePollVotesTask.loadVotesForSender");
        List<PollMessageVote> votes = voteDao.getVotesForMessageBySender((Id<PollMessage>)poll.getItemId(), (Id<IdentityRef>)this.sender.getItemId());
        loadVotesWatch.stop();
        Optional<PollMessageVote> sameVoteOpt = votes.stream().filter(arg_0 -> UpdatePollVotesTask.lambda$execute$1(option, (PollMessage)poll, arg_0)).findFirst();
        if (((PollMessageGenerated)poll).isMultipleChoice()) {
            Watches.Watch multipleWatch = Watches.getInstance().start("UpdatePollVotesTask.handleMultipleChoice");
            this.handleMultipleChoice((PollMessage)poll, option, votes, sameVoteOpt, voteDao);
            multipleWatch.stop();
        } else {
            Watches.Watch singleWatch = Watches.getInstance().start("UpdatePollVotesTask.handleSingleChoice");
            this.handleSingleChoice((PollMessage)poll, option, votes, sameVoteOpt, voteDao);
            singleWatch.stop();
        }
        AppLogger.d("UpdatePollVotesTask: poll votes updated successfully. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", candidateUuid=" + String.valueOf(this.pollCandidateUuid) + ", voted=" + this.voted + ", version=" + this.version);
        return true;
    }

    private void handleMultipleChoice(PollMessage poll, PollMessageChoice option, List<PollMessageVote> votes, Optional<PollMessageVote> sameVoteOpt, PollMessageVoteDao voteDao) {
        if (sameVoteOpt.isPresent()) {
            PollMessageVote existingVote = sameVoteOpt.get();
            boolean previous = existingVote.isVoted();
            existingVote.setVoted(this.voted);
            existingVote.setTimestamp(this.pollVoteTimestamp);
            existingVote.setVersion(this.version);
            voteDao.update(existingVote);
            AppLogger.d("UpdatePollVotesTask: updated existing multiple-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()) + ", previous=" + previous + ", now=" + this.voted);
        } else {
            Optional<PollMessageVote> newVoteOpt = PollMessageVote.of(poll, this.sender, option, null, this.pollVoteTimestamp, this.voted, this.version);
            if (newVoteOpt.isEmpty()) {
                AppLogger.e("UpdatePollVotesTask: failed to create new multiple-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()));
                return;
            }
            PollMessageVote newVote = newVoteOpt.get();
            try {
                voteDao.create(newVote);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            AppLogger.d("UpdatePollVotesTask: created new multiple-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()) + ", voted=" + this.voted);
        }
    }

    private void handleSingleChoice(PollMessage poll, PollMessageChoice option, List<PollMessageVote> votes, Optional<PollMessageVote> sameVoteOpt, PollMessageVoteDao voteDao) {
        int maxExistingVersion = votes.stream().mapToInt(PollMessageVoteGenerated::getVersion).max().orElse(0);
        int effectiveVersion = Math.max(this.version, maxExistingVersion + 1);
        if (sameVoteOpt.isPresent() && votes.size() == 1) {
            PollMessageVote existingVote = sameVoteOpt.get();
            boolean previous = existingVote.isVoted();
            existingVote.setVoted(this.voted);
            existingVote.setTimestamp(this.pollVoteTimestamp);
            existingVote.setVersion(effectiveVersion);
            voteDao.update(existingVote);
            AppLogger.d("UpdatePollVotesTask: updated single-choice vote (simple case). pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()) + ", previous=" + previous + ", now=" + this.voted + ", version=" + effectiveVersion);
            return;
        }
        for (PollMessageVote vote : votes) {
            if (!vote.isVoted() || vote == sameVoteOpt.orElse(null)) continue;
            vote.setVoted(false);
            vote.setTimestamp(this.pollVoteTimestamp);
            vote.setVersion(effectiveVersion);
            voteDao.update(vote);
            AppLogger.d("UpdatePollVotesTask: reset other single-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", voteId=" + String.valueOf(vote.getItemId()) + ", version=" + effectiveVersion);
        }
        if (sameVoteOpt.isPresent()) {
            PollMessageVote existingVote = sameVoteOpt.get();
            existingVote.setVoted(this.voted);
            existingVote.setTimestamp(this.pollVoteTimestamp);
            existingVote.setVersion(effectiveVersion);
            voteDao.update(existingVote);
            AppLogger.d("UpdatePollVotesTask: set single-choice vote on existing entry. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()) + ", version=" + effectiveVersion);
        } else {
            Optional<PollMessageVote> newVoteOpt = PollMessageVote.of(poll, this.sender, option, null, this.pollVoteTimestamp, true, effectiveVersion);
            if (newVoteOpt.isEmpty()) {
                AppLogger.e("UpdatePollVotesTask: failed to create new single-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()));
                return;
            }
            PollMessageVote newVote = newVoteOpt.get();
            try {
                voteDao.create(newVote);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            AppLogger.d("UpdatePollVotesTask: created new single-choice vote. pollId=" + String.valueOf(poll.getItemId()) + ", senderId=" + String.valueOf(this.sender.getItemId()) + ", choiceId=" + String.valueOf(option.getItemId()) + ", version=" + effectiveVersion);
        }
    }

    private static /* synthetic */ boolean lambda$execute$1(PollMessageChoice option, PollMessage poll, PollMessageVote v) {
        return v.getPollMessageChoice().map(choice -> ((Id)choice.getItemId()).equals(option.getItemId()) && choice.getPollMessageId().isPresent() && choice.getPollMessageId().get().equals(poll.getItemId())).orElse(false);
    }
}

