/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.message.tasks;

import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessage;
import io.olvid.windows.messenger.database.datatypes.json.JsonPayload;
import io.olvid.windows.messenger.database.datatypes.json.JsonReturnReceipt;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;

public class PostMessageTask
implements Runnable {
    protected final AppLogger logger = new AppLogger(this.getClass());
    private final Id<OutboundMessage> messageId;

    public PostMessageTask(Id<OutboundMessage> messageId) {
        this.messageId = messageId;
    }

    @Override
    public void run() {
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                this.doRun();
                return null;
            });
        }
        catch (Exception exception) {
            this.logger.error("Unexpected exception", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doRun() throws Exception {
        void var8_15;
        OwnedIdentity ownedIdentity;
        OutboundMessage message = DbManager.getInstance().getOutboundMessageDao().get(this.messageId);
        if (message == null) {
            this.logger.error("Cannot find message in db");
            return;
        }
        Optional<OutboundMessageEphemeralInfo> ephemeralInfo = DbManager.getInstance().getOutboundMessageDao().getEphemeralInfo(message);
        Discussion discussion = DbManager.getInstance().getDiscussionDao().get(message.getDiscussionId());
        PostMessageState postMessageState = new PostMessageState(discussion, message, ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(discussion.getOwnedIdentityId()));
        if (postMessageState.isRecipientLess()) {
            message.setStatus(OutboundMessageGenerated.Status.NO_CONTACT_RECIPIENTS);
            DbManager.getInstance().getOutboundMessageDao().updateStatus((Id<OutboundMessage>)message.getItemId(), OutboundMessageGenerated.Status.NO_CONTACT_RECIPIENTS);
            if (message.getTotalAttachmentCount() > 0) {
                DbManager.getInstance().getOutboundAttachmentDao().updateStatusForMessage((Id<OutboundMessage>)message.getItemId(), OutboundAttachmentGenerated.Status.NO_CONTACT_RECIPIENTS);
            }
            return;
        }
        if (!discussion.canPostMessage()) {
            this.logger.error("Cannot post a message in this discussion: " + String.valueOf(discussion.getItemId()));
            return;
        }
        List<MessageRecipientInfo> existingMessageRecipientInfo = DbManager.getInstance().getMessageRecipientInfoDao().getAllByMessage((Id<OutboundMessage>)message.getItemId());
        for (MessageRecipientInfo messageRecipientInfo : existingMessageRecipientInfo) {
            postMessageState.update(messageRecipientInfo);
        }
        List<PendingMessage> existingPendingMessages = DbManager.getInstance().getPendingMessageDao().getAllByMessage((Id<OutboundMessage>)message.getItemId());
        for (PendingMessage pendingMessage : existingPendingMessages) {
            postMessageState.update(pendingMessage);
        }
        postMessageState.createPendingMessageIfNecessary();
        Object var8_10 = null;
        Optional<Id<Location>> locationId = message.getLocationId();
        if (locationId.isPresent()) {
            Location location = DbManager.getInstance().getLocationDao().get(locationId.get());
            switch (location.getType()) {
                case SEND: {
                    Long l = DbManager.getInstance().getMessageRecipientInfoDao().getOriginalServerTimestampForMessage(message);
                    break;
                }
                case SHARE: 
                case SHARE_FINISHED: {
                    Long l = location.getTimestamp();
                }
            }
        } else {
            Long l = DbManager.getInstance().getMessageRecipientInfoDao().getOriginalServerTimestampForMessage(message);
        }
        List<byte[]> byteIdentitiesToWhichMessageCanBeSentNow = postMessageState.getRecipientsIdentities();
        if (byteIdentitiesToWhichMessageCanBeSentNow.isEmpty()) {
            return;
        }
        List<OutboundAttachment> outboundAttachments = DbManager.getInstance().getOutboundAttachmentDao().getMessageAttachments((Id<OutboundMessage>)message.getItemId(), EnumSet.of(OutboundAttachmentGenerated.Status.UNPROCESSED));
        ObvOutboundAttachment[] obvOutboundAttachments = new ObvOutboundAttachment[outboundAttachments.size()];
        for (int i = 0; i < obvOutboundAttachments.length; ++i) {
            Fyle fyle = DbManager.getInstance().getFyleDao().get(outboundAttachments.get(i).getFyleId());
            if (fyle == null) {
                this.logger.warning("This should not happen, Fyle null for attachment : " + String.valueOf(outboundAttachments.get(i).getItemId()));
                continue;
            }
            obvOutboundAttachments[i] = new ObvOutboundAttachment(fyle.getFilePath(), outboundAttachments.get(i).getSize(), AttachmentUtils.getMetadata(outboundAttachments.get(i), fyle));
            outboundAttachments.get(i).setIdx(i);
            DbManager.getInstance().getOutboundAttachmentDao().update(outboundAttachments.get(i));
        }
        byte[] returnReceiptNonce = EngineWrapper.getInstance().getReturnReceiptNonce();
        byte[] returnReceiptKey = EngineWrapper.getInstance().getReturnReceiptKey();
        JsonMessage jsonMessage = MessageHelper.getJsonMessage(message);
        ephemeralInfo.ifPresent(messageEphemeralInfo -> jsonMessage.setJsonExpiration(MessageHelper.getJsonExpiration(messageEphemeralInfo)));
        jsonMessage.setIdentifier(discussion);
        jsonMessage.setOriginalServerTimestamp((Long)(var8_15 == null || var8_15.longValue() == 0L ? null : var8_15));
        JsonReturnReceipt jsonReturnReceipt = new JsonReturnReceipt(returnReceiptNonce, returnReceiptKey);
        JsonPayload jsonPayload = new JsonPayload(jsonMessage, jsonReturnReceipt);
        byte[] messagePayload = EngineWrapper.getJsonObjectMapper().writeValueAsBytes((Object)jsonPayload);
        ObvPostMessageOutput postMessageOutput = EngineWrapper.getInstance().post(messagePayload, obvOutboundAttachments, byteIdentitiesToWhichMessageCanBeSentNow, ownedIdentity.getBytesOwnedIdentity(), true, false);
        if (!postMessageOutput.isMessagePostedForAtLeastOneContact()) {
            this.logger.error("Sending failed for all contacts");
            return;
        }
        TransactionWrapper.startStatementTransaction(() -> {
            List<MessageRecipientInfo> messageRecipientInfos = postMessageState.createMessageRecipientInfo(postMessageOutput, returnReceiptNonce, returnReceiptKey);
            Api.getMessageApi().refreshOutboundStatus((Id<OutboundMessage>)message.getItemId());
            for (OutboundAttachment outboundAttachment : outboundAttachments) {
                ArrayList<AttachmentRecipientInfo> attachmentRecipientInfos = new ArrayList<AttachmentRecipientInfo>(outboundAttachments.size());
                for (MessageRecipientInfo messageRecipientInfo : messageRecipientInfos) {
                    AttachmentRecipientInfo attachmentRecipientInfo = new AttachmentRecipientInfo(messageRecipientInfo, outboundAttachment, messageRecipientInfo.getEngineMessageIdentifier(), null, null, null, null);
                    attachmentRecipientInfos.add(attachmentRecipientInfo);
                }
                if (DbManager.getInstance().getAttachmentRecipientInfoDao().create(attachmentRecipientInfos) != attachmentRecipientInfos.size()) {
                    throw new Exception("UserMessagePostHelper.postUnprocessedMessageDbTask: couldn't create all attachmentRecipientInfos....");
                }
                if (!AttachmentUtils.refreshStatus(outboundAttachment, attachmentRecipientInfos)) continue;
                DbManager.getInstance().getOutboundAttachmentDao().updateStatus((Id<OutboundAttachment>)outboundAttachment.getItemId(), outboundAttachment.getStatus());
            }
            postMessageState.deletePendingMessageIfNecessary();
            if (discussion.isHidden()) {
                discussion.setStatus(DiscussionGenerated.Status.NORMAL);
                DbManager.getInstance().getDiscussionDao().updateDiscussionStatus(discussion);
            }
            DbManager.getInstance().getDiscussionDao().updateLastMessageWithTimestampIfNecessary(discussion, message, false);
            return null;
        });
    }

    static class PostMessageState {
        private final OutboundMessage outboundMessage;
        private final Discussion discussion;
        private final OwnedIdentity ownedIdentity;
        private final List<Contact> contacts;
        private final List<PendingGroupMember> pendingGroupMembers;
        boolean shouldBeSentToOwnedOtherDevices;
        private List<PendingMessage> pendingMessagesToDelete = new ArrayList<PendingMessage>();

        PostMessageState(Discussion discussion, OutboundMessage outboundMessage, OwnedIdentity ownedIdentity) {
            this.discussion = discussion;
            this.outboundMessage = outboundMessage;
            this.ownedIdentity = ownedIdentity;
            this.contacts = new ArrayList<Contact>();
            this.pendingGroupMembers = new ArrayList<PendingGroupMember>();
            if (discussion.getContactId().isPresent()) {
                Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
                this.contacts.add(contact);
            } else if (discussion.getGroupId().isPresent()) {
                List<PendingGroupMember> pendingMembers;
                Group group;
                List<Contact> members = DbManager.getInstance().getContactDao().getSortedGroupMembers(discussion.getGroupId().get());
                if (members != null) {
                    this.contacts.addAll(members);
                }
                if ((group = DbManager.getInstance().getGroupDao().get(discussion.getGroupId().get())).isV2() && (pendingMembers = DbManager.getInstance().getPendingGroupMemberDao().getPendingMembers(group)) != null) {
                    this.pendingGroupMembers.addAll(pendingMembers);
                }
            }
            this.shouldBeSentToOwnedOtherDevices = DbManager.getInstance().getOwnedDeviceDao().doesOwnedIdentityHaveAnotherDeviceWithChannel(discussion.getOwnedIdentityId());
        }

        boolean isRecipientLess() {
            return this.contacts.isEmpty() && this.pendingGroupMembers.isEmpty() && !this.shouldBeSentToOwnedOtherDevices;
        }

        void update(MessageRecipientInfo messageRecipientInfo) {
            Id<IdentityRef> recipientRefId = messageRecipientInfo.getRecipientRefId();
            IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().get(recipientRefId);
            Optional<Id<ContactRef>> contactRefIdOpt = identityRef.getContactRefId();
            if (contactRefIdOpt.isEmpty()) {
                this.shouldBeSentToOwnedOtherDevices = false;
            } else {
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(contactRefIdOpt.get());
                byte[] bytesContactIdentity = contactRef.getBytesContactIdentity();
                this.contacts.removeIf(c -> Arrays.equals(c.getBytesContactIdentity(), bytesContactIdentity));
            }
        }

        void update(PendingMessage pendingMessage) {
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(pendingMessage.getContactRefId());
            this.pendingGroupMembers.removeIf(pgm -> Objects.equals(pgm.getContactRefId(), contactRef.getItemId()));
            Optional<Contact> contactOpt = this.contacts.stream().filter(c -> Arrays.equals(c.getBytesContactIdentity(), contactRef.getBytesContactIdentity())).findFirst();
            if (contactOpt.isPresent()) {
                Contact contact = contactOpt.get();
                if (contact.hasChannelOrPrekey()) {
                    this.pendingMessagesToDelete.add(pendingMessage);
                } else {
                    this.contacts.remove(contact);
                }
            }
        }

        void createPendingMessageIfNecessary() throws SQLException {
            ListIterator<Contact> contactIterator = this.contacts.listIterator();
            while (contactIterator.hasNext()) {
                Contact contact = contactIterator.next();
                if (contact.hasChannelOrPrekey()) continue;
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                PendingMessage pendingMessage = new PendingMessage(this.discussion, this.outboundMessage, contactRef);
                if (DbManager.getInstance().getPendingMessageDao().create(List.of(pendingMessage)) == 1) {
                    contactIterator.remove();
                    continue;
                }
                throw new SQLException("UseMessagePostHelper::post couldn't insert pending messages");
            }
            ArrayList<PendingMessage> pendingMessagesToCreate = new ArrayList<PendingMessage>();
            for (PendingGroupMember pendingGroupMember : this.pendingGroupMembers) {
                Id<ContactRef> contactRefId = pendingGroupMember.getContactRefId();
                ContactRef contactRef = new ContactRef(contactRefId.getId());
                PendingMessage pendingMessage = new PendingMessage(this.discussion, this.outboundMessage, contactRef);
                pendingMessagesToCreate.add(pendingMessage);
            }
            if (DbManager.getInstance().getPendingMessageDao().create(pendingMessagesToCreate) != pendingMessagesToCreate.size()) {
                throw new SQLException("UseMessagePostHelper::post couldn't insert pending messages");
            }
            this.pendingGroupMembers.clear();
        }

        List<byte[]> getRecipientsIdentities() {
            ArrayList<byte[]> identities = new ArrayList<byte[]>(this.contacts.stream().map(ContactGenerated::getBytesContactIdentity).toList());
            if (this.shouldBeSentToOwnedOtherDevices) {
                identities.add(this.ownedIdentity.getBytesOwnedIdentity());
            }
            return identities;
        }

        List<MessageRecipientInfo> createMessageRecipientInfo(ObvPostMessageOutput postMessageOutput, byte[] returnReceiptNonce, byte[] returnReceiptKey) throws SQLException {
            ArrayList<MessageRecipientInfo> messageRecipientInfosToCreate = new ArrayList<MessageRecipientInfo>();
            for (Contact contact : this.contacts) {
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().getOrCreateContactRef(contact);
                IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateContactRef(contactRef);
                byte[] engineMessageIdentifier = (byte[])postMessageOutput.getMessageIdentifierByContactIdentity().get(new ObvBytesKey(contact.getBytesContactIdentity()));
                MessageRecipientInfo messageRecipientInfo = new MessageRecipientInfo(this.outboundMessage, identityRef, engineMessageIdentifier, returnReceiptNonce, returnReceiptKey);
                messageRecipientInfosToCreate.add(messageRecipientInfo);
            }
            this.contacts.clear();
            if (this.shouldBeSentToOwnedOtherDevices) {
                IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)this.ownedIdentity.getItemId());
                messageRecipientInfosToCreate.add(new MessageRecipientInfo(this.outboundMessage, ownedIdentityRef, (byte[])postMessageOutput.getMessageIdentifierByContactIdentity().get(new ObvBytesKey(this.ownedIdentity.getBytesOwnedIdentity())), returnReceiptNonce, returnReceiptKey));
            }
            this.shouldBeSentToOwnedOtherDevices = false;
            if (DbManager.getInstance().getMessageRecipientInfoDao().create(messageRecipientInfosToCreate) != messageRecipientInfosToCreate.size()) {
                throw new SQLException("UseMessagePostHelper::post couldn't insert message recipient info");
            }
            return messageRecipientInfosToCreate;
        }

        void deletePendingMessageIfNecessary() throws SQLException {
            for (PendingMessage pendingMessage : this.pendingMessagesToDelete) {
                DbManager.getInstance().getPendingMessageDao().delete(pendingMessage);
            }
            this.pendingMessagesToDelete.clear();
        }
    }
}

